/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions;

import com.intellij.swagger.reference.definitions.SwCoordinateItem;
import com.intellij.swagger.reference.definitions.SwDefinitionReferenceBuilderKt;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/swagger/reference/definitions/SwObjectCoordinates;", "", "objectsStorageUri", "Lcom/intellij/swagger/reference/definitions/SwCoordinateItem;", "objectDefinition", "Lcom/intellij/swagger/reference/definitions/SwCoordinateItem$SwDefinitionItem;", "(Lcom/intellij/swagger/reference/definitions/SwCoordinateItem;Lcom/intellij/swagger/reference/definitions/SwCoordinateItem$SwDefinitionItem;)V", "definitionCoordinates", "", "getDefinitionCoordinates", "()Ljava/lang/String;", "uriValue", "getUriValue", "computeCompletedStorageUriSegment", "Lkotlin/Pair;", "caretOffsetInElement", "", "hasCompletedRelativePath", "", "isDefinitionEdited", "isEmpty", "isStorageEdited", "isWebCoordinates", "intellij.swagger"})
public final class SwObjectCoordinates {
    private final SwCoordinateItem objectsStorageUri;
    private final SwCoordinateItem.SwDefinitionItem objectDefinition;

    @Nullable
    public final String getUriValue() {
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        return swCoordinateItem != null ? swCoordinateItem.getValue() : null;
    }

    @Nullable
    public final String getDefinitionCoordinates() {
        SwCoordinateItem.SwDefinitionItem swDefinitionItem = this.objectDefinition;
        return swDefinitionItem != null ? swDefinitionItem.getValue() : null;
    }

    public final boolean isEmpty() {
        return SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectsStorageUri) && SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectDefinition);
    }

    public final boolean isWebCoordinates() {
        return this.objectsStorageUri instanceof SwCoordinateItem.SwWebUrlItem;
    }

    public final boolean isStorageEdited(int caretOffsetInElement) {
        boolean isCaretInUriRange;
        boolean bl;
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        if (swCoordinateItem != null && (swCoordinateItem = swCoordinateItem.getRangeInElement()) != null) {
            int n = 0;
            int n2 = caretOffsetInElement - 1;
            boolean bl2 = false;
            bl = swCoordinateItem.contains(Math.max(n, n2));
        } else {
            bl = isCaretInUriRange = false;
        }
        if (!isCaretInUriRange) {
            return false;
        }
        return !this.hasCompletedRelativePath();
    }

    public final boolean isDefinitionEdited(int caretOffsetInElement) {
        boolean bl;
        SwCoordinateItem.SwDefinitionItem swDefinitionItem = this.objectDefinition;
        if (swDefinitionItem != null && (swDefinitionItem = swDefinitionItem.getRangeInElement()) != null) {
            int n = 0;
            int n2 = caretOffsetInElement - 1;
            boolean bl2 = false;
            bl = swDefinitionItem.contains(Math.max(n, n2));
        } else {
            bl = false;
        }
        boolean isCaretInDefinitionRange = bl;
        return isCaretInDefinitionRange || this.hasCompletedRelativePath();
    }

    @Nullable
    public final Pair<String, String> computeCompletedStorageUriSegment(int caretOffsetInElement) {
        Pair pair;
        if (this.objectsStorageUri == null) {
            return null;
        }
        int n = this.objectsStorageUri.getValue().length();
        boolean bl = false;
        int caretOffsetInValue = Math.min(n, caretOffsetInElement);
        String string = this.objectsStorageUri.getValue();
        int n2 = 0;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n2, caretOffsetInValue);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substringBeforeCaret = string3;
        int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)substringBeforeCaret, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (lastSlashIndex == -1) {
            pair = TuplesKt.to((Object)substringBeforeCaret, (Object)"");
        } else {
            String string4 = substringBeforeCaret;
            int n3 = 0;
            int n4 = 0;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n3, lastSlashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String completeSegment = string6;
            String string7 = substringBeforeCaret;
            n4 = lastSlashIndex + 1;
            boolean bl3 = false;
            String string8 = string7;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n4);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String incompleteSegment = string9;
            pair = TuplesKt.to((Object)completeSegment, (Object)incompleteSegment);
        }
        return pair;
    }

    private final boolean hasCompletedRelativePath() {
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        String string = swCoordinateItem != null ? swCoordinateItem.getValue() : null;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = PathUtil.getFileName((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PathUtil.getFileName(obj\u2026rageUri?.value.orEmpty())");
        String fileName = string3;
        String fileExtension = PathUtil.getFileExtension((String)fileName);
        CharSequence charSequence = fileExtension;
        boolean bl2 = false;
        boolean bl3 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    public SwObjectCoordinates(@Nullable SwCoordinateItem objectsStorageUri, @Nullable SwCoordinateItem.SwDefinitionItem objectDefinition) {
        this.objectsStorageUri = objectsStorageUri;
        this.objectDefinition = objectDefinition;
    }

    public /* synthetic */ SwObjectCoordinates(SwCoordinateItem swCoordinateItem, SwCoordinateItem.SwDefinitionItem swDefinitionItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            swCoordinateItem = null;
        }
        if ((n & 2) != 0) {
            swDefinitionItem = null;
        }
        this(swCoordinateItem, swDefinitionItem);
    }

    public SwObjectCoordinates() {
        this(null, null, 3, null);
    }
}

