/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwMetaHolder;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.providers.resolve.SwMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"resolveLocalObject", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "path", "", "", "(Lcom/intellij/psi/PsiFile;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "resolveUrl", "", "Lcom/intellij/swagger/providers/resolve/SwMapping;", "searchedUrl", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.swagger"})
public final class SpecificationResolveHelperKt {
    @NotNull
    public static final List<SwMapping> resolveUrl(@NotNull String searchedUrl, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)searchedUrl, (String)"searchedUrl");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Project project = scope.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"scope.project ?: return emptyList()");
        Project project2 = project;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SwaggerMergedModel.Companion.getInstance(project2).getBaseModelElements(scope)), (Function1)((Function1)new Function1<SwModelBase, SwModelBase>(project2){
            final /* synthetic */ Project $project;

            @NotNull
            public final SwModelBase invoke(@NotNull SwModelBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.substitute(this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })), (Function1)((Function1)new Function1<SwModelBase, SwMapping>(searchedUrl){
            final /* synthetic */ String $searchedUrl;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SwMapping invoke(@NotNull SwModelBase model) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Iterable $this$filter$iv = CollectionsKt.plus((Collection)model.getBasePaths(), (Iterable)model.getUrls());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    SwUrl url2 = (SwUrl)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)url2.getUrlString(), (Object)this.$searchedUrl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List urls = (List)destination$iv$iv;
                Collection collection = urls;
                boolean bl = false;
                return !collection.isEmpty() ? new SwMapping(model, urls) : null;
            }
            {
                this.$searchedUrl = string;
                super(1);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final PsiElement resolveLocalObject(@NotNull PsiFile psiFile, String ... path) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
        SwaggerMergedModel swaggerMergedModel = SwaggerMergedModel.Companion.getInstance(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(psiFile)");
        SwModelBase swModelBase = (SwModelBase)CollectionsKt.firstOrNull(swaggerMergedModel.getBaseModelElements(globalSearchScope));
        SwModelElement swModelElement = swModelBase;
        if (swModelBase == null) return null;
        SwModelBase swModelBase2 = swModelElement;
        boolean bl = false;
        boolean bl2 = false;
        SwModelBase it = swModelBase2;
        boolean bl3 = false;
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiFile.project");
        SwModelBase swModelBase3 = it.substitute(project2);
        if (!(swModelBase3 instanceof SwMetaHolder)) {
            swModelBase3 = null;
        }
        SwMetaHolder swMetaHolder = (SwMetaHolder)((Object)swModelBase3);
        swModelElement = swMetaHolder;
        if (swMetaHolder == null) return null;
        PsiElement psiElement = swModelElement.find(Arrays.copyOf(path, path.length));
        return psiElement;
    }
}

