/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.documentation.SwUrlFakeElement;
import com.intellij.swagger.model.api.SwHttpOperation;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.providers.SwTargetInfo;
import com.intellij.swagger.providers.SwUrlTargetInfo;
import com.intellij.swagger.providers.resolve.SwUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010\u001f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/swagger/providers/SwUrlTargetInfo;", "Lcom/intellij/swagger/providers/SwTargetInfo;", "schemes", "", "", "authorities", "Lcom/intellij/microservices/url/Authority;", "path", "Lcom/intellij/microservices/url/UrlPath;", "url", "Lcom/intellij/swagger/model/api/SwUrl;", "model", "Lcom/intellij/swagger/model/api/SwModelBase;", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/microservices/url/UrlPath;Lcom/intellij/swagger/model/api/SwUrl;Lcom/intellij/swagger/model/api/SwModelBase;)V", "getAuthorities", "()Ljava/util/List;", "documentationPsiElement", "Lcom/intellij/psi/PsiElement;", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "isDeprecated", "", "()Z", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "getSchemes", "source", "getSource", "()Ljava/lang/String;", "resolveToPsiElement", "intellij.swagger"})
public final class SwUrlTargetInfo
extends SwTargetInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final UrlPath path;
    private final SwUrl url;
    private final SwModelBase model;

    public boolean isDeprecated() {
        Object object = (SwHttpOperation)CollectionsKt.firstOrNull(this.url.getSupportedOperations());
        return object != null && (object = object.isDeprecated()) != null && (object = (Boolean)object.getValue()) != null ? (Boolean)object : false;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.url.getSourcePsi();
    }

    @NotNull
    public String getSource() {
        if (this.model.isRemote()) {
            Object object = CollectionsKt.firstOrNull(this.getAuthorities());
            if (!(object instanceof Authority.Exact)) {
                object = null;
            }
            Authority.Exact exact = (Authority.Exact)object;
            String authority = exact != null ? exact.getText() : null;
            return SwaggerUtilsKt.getEndpointLocation(authority, this.model.getBasePaths());
        }
        Object object = this.url.getSourcePsi();
        if (object == null || (object = object.getContainingFile()) == null || (object = object.getName()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        SwUrlFakeElement swUrlFakeElement;
        PsiElement psiElement = this.url.getSourcePsi();
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement2;
            boolean bl3 = false;
            swUrlFakeElement = new SwUrlFakeElement(it, this.url.getUrlString());
        } else {
            swUrlFakeElement = null;
        }
        return (PsiElement)swUrlFakeElement;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.url.getSupportedOperations()), (Function1)queryParameters.1.INSTANCE));
    }

    @Override
    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @Override
    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @Override
    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    public SwUrlTargetInfo(@NotNull List<String> schemes2, @NotNull List<? extends Authority> authorities2, @NotNull UrlPath path, @NotNull SwUrl url2, @NotNull SwModelBase model) {
        Intrinsics.checkNotNullParameter(schemes2, (String)"schemes");
        Intrinsics.checkNotNullParameter(authorities2, (String)"authorities");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(schemes2, authorities2, path, SwUtilsKt.swUrlHttpMethods(url2));
        this.schemes = schemes2;
        this.authorities = authorities2;
        this.path = path;
        this.url = url2;
        this.model = model;
    }
}

