/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwAuthority;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwSchema;
import com.intellij.swagger.model.api.SwUrl;
import com.intellij.swagger.providers.SwUrlTargetInfo;
import com.intellij.swagger.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.providers.resolve.SwMapping;
import com.intellij.swagger.providers.resolve.SwUrlPathSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Swagger", icon="SwaggerIcons.Endpoint")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/providers/SwUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "authorityHints", "", "Lcom/intellij/microservices/url/Authority$Exact;", "getAuthorityHints", "()Ljava/util/List;", "model", "Lcom/intellij/swagger/model/SwaggerMergedModel;", "projectSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "supportedSchemes", "", "getSupportedSchemes", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.swagger"})
public final class SwUrlResolver
implements UrlResolver {
    private final SwaggerMergedModel model;
    private final GlobalSearchScope projectSearchScope;
    private final Project myProject;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Authority.Exact> getAuthorityHints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getAuthorities(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwAuthority swAuthority = (SwAuthority)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Authority.Exact exact = new Authority.Exact(it.getAuthorityValue().getValue());
            collection.add(exact);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupportedSchemes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getSchemes(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwSchema swSchema = (SwSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = SwaggerUtilsKt.withEndingSlash(it.getSchemaValue().getValue());
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List<String> schemes2 = this.getSupportedSchemes();
        List<Authority.Exact> authorities2 = this.getAuthorityHints();
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends SwUrlTargetInfo>>(this, schemes2, authorities2){
            final /* synthetic */ SwUrlResolver this$0;
            final /* synthetic */ List $schemes;
            final /* synthetic */ List $authorities;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Sequence<SwUrlTargetInfo> invoke(@NotNull UrlPath path) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                String urlPath = SwaggerUtilsKt.withLeadingSlash(path.toStringWithStars());
                Iterable $this$flatMap$iv = SpecificationResolveHelperKt.resolveUrl(urlPath, SwUrlResolver.access$getProjectSearchScope$p(this.this$0));
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    SwMapping swUrls = (SwMapping)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = swUrls.getUrls();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void swUrl;
                        SwUrl swUrl2 = (SwUrl)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        SwUrlTargetInfo swUrlTargetInfo = new SwUrlTargetInfo(this.$schemes, this.$authorities, path, (SwUrl)swUrl, swUrls.getModel());
                        collection.add(swUrlTargetInfo);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            }
            {
                this.this$0 = swUrlResolver;
                this.$schemes = list;
                this.$authorities = list2;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        List<String> schemes2 = this.getSupportedSchemes();
        List<Authority.Exact> authorities2 = this.getAuthorityHints();
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.model.getBaseModelElements(this.projectSearchScope)), (Function1)((Function1)new Function1<SwModelBase, List<? extends SwUrlTargetInfo>>(this, schemes2, authorities2){
            final /* synthetic */ SwUrlResolver this$0;
            final /* synthetic */ List $schemes;
            final /* synthetic */ List $authorities;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<SwUrlTargetInfo> invoke(@NotNull SwModelBase swModel) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)swModel, (String)"swModel");
                SwModelBase swModelBase = swModel.substitute(SwUrlResolver.access$getMyProject$p(this.this$0));
                boolean bl = false;
                boolean bl2 = false;
                SwModelBase substituted = swModelBase;
                boolean bl3 = false;
                Iterable $this$map$iv = substituted.getUrls();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void swUrl;
                    SwUrl swUrl2 = (SwUrl)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    SwUrlTargetInfo swUrlTargetInfo = new SwUrlTargetInfo(this.$schemes, this.$authorities, SwUrlPathSpecification.INSTANCE.parsePath(swUrl.getUrlString()), (SwUrl)swUrl, substituted);
                    collection.add(swUrlTargetInfo);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = swUrlResolver;
                this.$schemes = list;
                this.$authorities = list2;
                super(1);
            }
        })));
    }

    public SwUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.model = SwaggerMergedModel.Companion.getInstance(this.myProject);
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"ProjectScope.getProjectScope(myProject)");
        this.projectSearchScope = globalSearchScope;
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectSearchScope$p(SwUrlResolver $this) {
        return $this.projectSearchScope;
    }

    public static final /* synthetic */ Project access$getMyProject$p(SwUrlResolver $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/swagger/providers/SwUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SwaggerMergedModel.Companion.getInstance(project).hasSpecifications() ? (UrlResolver)new SwUrlResolver(project) : null;
        }
    }
}

