/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.providers;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.providers.SpecificationJsonSchemaFileProvider;
import com.intellij.swagger.providers.SwJsonSchemaFileProviderFactory$Companion$WhenMappings;
import com.intellij.swagger.providers.SwJsonSchemaPatchUtils;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/swagger/providers/SwJsonSchemaFileProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.swagger"})
public final class SwJsonSchemaFileProviderFactory
implements JsonSchemaProviderFactory {
    private static final String SWAGGER_2_0_SCHEMA = "/schema/swagger_2_0.json";
    private static final String OPENAPI_3_0_0_SCHEMA = "/schema/openapi_3_0_0.json";
    private static final Key<CachedValue<LightVirtualFile>> SWAGGER_2_0_SCHEMA_KEY;
    private static final Key<CachedValue<LightVirtualFile>> OPENAPI_3_0_0_SCHEMA_KEY;
    public static final Companion Companion;

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object[])new SpecificationJsonSchemaFileProvider[]{new SpecificationJsonSchemaFileProvider(SpecificationType.SWAGGER_2, SwaggerBundle.message("swagger.2.0.json.schema.remote.url", new Object[0]), SwaggerBundle.message("swagger.2.0.json.schema", new Object[0]), project), new SpecificationJsonSchemaFileProvider(SpecificationType.OPENAPI_3, SwaggerBundle.message("openapi.3.json.schema.remote.url", new Object[0]), SwaggerBundle.message("openapi.3.json.schema", new Object[0]), project)});
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"Swagger20Schema");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<CachedValue<L\u2026File>>(\"Swagger20Schema\")");
        SWAGGER_2_0_SCHEMA_KEY = key;
        Key key2 = Key.create((String)"Openapi300Schema");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<CachedValue<L\u2026ile>>(\"Openapi300Schema\")");
        OPENAPI_3_0_0_SCHEMA_KEY = key2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\u0005\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\f\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/providers/SwJsonSchemaFileProviderFactory$Companion;", "", "()V", "OPENAPI_3_0_0_SCHEMA", "", "OPENAPI_3_0_0_SCHEMA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/testFramework/LightVirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "SWAGGER_2_0_SCHEMA", "SWAGGER_2_0_SCHEMA_KEY", "getKeyForSpecification", "specificationType", "Lcom/intellij/swagger/SpecificationType;", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getSchemaFile$intellij_swagger", "getSchemaResourcePath", "intellij.swagger"})
    public static final class Companion {
        @NotNull
        public final VirtualFile getSchemaFile$intellij_swagger(@NotNull SpecificationType specificationType2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)specificationType2), (String)"specificationType");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.getKeyForSpecification(specificationType2), (CachedValueProvider)new CachedValueProvider<LightVirtualFile>(specificationType2){
                final /* synthetic */ SpecificationType $specificationType;

                @Nullable
                public final CachedValueProvider.Result<LightVirtualFile> compute() {
                    String resourcePath = com.intellij.swagger.providers.SwJsonSchemaFileProviderFactory$Companion.access$getSchemaResourcePath(SwJsonSchemaFileProviderFactory.Companion, this.$specificationType);
                    VirtualFile virtualFile2 = SwaggerUtilsKt.getBundledResource(resourcePath);
                    if (virtualFile2 == null) {
                        throw (Throwable)new RuntimeException("No bundled json schema found in resources folder: '" + resourcePath + '\'');
                    }
                    VirtualFile schemaVirtualFile = virtualFile2;
                    String defaultSchemaContent = ((Object)LoadTextUtil.loadText((VirtualFile)schemaVirtualFile)).toString();
                    String patchedSchemaContent = SwJsonSchemaPatchUtils.INSTANCE.applySuitablePatches(defaultSchemaContent, this.$specificationType);
                    LightVirtualFile lightSchemaFile = new LightVirtualFile((Object)((Object)this.$specificationType) + ".json", (CharSequence)patchedSchemaContent);
                    return new CachedValueProvider.Result((Object)lightSchemaFile, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                {
                    this.$specificationType = specificationType2;
                }
            }, false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getM\u2026_CHANGED)\n      }, false)");
            return (VirtualFile)object;
        }

        private final Key<CachedValue<LightVirtualFile>> getKeyForSpecification(SpecificationType specificationType2) {
            Key key;
            switch (SwJsonSchemaFileProviderFactory$Companion$WhenMappings.$EnumSwitchMapping$0[specificationType2.ordinal()]) {
                case 1: 
                case 2: {
                    key = SWAGGER_2_0_SCHEMA_KEY;
                    break;
                }
                case 3: 
                case 4: {
                    key = OPENAPI_3_0_0_SCHEMA_KEY;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("No cache key exist for specification type: " + (Object)((Object)specificationType2));
                }
            }
            return key;
        }

        private final String getSchemaResourcePath(SpecificationType specificationType2) {
            String string;
            switch (SwJsonSchemaFileProviderFactory$Companion$WhenMappings.$EnumSwitchMapping$1[specificationType2.ordinal()]) {
                case 1: 
                case 2: {
                    string = SwJsonSchemaFileProviderFactory.SWAGGER_2_0_SCHEMA;
                    break;
                }
                case 3: 
                case 4: {
                    string = SwJsonSchemaFileProviderFactory.OPENAPI_3_0_0_SCHEMA;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("No schema file exist for specification type: " + (Object)((Object)specificationType2));
                }
            }
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getSchemaResourcePath(Companion $this, SpecificationType specificationType2) {
            return $this.getSchemaResourcePath(specificationType2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

