/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.model.specification;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.index.OpenapiSpecificationContentIndex;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper$WhenMappings;
import com.intellij.swagger.model.specification.SwaggerFileHelperKt;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3LightSpecificationFile;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3SpecificationFile;
import com.intellij.swagger.model.specification.swagger.v2.Swagger2LightSpecificationFile;
import com.intellij.swagger.model.specification.swagger.v2.Swagger2SpecificationFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J4\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001bJ\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J0\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 J\u001a\u0010!\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010&\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0015\u0010'\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J\u001a\u0010)\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lcom/intellij/swagger/model/specification/SwaggerFileHelper;", "", "()V", "SPECIFICATION_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/swagger/SpecificationType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isSecondary", "()Lcom/intellij/openapi/util/Key;", "calculateSpecificationKind", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "calculateSpecificationKind$intellij_swagger", "collectSpecificationFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/model/specification/SwSpecificationFile;", "project", "Lcom/intellij/openapi/project/Project;", "createSpecificationFile", "isLight", "", "isRemote", "getOrComputeSpecificationKind", "getOrComputeSpecificationKind$intellij_swagger", "getSecondaryFileType", "getSpecificationFileFor", "hasSpecificationFilesInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "isOpenapi3File", "isSpecificationFastCheck", "isSpecificationFileOfKind", "specificationVersionPattern", "Lkotlin/text/Regex;", "isSuitableFile", "isSuitableFileType", "isSuitableFileType$intellij_swagger", "isSwagger2File", "intellij.swagger"})
public final class SwaggerFileHelper {
    private static final Key<CachedValue<SpecificationType>> SPECIFICATION_TYPE_KEY;
    @NotNull
    private static final Key<SpecificationType> isSecondary;
    public static final SwaggerFileHelper INSTANCE;

    public final boolean hasSpecificationFilesInScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Sequence<SwSpecificationFile> $this$any$iv = this.collectSpecificationFiles(project);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                SwSpecificationFile it = (SwSpecificationFile)element$iv;
                boolean bl2 = false;
                if (!SwaggerUtilsKt.isLocatedInScope(it, scope)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Sequence<SwSpecificationFile> collectSpecificationFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SequencesKt.mapNotNull(OpenapiSpecificationContentIndex.Companion.getAllIndexedFiles(project), (Function1)((Function1)new Function1<VirtualFile, SwSpecificationFile>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final SwSpecificationFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SwaggerFileHelper.getSpecificationFileFor$default(SwaggerFileHelper.INSTANCE, it, this.$project, false, false, 12, null);
            }
            {
                this.$project = project;
                super(1);
            }
        }));
    }

    @Nullable
    public final SwSpecificationFile getSpecificationFileFor(@Nullable VirtualFile virtualFile2, @Nullable Project project, boolean isLight, boolean isRemote) {
        if (virtualFile2 == null || project == null || !virtualFile2.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026rtualFile) ?: return null");
        PsiFile psiFile2 = psiFile;
        return this.createSpecificationFile(psiFile2, virtualFile2, project, isLight, isRemote);
    }

    public static /* synthetic */ SwSpecificationFile getSpecificationFileFor$default(SwaggerFileHelper swaggerFileHelper, VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.getSpecificationFileFor(virtualFile2, project, bl, bl2);
    }

    @Nullable
    public final SwSpecificationFile createSpecificationFile(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile2, @NotNull Project project, boolean isLight, boolean isRemote) {
        SwSpecificationFile swSpecificationFile;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SpecificationType specificationKind = isLight ? OpenapiSpecificationContentIndex.Companion.getSpecificationKind(virtualFile2, project) : this.calculateSpecificationKind$intellij_swagger(virtualFile2, psiFile);
        SmartPsiElementPointer<PsiElement> pointer = SwaggerUtilsKt.createPointer((PsiElement)psiFile);
        switch (SwaggerFileHelper$WhenMappings.$EnumSwitchMapping$0[specificationKind.ordinal()]) {
            case 1: {
                swSpecificationFile = isLight ? (Swagger2SpecificationFile)new Swagger2LightSpecificationFile(pointer, isRemote) : new Swagger2SpecificationFile(pointer, isRemote);
                break;
            }
            case 2: {
                swSpecificationFile = isLight ? (Openapi3SpecificationFile)new Openapi3LightSpecificationFile(pointer, isRemote) : new Openapi3SpecificationFile(pointer, isRemote);
                break;
            }
            default: {
                swSpecificationFile = null;
            }
        }
        return swSpecificationFile;
    }

    public static /* synthetic */ SwSpecificationFile createSpecificationFile$default(SwaggerFileHelper swaggerFileHelper, PsiFile psiFile, VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.createSpecificationFile(psiFile, virtualFile2, project, bl, bl2);
    }

    @NotNull
    public final SpecificationType calculateSpecificationKind$intellij_swagger(@NotNull VirtualFile virtualFile2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return !this.isSuitableFile(virtualFile2, psiFile) ? SpecificationType.NONE : (this.isSwagger2File(virtualFile2, psiFile) ? SpecificationType.SWAGGER_2 : (this.isOpenapi3File(virtualFile2, psiFile) ? SpecificationType.OPENAPI_3 : SpecificationType.NONE));
    }

    public static /* synthetic */ SpecificationType calculateSpecificationKind$intellij_swagger$default(SwaggerFileHelper swaggerFileHelper, VirtualFile virtualFile2, PsiFile psiFile, int n, Object object) {
        if ((n & 2) != 0) {
            psiFile = null;
        }
        return swaggerFileHelper.calculateSpecificationKind$intellij_swagger(virtualFile2, psiFile);
    }

    @NotNull
    public final Key<SpecificationType> isSecondary() {
        return isSecondary;
    }

    private final SpecificationType getSecondaryFileType(PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        return psiFile2 != null ? (SpecificationType)((Object)psiFile2.getUserData(isSecondary)) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpecificationType getOrComputeSpecificationKind$intellij_swagger(@NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        SpecificationType specificationType2 = this.getSecondaryFileType(psiFile);
        if (specificationType2 == null) {
            void project$iv;
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
            Project project2 = project;
            Key<CachedValue<SpecificationType>> key$iv = SPECIFICATION_TYPE_KEY;
            boolean $i$f$cacheOnFileTypeTracker = false;
            specificationType2 = (SpecificationType)((Object)CachedValuesManager.getManager((Project)project$iv).getCachedValue((UserDataHolder)psiFile, key$iv, new CachedValueProvider<T>((Project)project$iv, virtualFile2, psiFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                final /* synthetic */ PsiFile $psiFile$inlined;
                {
                    this.$project = project;
                    this.$virtualFile$inlined = virtualFile2;
                    this.$psiFile$inlined = psiFile;
                }

                @Nullable
                public final CachedValueProvider.Result<T> compute() {
                    boolean bl = false;
                    SpecificationType result = SwaggerFileHelper.INSTANCE.calculateSpecificationKind$intellij_swagger(this.$virtualFile$inlined, this.$psiFile$inlined);
                    return new CachedValueProvider.Result((Object)((Object)result), new Object[]{SwaggerUtilsKt.getYamlJsonModificationTracker(this.$project)});
                }
            }, false));
        }
        return specificationType2;
    }

    private final boolean isSpecificationFastCheck(VirtualFile virtualFile2, PsiFile psiFile) {
        String string;
        int n;
        int n2;
        CharSequence charSequence;
        String string2 = virtualFile2.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"virtualFile.nameWithoutExtension");
        String nameWithoutExtension = string2;
        if (Intrinsics.areEqual((Object)nameWithoutExtension, (Object)"swagger") || Intrinsics.areEqual((Object)nameWithoutExtension, (Object)"openapi")) {
            return true;
        }
        String string3 = psiFile.getText();
        if (string3 != null) {
            charSequence = string3;
            n2 = 0;
            n = RangesKt.coerceAtMost((int)psiFile.getTextLength(), (int)100);
            boolean bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)charSequence2).substring(n2, n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        String substring = string;
        charSequence = substring;
        n2 = 0;
        n = 0;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && (StringsKt.contains$default((CharSequence)substring, (CharSequence)"swagger", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)substring, (CharSequence)"openapi", (boolean)false, (int)2, null));
    }

    public final boolean isSuitableFileType$intellij_swagger(@NotNull VirtualFile virtualFile2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (virtualFile2.getFileType() instanceof YAMLFileType) {
            bl = true;
        } else if (virtualFile2.getFileType() instanceof JsonFileType) {
            bl = true;
        } else if (ScratchUtil.isScratch((VirtualFile)virtualFile2)) {
            String string = virtualFile2.getExtension();
            boolean bl2 = false;
            boolean bl3 = false;
            String $this$with = string;
            boolean bl4 = false;
            bl = StringsKt.equals$default((String)$this$with, (String)"yaml", (boolean)false, (int)2, null) || StringsKt.equals$default((String)$this$with, (String)"yml", (boolean)false, (int)2, null) || StringsKt.equals$default((String)$this$with, (String)"json", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isSuitableFile(VirtualFile virtualFile2, PsiFile psiFile) {
        return !virtualFile2.isDirectory() && virtualFile2.isValid() && this.isSuitableFileType$intellij_swagger(virtualFile2) && (psiFile == null || this.isSpecificationFastCheck(virtualFile2, psiFile)) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile2);
    }

    private final boolean isSwagger2File(VirtualFile virtualFile2, PsiFile psiFile) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getSWAGGER_2_PATTERN$p(), virtualFile2, psiFile);
    }

    private final boolean isOpenapi3File(VirtualFile virtualFile2, PsiFile psiFile) {
        return this.isSpecificationFileOfKind(SwaggerFileHelperKt.access$getOPENAPI_3_PATTERN$p(), virtualFile2, psiFile);
    }

    private final boolean isSpecificationFileOfKind(Regex specificationVersionPattern, VirtualFile virtualFile2, PsiFile psiFile) {
        boolean bl;
        Object object = psiFile;
        if (object != null && (object = object.getText()) != null) {
            CharSequence charSequence = (CharSequence)object;
            boolean bl2 = false;
            bl = specificationVersionPattern.containsMatchIn(charSequence);
        } else {
            CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)virtualFile2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"LoadTextUtil.loadText(virtualFile)");
            CharSequence charSequence2 = charSequence;
            boolean bl3 = false;
            bl = specificationVersionPattern.containsMatchIn(charSequence2);
        }
        return bl;
    }

    private SwaggerFileHelper() {
    }

    static {
        SwaggerFileHelper swaggerFileHelper;
        INSTANCE = swaggerFileHelper = new SwaggerFileHelper();
        Key key = Key.create((String)"swSpecificationType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<CachedValue<S\u2026>>(\"swSpecificationType\")");
        SPECIFICATION_TYPE_KEY = key;
        Key key2 = Key.create((String)"isSecondaryOpenAPIFile");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"isSecondaryOpenAPIFile\")");
        isSecondary = key2;
    }
}

