/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.index.OpenapiSpecificationContentIndex;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"getSpecificationFileType", "Lcom/intellij/swagger/SpecificationType;", "psiFile", "Lcom/intellij/psi/PsiFile;", "isSpecificationFile", "", "intellij.swagger"})
public final class OpenapiSpecificationContentIndexKt {
    public static final boolean isSpecificationFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        SpecificationType type2 = OpenapiSpecificationContentIndexKt.getSpecificationFileType(psiFile);
        return type2 == SpecificationType.SWAGGER_2 || type2 == SpecificationType.OPENAPI_3;
    }

    @Nullable
    public static final SpecificationType getSpecificationFileType(@NotNull PsiFile psiFile) {
        SpecificationType specificationType2;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiFile psiFile2 = psiFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"psiFile.originalFile");
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        if (virtualFile2 == null) {
            return SpecificationType.NONE;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (OpenapiSpecificationContentIndex.Companion.getContentsForFile(psiFile).keySet().isEmpty()) {
            specificationType2 = SwaggerFileHelper.INSTANCE.getOrComputeSpecificationKind$intellij_swagger(virtualFile3, psiFile);
        } else {
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
            specificationType2 = OpenapiSpecificationContentIndex.Companion.getSpecificationKind(virtualFile3, project);
        }
        return specificationType2;
    }
}

