/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.documentation;

import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.documentation.SwDocumentation$WhenMappings;
import com.intellij.swagger.documentation.SwDocumentationUtilsKt;
import com.intellij.swagger.documentation.SwUrlFakeElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0003J\b\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/documentation/SwDocumentation;", "", "swElement", "Lcom/intellij/swagger/documentation/SwUrlFakeElement;", "(Lcom/intellij/swagger/documentation/SwUrlFakeElement;)V", "generateDoc", "", "getContent", "getSpecificationLink", "Lcom/intellij/openapi/util/text/HtmlChunk;", "Companion", "intellij.swagger"})
public final class SwDocumentation {
    private final SwUrlFakeElement swElement;
    private static final String OPENAPI_SPECIFICATION_URL = "https://swagger.io/specification/";
    private static final String SWAGGER_SPECIFICATION_URL = "https://swagger.io/specification/v2/";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generateDoc() {
        String string = new HtmlBuilder().append(this.getSpecificationLink()).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)this.getContent()).wrapWith("pre")).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder()\n    .appen\u2026h(\"pre\"))\n    .toString()");
        return string;
    }

    @NlsSafe
    private final String getContent() {
        PsiElement parentPsi = this.swElement.getParent();
        return parentPsi instanceof JsonProperty ? SwDocumentationUtilsKt.jsonDocumentationFragment$default((JsonProperty)parentPsi, false, 2, null) : (parentPsi instanceof YAMLKeyValue ? SwDocumentationUtilsKt.yamlDocumentationFragment$default((YAMLKeyValue)parentPsi, false, 2, null) : "");
    }

    @NlsSafe
    private final HtmlChunk getSpecificationLink() {
        String string;
        switch (SwDocumentation$WhenMappings.$EnumSwitchMapping$0[this.swElement.getSpecificationType().ordinal()]) {
            case 1: {
                string = OPENAPI_SPECIFICATION_URL;
                break;
            }
            case 2: {
                string = SWAGGER_SPECIFICATION_URL;
                break;
            }
            default: {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"HtmlChunk.empty()");
                return htmlChunk;
            }
        }
        String specUrl = string;
        HtmlChunk.Element element = HtmlChunk.link((String)specUrl, (String)this.swElement.getSpecificationType().getPresentableName());
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlChunk.link(specUrl, \u2026tionType.presentableName)");
        return (HtmlChunk)element;
    }

    public SwDocumentation(@NotNull SwUrlFakeElement swElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)swElement), (String)"swElement");
        this.swElement = swElement;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/swagger/documentation/SwDocumentation$Companion;", "", "()V", "OPENAPI_SPECIFICATION_URL", "", "SWAGGER_SPECIFICATION_URL", "intellij.swagger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

