/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.codegen;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.codegen.CodegenConfiguration;
import com.intellij.swagger.codegen.SwJdkUtilsKt;
import com.intellij.swagger.codegen.SwaggerCodegenRunConfiguration;
import com.intellij.swagger.codegen.completion.CodegenMetadata;
import com.intellij.swagger.codegen.completion.SwaggerCodegenMetaProvider;
import com.intellij.swagger.index.OpenapiSpecificationContentIndex;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"SWAGGER_GENERATOR_VERSION_2", "Lkotlin/text/Regex;", "checkFileExists", "", "path", "", "fieldName", "isFile", "", "checkGeneratorPath", "text", "checkJre", "configuration", "Lcom/intellij/swagger/codegen/SwaggerCodegenRunConfiguration;", "checkLanguage", "checkSpecificationPath", "checkSwaggerCodegenRunConfiguration", "checkTargetDirectoryPath", "checkTextIsNotEmpty", "checkVersionConforms", "intellij.swagger"})
public final class RunConfigurationValidatorKt {
    private static final Regex SWAGGER_GENERATOR_VERSION_2;

    public static final void checkSwaggerCodegenRunConfiguration(@NotNull SwaggerCodegenRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RunConfigurationValidatorKt.checkJre(configuration);
        RunConfigurationValidatorKt.checkSpecificationPath(configuration.getSpecificationPath());
        RunConfigurationValidatorKt.checkGeneratorPath(configuration.getLocalGeneratorPath());
        RunConfigurationValidatorKt.checkTargetDirectoryPath(configuration.getGenerateToPath());
        RunConfigurationValidatorKt.checkVersionConforms(configuration);
        RunConfigurationValidatorKt.checkLanguage(configuration);
    }

    private static final void checkVersionConforms(SwaggerCodegenRunConfiguration configuration) {
        String jdkPath = SwJdkUtilsKt.findJdkPathByShortName(configuration.getJdkPath());
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        Object object = SwaggerCodegenMetaProvider.Companion.getInstance(project).getCodegenMetadata(new CodegenConfiguration(jdkPath, configuration.getLocalGeneratorPath(), null, 4, null));
        if (object == null || (object = ((CodegenMetadata)object).getVersion()) == null) {
            return;
        }
        Object version = object;
        if (!SWAGGER_GENERATOR_VERSION_2.matches((CharSequence)version)) {
            return;
        }
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(configuration.getSpecificationPath()), (boolean)false);
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VfsUtil.findFileByIoFile\u2026Path()), false) ?: return");
        VirtualFile specificationFile = virtualFile2;
        SpecificationType specificationType2 = (SpecificationType)((Object)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<SpecificationType, Throwable>(specificationFile, configuration){
            final /* synthetic */ VirtualFile $specificationFile;
            final /* synthetic */ SwaggerCodegenRunConfiguration $configuration;

            public final SpecificationType compute() {
                Project project = this.$configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
                return OpenapiSpecificationContentIndex.Companion.getSpecificationKind(this.$specificationFile, project);
            }
            {
                this.$specificationFile = virtualFile2;
                this.$configuration = swaggerCodegenRunConfiguration;
            }
        })));
        if (specificationType2 == SpecificationType.OPENAPI_3) {
            throw (Throwable)new RuntimeConfigurationWarning(SwaggerBundle.message("run.configuration.codegen.validation.generator.doesnt.conform", new Object[0]));
        }
    }

    private static final void checkSpecificationPath(String text) {
        RunConfigurationValidatorKt.checkFileExists(text, SwaggerBundle.message("run.configuration.codegen.specification.path", new Object[0]), true);
    }

    private static final void checkTargetDirectoryPath(String text) {
        RunConfigurationValidatorKt.checkFileExists(text, SwaggerBundle.message("run.configuration.codegen.generate.to", new Object[0]), false);
    }

    private static final void checkGeneratorPath(String text) {
        RunConfigurationValidatorKt.checkFileExists(text, SwaggerBundle.message("run.configuration.codegen.generator.selection", new Object[0]), true);
    }

    private static final void checkLanguage(SwaggerCodegenRunConfiguration configuration) {
        String language = configuration.getLanguage();
        RunConfigurationValidatorKt.checkTextIsNotEmpty(language, SwaggerBundle.message("run.configuration.codegen.language", new Object[0]));
        String jdkPath = SwJdkUtilsKt.findJdkPathByShortName(configuration.getJdkPath());
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        Object object = SwaggerCodegenMetaProvider.Companion.getInstance(project).getCodegenMetadata(new CodegenConfiguration(jdkPath, configuration.getLocalGeneratorPath(), null, 4, null));
        if (object == null || (object = ((CodegenMetadata)object).getSupportedLanguages()) == null) {
            return;
        }
        Object supportedLanguages = object;
        if (!supportedLanguages.contains(language)) {
            throw (Throwable)new RuntimeConfigurationWarning(SwaggerBundle.message("run.configuration.codegen.validation.unknown.language", new Object[0]));
        }
    }

    private static final void checkJre(SwaggerCodegenRunConfiguration configuration) {
        String jdkPath = SwJdkUtilsKt.findJdkPathByShortName(configuration.getJdkPath());
        CharSequence charSequence = jdkPath;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !new File(jdkPath).exists()) {
            throw (Throwable)new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.no.jdk", new Object[0]));
        }
    }

    private static final void checkTextIsNotEmpty(String text, String fieldName) {
        if (StringsKt.isBlank((CharSequence)text)) {
            throw (Throwable)new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.unspecified.0.property", fieldName));
        }
    }

    private static final void checkFileExists(String path, String fieldName, boolean isFile) {
        RunConfigurationValidatorKt.checkTextIsNotEmpty(path, fieldName);
        if (!new File(path).exists()) {
            throw (Throwable)new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.file.does.not.exist", fieldName));
        }
        if (isFile && !new File(path).isFile()) {
            throw (Throwable)new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.0.is.not.a.file", fieldName));
        }
        if (!isFile && !new File(path).isDirectory()) {
            throw (Throwable)new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.0.is.not.a.directory", fieldName));
        }
    }

    static {
        String string = "2\\.\\d\\.\\d";
        boolean bl = false;
        SWAGGER_GENERATOR_VERSION_2 = new Regex(string);
    }
}

