/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.wip.WipObjectKt$WhenMappings;
import org.jetbrains.wip.protocol.runtime.EntryPreviewValue;
import org.jetbrains.wip.protocol.runtime.ObjectPreviewValue;
import org.jetbrains.wip.protocol.runtime.PropertyPreviewValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"object2PropertyPVType", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue$Type;", "preview", "Lorg/jetbrains/wip/protocol/runtime/ObjectPreviewValue;", "renderMap", "", "entries", "", "Lorg/jetbrains/wip/protocol/runtime/EntryPreviewValue;", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "renderProperty", "property", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue;", "renderValue", "renderPrimitive", "", "type", "value", "", "intellij.javascript.wip.backend"})
public final class WipObjectKt {
    public static final void renderProperty(@NotNull PropertyPreviewValue property, @NotNull XValuePresentation.XValueTextRenderer renderer) {
        Object type;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Object object = property.getValue();
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.length() == 0)) {
            PropertyPreviewValue.Type type2 = property.type();
            String string = property.getValue();
            Intrinsics.checkNotNull((Object)string);
            if (!WipObjectKt.renderPrimitive(renderer, type2, string)) {
                String string2 = property.getValue();
                Intrinsics.checkNotNull((Object)string2);
                renderer.renderValue(string2);
            }
            return;
        }
        ObjectPreviewValue objectPreviewValue = property.getValuePreview();
        if (objectPreviewValue != null) {
            object = objectPreviewValue;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl3 = false;
            WipObjectKt.renderValue((ObjectPreviewValue)it, renderer);
            return;
        }
        Object object2 = property.getSubtype();
        if (object2 == null || (object2 = object2.name()) == null) {
            object2 = property.type().name();
        }
        Object object3 = type = object2;
        bl2 = false;
        Object object4 = object3;
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object4).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        renderer.renderValue(StringsKt.capitalize((String)string));
    }

    public static final boolean renderPrimitive(@NotNull XValuePresentation.XValueTextRenderer $this$renderPrimitive, @NotNull PropertyPreviewValue.Type type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$renderPrimitive, (String)"$this$renderPrimitive");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WipObjectKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                $this$renderPrimitive.renderKeywordValue(value);
                break;
            }
            case 4: 
            case 5: {
                $this$renderPrimitive.renderNumericValue(value);
                break;
            }
            case 6: {
                $this$renderPrimitive.renderStringValue(value, "\"\\", 1000);
                int actualStringLength = value.length();
                if (actualStringLength <= 1000) break;
                $this$renderPrimitive.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])new Object[]{actualStringLength}));
                break;
            }
            case 7: {
                $this$renderPrimitive.renderComment(VariableViewKt.trimFunctionDescription((String)value));
                break;
            }
            case 8: {
                return false;
            }
            default: {
                $this$renderPrimitive.renderValue(value);
            }
        }
        return true;
    }

    private static final void renderMap(List<? extends EntryPreviewValue> entries, XValuePresentation.XValueTextRenderer renderer) {
        boolean isFirst = true;
        for (EntryPreviewValue entryPreviewValue : entries) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            if (entryPreviewValue.getKey() != null) {
                ObjectPreviewValue objectPreviewValue;
                boolean bl = false;
                boolean bl2 = false;
                ObjectPreviewValue it = objectPreviewValue;
                boolean bl3 = false;
                WipObjectKt.renderValue(it, renderer);
                renderer.renderSpecialSymbol(" => ");
            }
            WipObjectKt.renderValue(entryPreviewValue.value(), renderer);
        }
    }

    private static final void renderValue(ObjectPreviewValue preview, XValuePresentation.XValueTextRenderer renderer) {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        String string = preview.getDescription();
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            if (WipObjectKt.renderPrimitive(renderer, WipObjectKt.object2PropertyPVType(preview), (String)it)) {
                return;
            }
            renderer.renderComment((String)it);
        }
        renderer.renderSpecialSymbol(" {");
        List<EntryPreviewValue> list = preview.getEntries();
        if (list != null) {
            object = list;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            WipObjectKt.renderMap((List<? extends EntryPreviewValue>)it, renderer);
        }
        boolean isFirst = true;
        for (PropertyPreviewValue property : preview.properties()) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            renderer.renderValue(property.name(), JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
            renderer.renderSpecialSymbol(": ");
            WipObjectKt.renderProperty(property, renderer);
        }
        if (preview.getOverflow()) {
            renderer.renderComment(",\n...");
        }
        renderer.renderSpecialSymbol("}");
    }

    @NotNull
    public static final PropertyPreviewValue.Type object2PropertyPVType(@NotNull ObjectPreviewValue preview) {
        PropertyPreviewValue.Type type;
        Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
        switch (WipObjectKt$WhenMappings.$EnumSwitchMapping$1[preview.type().ordinal()]) {
            case 1: {
                type = PropertyPreviewValue.Type.OBJECT;
                break;
            }
            case 2: {
                type = PropertyPreviewValue.Type.FUNCTION;
                break;
            }
            case 3: {
                type = PropertyPreviewValue.Type.UNDEFINED;
                break;
            }
            case 4: {
                type = PropertyPreviewValue.Type.STRING;
                break;
            }
            case 5: {
                type = PropertyPreviewValue.Type.NUMBER;
                break;
            }
            case 6: {
                type = PropertyPreviewValue.Type.BIGINT;
                break;
            }
            case 7: {
                type = PropertyPreviewValue.Type.BOOLEAN;
                break;
            }
            case 8: {
                type = PropertyPreviewValue.Type.SYMBOL;
                break;
            }
            case 9: {
                type = PropertyPreviewValue.Type.NO_ENUM_CONST;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type;
    }

    public static final /* synthetic */ void access$renderValue(ObjectPreviewValue preview, XValuePresentation.XValueTextRenderer renderer) {
        WipObjectKt.renderValue(preview, renderer);
    }
}

