/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.nwjs.NwjsProcessState;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PACKAGE_JSON", "", "SKIPPED_CONSOLE_MESSAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getMainUrl", "reader", "Ljava/io/Reader;", "getMainUrlFromManifest", "parent", "Ljava/io/File;", "parseRawUrl", "Lcom/intellij/util/Url;", "url", "parentPath", "intellij.javascript.chrome.connector"})
public final class NwjsProcessStateKt {
    private static final Logger LOG;
    private static final Pattern SKIPPED_CONSOLE_MESSAGE_PATTERN;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getMainUrl(Reader reader) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                if (Intrinsics.areEqual((Object)jsonReader.nextName(), (Object)"main")) {
                    String string = jsonReader.nextString();
                    return string;
                }
                jsonReader.skipValue();
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    private static final String getMainUrlFromManifest(File parent) {
        File file = new File(parent, PACKAGE_JSON);
        if (file.exists()) {
            BufferedReader bufferedReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"Files.newReader(file, Charsets.UTF_8)");
            return NwjsProcessStateKt.getMainUrl(bufferedReader);
        }
        throw (Throwable)new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.manifest.not.found", (Object[])new Object[0]));
    }

    private static final Url parseRawUrl(String url, String parentPath) {
        if (url == null) {
            throw (Throwable)new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.cannot.get.main.url", (Object[])new Object[0]));
        }
        String absoluteUrl = URLUtil.containsScheme((String)url) || SourceResolver.Companion.isAbsolute(url) ? url : "file://" + parentPath + '/' + url;
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl == null) {
            throw (Throwable)new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.cannot.parse.main.url", (Object[])new Object[]{absoluteUrl}));
        }
        if (parsedUrl.isInLocalFileSystem()) {
            Path path = Paths.get(parsedUrl.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(parsedUrl.path)");
            if (!PathKt.isFile((Path)path)) {
                throw (Throwable)new ExecutionException(JSDebuggerBundle.message((String)"nwjs.error.main.file.not.valid", (Object[])new Object[0]));
            }
        }
        return parsedUrl;
    }

    static {
        Logger logger = Logger.getInstance(NwjsProcessState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(NwjsProcessState::class.java)");
        LOG = logger;
        SKIPPED_CONSOLE_MESSAGE_PATTERN = Pattern.compile("^\\[\\d+:\\d+/\\d+:[A-Z]+:CONSOLE");
    }

    public static final /* synthetic */ String access$getMainUrlFromManifest(File parent) {
        return NwjsProcessStateKt.getMainUrlFromManifest(parent);
    }

    public static final /* synthetic */ Url access$parseRawUrl(String url, String parentPath) {
        return NwjsProcessStateKt.parseRawUrl(url, parentPath);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pattern access$getSKIPPED_CONSOLE_MESSAGE_PATTERN$p() {
        return SKIPPED_CONSOLE_MESSAGE_PATTERN;
    }
}

