/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.openapi.project.Project;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.extension.ExtBackedChromeConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebuggerEngine;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "()V", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "getBrowserFamily", "()Lcom/intellij/ide/browsers/BrowserFamily;", "createDebugProcess", "Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "initialUrl", "Lcom/intellij/util/Url;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "usePreliminaryPage", "", "intellij.javascript.chrome.connector"})
public class ChromeDebuggerEngine
extends JavaScriptDebugEngine {
    @NotNull
    private final BrowserFamily browserFamily = BrowserFamily.CHROME;

    @NotNull
    public BrowserFamily getBrowserFamily() {
        return this.browserFamily;
    }

    @NotNull
    public ChromeDebugProcess createDebugProcess(@NotNull XDebugSession session, @NotNull WebBrowser browser, @NotNull DebuggableFileFinder fileFinder, @Nullable Url initialUrl, @Nullable ExecutionResult executionResult, boolean usePreliminaryPage) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)fileFinder, (String)"fileFinder");
        ExtBackedChromeConnection connection2 = new ExtBackedChromeConnection(browser);
        BrowserChromeDebugProcess process2 = new BrowserChromeDebugProcess(session, fileFinder, (VmConnection<? extends WipVm>)((VmConnection)connection2), executionResult);
        Url url = initialUrl;
        Intrinsics.checkNotNull((Object)url);
        Project project = session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"session.project");
        connection2.open(url, project, usePreliminaryPage);
        return process2;
    }
}

