/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.attach;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.attach.JSDebuggerUrlFilterKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter;", "Lcom/intellij/execution/filters/UrlFilter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "buildHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "JSDebuggerStarterHyperlinkInfo", "intellij.javascript.chrome.connector"})
public final class JSDebuggerUrlFilter
extends UrlFilter {
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"http://", (boolean)false, (int)2, null)) break block4;
                    String[] $this$any$iv = JSDebuggerUrlFilterKt.access$getDEBUGGABLE_URL_PREFIXES$p();
                    boolean $i$f$any = false;
                    String[] stringArray = $this$any$iv;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = stringArray[i];
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block5;
            }
            return null;
        }
        return super.applyFilter(line, entireLength);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        boolean bl;
        HyperlinkInfo baseHyperlinkInfo;
        block2: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            HyperlinkInfo hyperlinkInfo = super.buildHyperlinkInfo(url);
            Intrinsics.checkNotNullExpressionValue((Object)hyperlinkInfo, (String)"super.buildHyperlinkInfo(url)");
            baseHyperlinkInfo = hyperlinkInfo;
            String[] $this$any$iv = JSDebuggerUrlFilterKt.access$getDEBUGGABLE_URL_PREFIXES$p();
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            return baseHyperlinkInfo;
        }
        return new JSDebuggerStarterHyperlinkInfo(url, baseHyperlinkInfo);
    }

    public JSDebuggerUrlFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter$JSDebuggerStarterHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "", "baseHyperlinkInfo", "(Ljava/lang/String;Lcom/intellij/execution/filters/HyperlinkInfo;)V", "getBaseHyperlinkInfo", "()Lcom/intellij/execution/filters/HyperlinkInfo;", "getUrl", "()Ljava/lang/String;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "showNotification", "startRunConfiguration", "intellij.javascript.chrome.connector"})
    public static final class JSDebuggerStarterHyperlinkInfo
    implements HyperlinkInfo {
        @NotNull
        private final String url;
        @NotNull
        private final HyperlinkInfo baseHyperlinkInfo;

        public void navigate(@Nullable Project project) {
            if (project == null) {
                this.baseHyperlinkInfo.navigate(project);
                return;
            }
            IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
            AWTEvent aWTEvent = ideEventQueue.getTrueCurrentEvent();
            Intrinsics.checkNotNullExpressionValue((Object)aWTEvent, (String)"IdeEventQueue.getInstance().trueCurrentEvent");
            AWTEvent currentEvent = aWTEvent;
            if (currentEvent instanceof MouseEvent && UIUtil.isControlKeyDown((MouseEvent)((MouseEvent)currentEvent)) && ((MouseEvent)currentEvent).isShiftDown()) {
                this.startRunConfiguration(project);
            } else {
                this.showNotification(project);
                this.baseHyperlinkInfo.navigate(project);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void startRunConfiguration(Project project) {
            void $this$filterTo$iv$iv;
            JavascriptDebugConfigurationType javascriptDebugConfigurationType = JavascriptDebugConfigurationType.getTypeInstance();
            Intrinsics.checkNotNullExpressionValue((Object)javascriptDebugConfigurationType, (String)"JavascriptDebugConfigurationType.getTypeInstance()");
            JavascriptDebugConfigurationType factory = javascriptDebugConfigurationType;
            RunManager runManager = RunManager.Companion.getInstance(project);
            if (!(runManager instanceof RunManagerImpl)) {
                runManager = null;
            }
            RunManagerImpl runManagerImpl = (RunManagerImpl)runManager;
            if (runManagerImpl == null) {
                return;
            }
            RunManagerImpl runManager2 = runManagerImpl;
            Iterable $this$filter$iv = runManager2.getConfigurationSettingsList((ConfigurationType)factory);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                if (!(runConfiguration instanceof JavaScriptDebugConfiguration)) {
                    runConfiguration = null;
                }
                JavaScriptDebugConfiguration javaScriptDebugConfiguration = (JavaScriptDebugConfiguration)runConfiguration;
                if (!Intrinsics.areEqual((Object)(javaScriptDebugConfiguration != null ? javaScriptDebugConfiguration.getUri() : null), (Object)this.url)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List availableConfigurationSettings = (List)destination$iv$iv;
            if (availableConfigurationSettings.size() == 1) {
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)availableConfigurationSettings.get(0)), (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
            } else if (availableConfigurationSettings.size() > 1) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = availableConfigurationSettings;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RunnerAndConfigurationSettings bl = (RunnerAndConfigurationSettings)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    collection.add(runConfiguration);
                }
                List configurations = (List)destination$iv$iv2;
                ListPopup popup2 = ConfigurationSelectionUtil.createPopup((Project)project, (RunManagerImpl)runManager2, (List)configurations, (BiConsumer)new BiConsumer<List<RunConfiguration>, ExecutionTarget>(runManager2){
                    final /* synthetic */ RunManagerImpl $runManager;

                    public final void accept(List<RunConfiguration> selected, ExecutionTarget $noName_1) {
                        Iterator<RunConfiguration> iterator = selected.iterator();
                        while (iterator.hasNext()) {
                            RunConfiguration configuration;
                            RunConfiguration runConfiguration = configuration = iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"configuration");
                            RunnerAndConfigurationSettings settings = this.$runManager.findSettings(runConfiguration);
                            if (settings == null) continue;
                            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
                        }
                    }
                    {
                        this.$runManager = runManagerImpl;
                    }
                });
                IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
                AWTEvent aWTEvent = ideEventQueue.getTrueCurrentEvent();
                Intrinsics.checkNotNullExpressionValue((Object)aWTEvent, (String)"IdeEventQueue.getInstance().trueCurrentEvent");
                AWTEvent event = aWTEvent;
                if (event instanceof MouseEvent) {
                    popup2.show(new RelativePoint((MouseEvent)event));
                } else {
                    popup2.showInFocusCenter();
                }
            } else {
                RunnerAndConfigurationSettings configurationSettings = runManager2.createConfiguration("JavaScript Debug", (ConfigurationFactory)factory);
                configurationSettings.setTemporary(true);
                RunConfiguration runConfiguration = configurationSettings.getConfiguration();
                if (runConfiguration == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
                }
                JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runConfiguration;
                configuration.setUri(this.url);
                configuration.setGeneratedName();
                runManager2.addConfiguration(configurationSettings);
                runManager2.setSelectedConfiguration(configurationSettings);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configurationSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
            }
        }

        private final void showNotification(Project project) {
            String string = JSDebuggerBundle.message((String)"js.debugger.terminal.start.debugger.from.url", (Object[])new Object[]{SystemInfo.isMac ? "Cmd" : "Ctrl", IdeBundle.message((String)"label.dont.show", (Object[])new Object[0])});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSDebuggerBundle.message\u2026ssage(\"label.dont.show\"))");
            String message = string;
            JSDebuggerUrlFilterKt.access$getNotificationManager$p().notify(message, project);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final HyperlinkInfo getBaseHyperlinkInfo() {
            return this.baseHyperlinkInfo;
        }

        public JSDebuggerStarterHyperlinkInfo(@NotNull String url, @NotNull HyperlinkInfo baseHyperlinkInfo) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)baseHyperlinkInfo, (String)"baseHyperlinkInfo");
            this.url = url;
            this.baseHyperlinkInfo = baseHyperlinkInfo;
        }
    }
}

