/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.ui.GenerateJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import com.intellij.ws.xml.jaxb.GenerateJAXBSchemasFromJavaDialog;
import com.intellij.ws.xml.jaxb.GenerateJavaFromJAXBSchemasAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenerateJavaFromJAXBSchemasDialog
extends GenerateJavaCodeDialogBase {
    private JComboBox myPackagePrefix;
    private JCheckBox myAddLibs;
    private JPanel myPanel;
    private ComboBox myOutputPaths;
    private JLabel myOutputPathsText;
    private JLabel myPackagePrefixText;
    private ComboboxWithBrowseButton myGenerateFromUrl;
    private JLabel myGenerateFromUrlText;
    private JCheckBox myMarkGeneratedCode;
    private JCheckBox myGeneratePackageLevelAnnotations;
    private JCheckBox myEnableSourceLocationSupport;
    private JCheckBox myGenerateSynchronizedAccessors;
    private JCheckBox myMakeFilesReadOnly;
    private JCheckBox myNoHeader;
    private JCheckBox myExternalBindings;
    private TextFieldWithBrowseButton myExternalBindingPath;

    GenerateJavaFromJAXBSchemasDialog(Project _project, @Nullable GenerateJavaFromJAXBSchemasDialog previousDialog) {
        super(_project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("generate.java.code.from.xml.schema.using.jaxb.dialog.title", objectArray));
        this.configureBrowseButton(this.myProject, this.myGenerateFromUrl, new String[]{"xsd", "dtd", "wsdl"}, WSBundle.message("generate.java.jaxb.select.xml.schema", new Object[0]), true);
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        List<String> lastUrls = instance.getLastJAXBUrls();
        this.configureComboBox(this.getUrl().getComboBox(), lastUrls);
        this.doInitFor(this.myGenerateFromUrlText, this.getUrl().getComboBox(), 'c');
        if (previousDialog != null) {
            this.myGeneratePackageLevelAnnotations.setSelected(previousDialog.myGeneratePackageLevelAnnotations.isSelected());
            this.myNoHeader.setSelected(previousDialog.doNotGenerateHeader());
        }
        this.myEnableSourceLocationSupport.setVisible(false);
        this.myGenerateSynchronizedAccessors.setVisible(false);
        this.myMakeFilesReadOnly.setSelected(instance.toMakeSelectedFilesReadOnly());
        this.myExternalBindings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateJavaFromJAXBSchemasDialog.this.myExternalBindingPath.setEnabled(GenerateJavaFromJAXBSchemasDialog.this.myExternalBindings.isSelected());
            }
        });
        this.myExternalBindingPath.getTextField().setHorizontalAlignment(10);
        this.myExternalBindingPath.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile virtualFile) {
                        return virtualFile.isDirectory() || "xjb".equals(virtualFile.getExtension());
                    }
                };
                descriptor.setTitle(WSBundle.message("generate.java.xjb.select.dir", new Object[0]));
                VirtualFile[] choose = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)GenerateJavaFromJAXBSchemasDialog.this.myProject, null);
                if (choose.length == 1 && choose[0] != null) {
                    GenerateJavaFromJAXBSchemasDialog.this.myExternalBindingPath.setText(choose[0].getPath());
                }
            }
        });
        this.init();
        this.restoreCommonFieldsFromPreviousSession(previousDialog);
    }

    @Override
    protected boolean isAcceptableFile(VirtualFile vf) {
        return vf != null && GenerateJavaFromJAXBSchemasAction.isAcceptableFileForGenerateJAXBJavaFromSchema(vf);
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        Module selectedModule = LibUtils.findModuleByOutputPath(this.myProject, this.myOutputPaths.getSelectedItem().toString());
        ValidationInfo result = GenerateJAXBSchemasFromJavaDialog.checkJWSDPPathSet(selectedModule);
        return result == null ? super.doValidate(_data) : result;
    }

    @Override
    protected void doOKAction() {
        WebServicesPluginSettings.getInstance().setToMakeSelectedFilesReadOnly(this.toMakeGeneratedCodeReadOnly());
        super.doOKAction();
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "GenerateJavaFromJAXBSchemas.html";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getAddLibs() {
        return this.myAddLibs;
    }

    @Override
    protected EditorComboBox getPackagePrefix() {
        return (EditorComboBox)this.myPackagePrefix;
    }

    protected JComboBox getOutputPaths() {
        return this.myOutputPaths;
    }

    @Override
    protected JLabel getOutputPathsText() {
        return this.myOutputPathsText;
    }

    @Override
    protected JLabel getPackagePrefixText() {
        return this.myPackagePrefixText;
    }

    @Override
    protected ComboboxWithBrowseButton getUrl() {
        return this.myGenerateFromUrl;
    }

    public boolean toMarkGeneratedCodeWithAnnotations() {
        return this.myMarkGeneratedCode.isSelected();
    }

    public boolean toEnableSourceLocationSupport() {
        return this.myEnableSourceLocationSupport.isSelected();
    }

    public boolean toCreateSynchronizedMethods() {
        return this.myGenerateSynchronizedAccessors.isSelected();
    }

    public boolean toCreatePackageLevelAnnotations() {
        return this.myGeneratePackageLevelAnnotations.isSelected();
    }

    public boolean toMakeGeneratedCodeReadOnly() {
        return this.myMakeFilesReadOnly.isSelected();
    }

    public boolean doNotGenerateHeader() {
        return this.myNoHeader.isSelected();
    }

    @Nullable
    public String getExternalBinding() {
        String path;
        if (this.myExternalBindings.isSelected() && !StringUtil.isEmptyOrSpaces((String)(path = this.myExternalBindingPath.getText()))) {
            return path;
        }
        return null;
    }

    private void createUIComponents() {
        JavaCodeFragment fragment = this.setupFragment();
        this.myPackagePrefix = new EditorComboBox(PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment), this.myProject, (FileType)StdFileTypes.JAVA);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        ComboBox comboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JCheckBox jCheckBox8;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        JComboBox jComboBox = this.myPackagePrefix;
        jComboBox.setEditable(true);
        jComboBox.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.packageprefix.tooltip"));
        jPanel.add((Component)jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackagePrefixText = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("webservice.packageprefix"));
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.packageprefix.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddLibs = jCheckBox8 = new JCheckBox();
        jCheckBox8.setLabel(ResourceBundle.getBundle("messages/WSBundle").getString("generate.java.jaxb.dialog.add.libs"));
        jCheckBox8.setMargin(new Insets(2, 3, 2, 3));
        jCheckBox8.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.add.libs"));
        jCheckBox8.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.addrequiredlibs.tooltip"));
        jPanel.add((Component)jCheckBox8, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myGenerateFromUrlText = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.schema.path"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.url.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputPathsText = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("webservice.outputpath"));
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.outputpath.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputPaths = comboBox = new ComboBox();
        comboBox.setEditable(false);
        comboBox.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("webservice.outputpath.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myGenerateFromUrl = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        comboboxWithBrowseButton.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.url.tooltip"));
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMarkGeneratedCode = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.mark.generated"));
        jCheckBox7.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.generate.mark.generated"));
        jPanel.add((Component)jCheckBox7, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myGeneratePackageLevelAnnotations = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.package.annotations"));
        jCheckBox6.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.generate.package.level.annotations"));
        jPanel.add((Component)jCheckBox6, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnableSourceLocationSupport = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.enable.src.support"));
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.generate.source.location.support"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myGenerateSynchronizedAccessors = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.gen.synchronized"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.generate.sync.methods"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMakeFilesReadOnly = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.make.readonly"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.make.files.readonly.tooltip"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myNoHeader = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.no.header"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myExternalBindings = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJavaFromJAXBSchemasDialog.class).getString("generate.java.jaxb.dialog.add.external.binding"));
        jPanel.add((Component)jCheckBox, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExternalBindingPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(10, 1, 1, 1, 8, 0, 7, 0, new Dimension(200, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

