/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.ui.GenerateFromJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MethodDeploymentTableModel;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenerateJAXBSchemasFromJavaDialog
extends GenerateFromJavaCodeDialogBase {
    private JPanel myPanel;
    private JLabel className;
    private JLabel classNameText;
    private JCheckBox includeFollowingMethods;
    private JTable methodsTable;
    private JScrollPane myMethodsScrollPane;

    GenerateJAXBSchemasFromJavaDialog(Project _project, PsiClass clazz, @Nullable GenerateJAXBSchemasFromJavaDialog previousDialog) {
        super(_project, clazz);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("generate.xml.schema.from.java.using.jaxb.dialog.title", objectArray));
        this.includeFollowingMethods.setSelected(true);
        this.includeFollowingMethods.setMnemonic('i');
        this.includeFollowingMethods.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = GenerateJAXBSchemasFromJavaDialog.this.includeFollowingMethods.isSelected();
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.setVisible(selected);
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.getParent().invalidate();
                GenerateJAXBSchemasFromJavaDialog.this.myMethodsScrollPane.getParent().validate();
                GenerateJAXBSchemasFromJavaDialog.this.pack();
            }
        });
        if (previousDialog != null) {
            SwingUtilities.invokeLater(() -> {
                this.setCurrentClass(previousDialog.getCurrentClass());
                this.setClassNameToUI(previousDialog.getCurrentClass());
                this.methodsTable.setModel(previousDialog.getMethodsTable().getModel());
                this.includeFollowingMethods.setSelected(previousDialog.includeFollowingMethods.isSelected());
            });
        } else {
            this.includeFollowingMethods.setSelected(false);
        }
        this.init();
    }

    @Override
    protected JTable getMethodsTable() {
        return this.methodsTable;
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        Module module;
        PsiClass psiClass = this.getCurrentClass();
        Module module2 = module = psiClass != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (module == null) {
            if (psiClass == null) {
                return new ValidationInfo(WSBundle.message("jaxb.no.class.error", new Object[0]));
            }
            String fqn = (String)ReadAction.compute(() -> psiClass.getQualifiedName());
            return new ValidationInfo(WSBundle.message("jaxb.external.class.error", fqn), null);
        }
        ValidationInfo validationResult = GenerateJAXBSchemasFromJavaDialog.checkJWSDPPathSet(module);
        if (validationResult != null) {
            return validationResult;
        }
        String path = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("JAXB 2").getBasePath();
        if (path == null && !JavaVersionService.getInstance().isAtLeast((PsiElement)psiClass, JavaSdkVersion.JDK_1_6) && LibUtils.getLibUrlsForToolRunning("com.sun.tools.internal.jxc.SchemaGenerator", this.myProject).length == 0) {
            return new ValidationInfo(WSBundle.message("jaxb.no.jwsdp.path", new Object[0]), null);
        }
        validationResult = super.doValidate(_data);
        if (validationResult == null) {
            MyValidationData validationData = (MyValidationData)_data;
            if (validationData.includeTypesOfMethods && validationData.selectedMethods.length == 0) {
                return new ValidationInfo(WSBundle.message("jaxb.no.methods.selected.error", new Object[0]), null);
            }
        }
        return validationResult;
    }

    static ValidationInfo checkJWSDPPathSet(Module module) {
        if (WebServicesPluginSettings.getInstance().getJwsdpPath() == null && !WebServicePlatformUtils.isJdk1_6SetUpForModule(module)) {
            return new ValidationInfo(WSBundle.message("jaxb.no.jwsdp.path.jdk6", new Object[0]), null);
        }
        return null;
    }

    @Override
    protected MyValidationData createValidationData() {
        return new MyValidationData();
    }

    @Override
    protected MethodDeploymentTableModel createMethodDeploymentTable(List<PsiMethod> methodsAllowedForDeployment, List<PsiMethod> methodsNotAllowedForDeployment) {
        return new MethodDeploymentTableModel(methodsAllowedForDeployment, methodsNotAllowedForDeployment){

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return WSBundle.message("generate.java.jaxb.add.to.generation", new Object[0]);
                }
                return WSBundle.message("generate.java.jaxb.parameter.of.method", new Object[0]);
            }
        };
    }

    @Override
    protected JComponent getClassName() {
        return this.className;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    boolean toIncludeTypesOfMethods() {
        return this.includeFollowingMethods.isSelected();
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "GenerateJAXBSchemasFromJava.html";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.classNameText = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJAXBSchemasFromJavaDialog.class).getString("generate.jaxb.schemas.classname"));
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.classname.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.className = jLabel = new JLabel();
        jLabel.setText("");
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.classname.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.includeFollowingMethods = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WSBundle", GenerateJAXBSchemasFromJavaDialog.class).getString("generate.jaxb.schemas.include.parameters"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.include.parameters.return.types.of.methods.tooltips"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myMethodsScrollPane = jBScrollPane;
        jBScrollPane.setToolTipText(ResourceBundle.getBundle("messages/WSBundle").getString("jaxb.include.parameters.return.types.of.methods.tooltips"));
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.methodsTable = jBTable;
        jBTable.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    class MyValidationData
    extends GenerateFromJavaCodeDialogBase.MyValidationData {
        boolean includeTypesOfMethods;

        MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            this.includeTypesOfMethods = GenerateJAXBSchemasFromJavaDialog.this.toIncludeTypesOfMethods();
            super.doAcquire();
        }
    }
}

