/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl.endpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.wsdl.WsdlDomUtils;
import com.intellij.ws.wsdl.model.BindingOperation;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WsdlEndpointsProvider
implements EndpointsProvider<XmlFile, BindingOperation> {
    private final FrameworkPresentation myPresentation = new FrameworkPresentation("WSDL", "WSDL Definitions", AllIcons.Javaee.WebService);

    WsdlEndpointsProvider() {
    }

    @NotNull
    public EndpointType getEndpointType() {
        EndpointType endpointType = EndpointTypes.API_DEFINITION_TYPE;
        if (endpointType == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(0);
        }
        return endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(1);
        }
        return frameworkPresentation;
    }

    public boolean isValidEndpoint(@NotNull XmlFile group, @NotNull BindingOperation endpoint) {
        if (group == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(2);
        }
        if (endpoint == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(3);
        }
        return endpoint.isValid();
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(4);
        }
        if (!WsdlDomUtils.hasWsdlFiles(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
            if (status == null) {
                WsdlEndpointsProvider.$$$reportNull$$$0(5);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.AVAILABLE;
        if (status == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(6);
        }
        return status;
    }

    @NotNull
    public Iterable<XmlFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        if (project == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(8);
        }
        if (!(filter instanceof ModuleEndpointsFilter)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                WsdlEndpointsProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        ModuleEndpointsFilter moduleFilter = (ModuleEndpointsFilter)filter;
        Module module = moduleFilter.getModule();
        Iterable iterable = moduleFilter.filterByScope(WsdlDomUtils.getWsdlFiles(module), file -> file.getContainingFile());
        if (iterable == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @NotNull
    public Iterable<BindingOperation> getEndpoints(@NotNull XmlFile group) {
        if (group == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(11);
        }
        Set<BindingOperation> set = WsdlDomUtils.getOperations(group);
        if (set == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull XmlFile group, @NotNull BindingOperation endpoint) {
        String name;
        if (group == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(13);
        }
        if (endpoint == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(14);
        }
        return new PresentationData((name = endpoint.getName().getStringValue()) == null ? "<binding>" : name, group.getName(), AllIcons.FileTypes.WsdlFile, null);
    }

    @Nullable
    public Object getEndpointData(@NotNull XmlFile group, @NotNull BindingOperation endpoint, @NotNull String dataId) {
        if (group == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(15);
        }
        if (endpoint == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(16);
        }
        if (dataId == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(17);
        }
        return EndpointsViewUtils.getCommonEndpointValue((PsiElement)endpoint.getXmlElement(), (String)dataId);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(18);
        }
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)project).getModificationTracker();
        ModificationTracker modificationTracker = psiModificationTracker.forLanguage((Language)XMLLanguage.INSTANCE);
        if (modificationTracker == null) {
            WsdlEndpointsProvider.$$$reportNull$$$0(19);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/wsdl/endpoints/WsdlEndpointsProvider";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 4: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/wsdl/endpoints/WsdlEndpointsProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpointGroups";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

