/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.ws.wsdl.model.Binding;
import com.intellij.ws.wsdl.model.BindingOperation;
import com.intellij.ws.wsdl.model.Definitions;
import com.intellij.ws.wsdl.model.Import;
import com.intellij.ws.wsdl.model.Message;
import com.intellij.ws.wsdl.model.PortType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WsdlDomUtils {
    private WsdlDomUtils() {
    }

    public static List<Message> getMessages(ConvertContext context) {
        List<Definitions> allDefinitions = WsdlDomUtils.getAllDefinitions(context);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Definitions definition : allDefinitions) {
            messages.addAll(definition.getMessages());
        }
        return messages;
    }

    public static List<Definitions> getAllDefinitions(ConvertContext context) {
        ArrayList<Definitions> all = new ArrayList<Definitions>();
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        if (definitions != null) {
            all.add(definitions);
            for (Import anImport : definitions.getImports()) {
                Definitions def;
                XmlDocument xml;
                PsiFile psiFile = FileReferenceUtil.findFile((PsiElement)anImport.getLocation().getXmlAttributeValue());
                if (!(psiFile instanceof XmlFile) || (xml = ((XmlFile)psiFile).getDocument()) == null || (def = (Definitions)DomUtil.findDomElement((PsiElement)xml.getRootTag(), Definitions.class, (boolean)false)) == null) continue;
                all.add(def);
            }
        }
        return all;
    }

    @Nullable
    public static Message findMessage(String name, ConvertContext context) {
        for (Message message : WsdlDomUtils.getMessages(context)) {
            if (!name.equals(message.getName().getValue())) continue;
            return message;
        }
        return null;
    }

    public static List<String> getWsdlNsPrefixes(ConvertContext context) {
        String targetNS;
        XmlTag rootTag;
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        if (definitions != null && (rootTag = definitions.getXmlTag()) != null && (targetNS = rootTag.getAttributeValue("targetNamespace")) != null) {
            ArrayList<String> res = new ArrayList<String>();
            for (XmlAttribute attribute : rootTag.getAttributes()) {
                String name = attribute.getName();
                if (!name.startsWith("xmlns:") || !attribute.getValue().equals(targetNS)) continue;
                res.add(name.substring(6));
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static Definitions getDefinitions(ConvertContext context) {
        return (Definitions)context.getInvocationElement().getParentOfType(Definitions.class, true);
    }

    public static List<PortType> getPortTypes(ConvertContext context) {
        List<Definitions> allDefinitions = WsdlDomUtils.getAllDefinitions(context);
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        for (Definitions definition : allDefinitions) {
            portTypes.addAll(definition.getPortTypes());
        }
        return portTypes;
    }

    public static List<Binding> getBindings(ConvertContext context) {
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        return definitions == null ? Collections.emptyList() : definitions.getBindings();
    }

    @Nullable
    public static Message findMessage(String message, Definitions defs) {
        if (defs == null) {
            return null;
        }
        if (message.contains(":")) {
            message = message.substring(message.indexOf(":") + 1);
        }
        for (Message msg : defs.getMessages()) {
            if (!message.equals(msg.getName().getValue())) continue;
            return msg;
        }
        return null;
    }

    @Nullable
    public static PortType getPortType(Binding binding, ConvertContext context) {
        if (binding == null) {
            return null;
        }
        String value = (String)binding.getType().getValue();
        if (value != null) {
            String type = value.contains(":") ? value.substring(value.indexOf(":") + 1) : value;
            List<PortType> portTypes = WsdlDomUtils.getPortTypes(context);
            for (PortType portType : portTypes) {
                if (!type.equals(portType.getName().getValue())) continue;
                return portType;
            }
        }
        return null;
    }

    @NotNull
    public static Set<XmlFile> getWsdlFiles(@NotNull Module module) {
        if (module == null) {
            WsdlDomUtils.$$$reportNull$$$0(0);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Set wsdlFiles = DomService.getInstance().getDomFileCandidates(Definitions.class, module.getModuleWithDependenciesAndLibrariesScope(false)).stream().map(file -> PsiManager.getInstance((Project)module.getProject()).findFile(file)).filter(XmlFile.class::isInstance).map(XmlFile.class::cast).collect(Collectors.toSet());
            return CachedValueProvider.Result.create(wsdlFiles, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), VirtualFileManager.getInstance()});
        });
        if (set == null) {
            WsdlDomUtils.$$$reportNull$$$0(1);
        }
        return set;
    }

    public static boolean hasWsdlFiles(@NotNull Project project) {
        if (project == null) {
            WsdlDomUtils.$$$reportNull$$$0(2);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DomService domService = DomService.getInstance();
            return CachedValueProvider.Result.create((Object)(!domService.getDomFileCandidates(Definitions.class, GlobalSearchScope.allScope((Project)project)).isEmpty() ? 1 : 0), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), VirtualFileManager.getInstance()});
        });
    }

    public static Set<BindingOperation> getOperations(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            WsdlDomUtils.$$$reportNull$$$0(3);
        }
        LinkedHashSet<BindingOperation> allOperations = new LinkedHashSet<BindingOperation>();
        DomFileElement definitions = DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, Definitions.class);
        if (definitions == null) {
            return Collections.emptySet();
        }
        for (Binding binding : ((Definitions)definitions.getRootElement()).getBindings()) {
            allOperations.addAll(binding.getOperations());
        }
        return allOperations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/wsdl/WsdlDomUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/wsdl/WsdlDomUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWsdlFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWsdlFiles";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasWsdlFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOperations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

