/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.facet.FacetManager;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ws.WSAnnotations;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.facet.WebServicesFacet;
import com.intellij.ws.facet.WebServicesFacetConfiguration;
import com.intellij.ws.facet.client.WebServicesClientFacet;
import com.intellij.ws.facet.client.WebServicesClientFacetConfiguration;
import com.intellij.ws.utils.CommonWsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WsModuleUtil {
    private WsModuleUtil() {
    }

    @Nullable
    public static WSEngine getEngineFromModule(Module module) {
        WebServicesFacet webServicesFacet;
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        if (CommonWsUtils.hasJ2EE() && (webServicesFacet = (WebServicesFacet)facetManager.getFacetByType(WebServicesFacet.ID)) != null) {
            return ((WebServicesFacetConfiguration)webServicesFacet.getConfiguration()).getWsEngine();
        }
        WebServicesClientFacet webServicesClientFacet = (WebServicesClientFacet)facetManager.getFacetByType(WebServicesClientFacet.ID);
        if (webServicesClientFacet != null) {
            return ((WebServicesClientFacetConfiguration)webServicesClientFacet.getConfiguration()).getWsEngine();
        }
        return null;
    }

    public static boolean isJaxWSLibAttached(@NotNull Module module) {
        if (module == null) {
            WsModuleUtil.$$$reportNull$$$0(0);
        }
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)WSAnnotations.WEB_SERVICE.javax()) || JavaLibraryUtils.hasLibraryClass((Module)module, (String)WSAnnotations.WEB_SERVICE.jakarta());
    }

    public static boolean isJaxWSLibAttached(@NotNull Project project) {
        if (project == null) {
            WsModuleUtil.$$$reportNull$$$0(1);
        }
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)WSAnnotations.WEB_SERVICE.javax()) || JavaLibraryUtils.hasLibraryClass((Project)project, (String)WSAnnotations.WEB_SERVICE.jakarta());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/ws/utils/WsModuleUtil";
        objectArray[2] = "isJaxWSLibAttached";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

