/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsPsiUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentTimeCheckProcessor {
    public static final List<String> ALLOWED_CLASSES = ContainerUtil.immutableList((Object[])new String[]{"java.lang.Boolean"});

    protected abstract void processMethod(PsiMethod var1, @Nls String var2, List<String> var3);

    public void processClassMethods(PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            this.processMethod(method);
        }
    }

    public void processMethod(PsiMethod method) {
        if (DeployUtils.isAcceptableMethod(method)) {
            HashSet<PsiClass> visitedSet = new HashSet<PsiClass>();
            HashSet<String> unresolvedSet = new HashSet<String>();
            LinkedList<String> nonelementaryTypes = new LinkedList<String>();
            DeploymentTimeCheckProcessor.findReferencedTypesForVars((PsiVariable[])method.getParameterList().getParameters(), visitedSet, unresolvedSet);
            DeploymentTimeCheckProcessor.findReferencedTypesForType(method.getReturnType(), visitedSet, unresolvedSet);
            String problem = DeploymentTimeCheckProcessor.findDeploymentProblem(visitedSet, nonelementaryTypes, unresolvedSet);
            this.processMethod(method, problem, nonelementaryTypes);
        } else {
            this.processMethod(method, method.isConstructor() ? WSBundle.message("method.is.constructor.validation.message", new Object[0]) : WSBundle.message("method.is.not.public.validation.message", new Object[0]), null);
        }
    }

    @InspectionMessage
    public static String getDeploymentProblemForType(PsiType type) {
        HashSet<PsiClass> visitedSet = new HashSet<PsiClass>();
        HashSet<String> unresolvedSet = new HashSet<String>();
        DeploymentTimeCheckProcessor.findReferencedTypesForType(type, visitedSet, unresolvedSet);
        return DeploymentTimeCheckProcessor.findDeploymentProblem(visitedSet, null, unresolvedSet);
    }

    public static PsiClass[] searchReferencedTypesForClass(PsiType type) {
        ArrayListSet visited = new ArrayListSet();
        ArrayListSet unresolved = new ArrayListSet();
        DeploymentTimeCheckProcessor.findReferencedTypesForType(type, (Set<PsiClass>)visited, (Set<String>)unresolved, true);
        DeploymentTimeCheckProcessor.removeBuildInClasses((Set<PsiClass>)visited);
        return visited.toArray(PsiClass.EMPTY_ARRAY);
    }

    @Nullable
    @Nls
    public static String checkAccessibleClass(PsiClass myClass) {
        boolean classIsPublic = DeploymentTimeCheckProcessor.checkInstanciatableClass(myClass);
        if (!classIsPublic) {
            return WSBundle.message("class.should.be.instanciatable.validation.problem", new Object[0]);
        }
        if (myClass.isAnnotationType()) {
            return WSBundle.message("class.should.not.be.enum.annotation.type.validation.problem", new Object[0]);
        }
        return null;
    }

    @Nullable
    @Nls
    public static String checkAccessibleClassPrerequisites(Project project, PsiClass myClass) {
        String s = DeploymentTimeCheckProcessor.checkAccessibleClass(myClass);
        if (s != null) {
            return s;
        }
        return DeployUtils.checkIfClassIsUpToDate(project, myClass);
    }

    private static void findReferencedTypesForVars(PsiVariable[] vars, Set<PsiClass> visited, Set<String> unresolved) {
        for (PsiVariable var : vars) {
            DeploymentTimeCheckProcessor.findReferencedTypesForType(var.getType(), visited, unresolved);
        }
    }

    private static void findReferencedTypesForType(PsiType parameterType, Set<PsiClass> visited, Set<String> unresolved) {
        DeploymentTimeCheckProcessor.findReferencedTypesForType(parameterType, visited, unresolved, false);
    }

    private static void findReferencedTypesForType(PsiType parameterType, Set<PsiClass> visited, Set<String> unresolved, boolean findInMethods) {
        PsiClass psiClass;
        if (parameterType instanceof PsiArrayType) {
            parameterType = ((PsiArrayType)parameterType).getComponentType();
        }
        if (parameterType instanceof PsiClassType && !((psiClass = ((PsiClassType)parameterType).resolve()) instanceof PsiTypeParameter)) {
            if (psiClass != null) {
                if (!visited.contains(psiClass)) {
                    visited.add(psiClass);
                    String qualifiedName = psiClass.getQualifiedName();
                    if (qualifiedName != null && !qualifiedName.startsWith("javax.") && !qualifiedName.startsWith("java.")) {
                        DeploymentTimeCheckProcessor.findReferencedTypesForVars((PsiVariable[])DeploymentTimeCheckProcessor.getNonStaticFields(psiClass), visited, unresolved);
                        if (findInMethods) {
                            DeploymentTimeCheckProcessor.findReferencedTypesForMethods(DeploymentTimeCheckProcessor.getNonStaticMethods(psiClass), visited, unresolved);
                        }
                    }
                }
            } else {
                unresolved.add(parameterType.getCanonicalText());
            }
        }
    }

    private static PsiField[] getNonStaticFields(PsiClass psiClass) {
        ArrayList<PsiField> fields = new ArrayList<PsiField>();
        for (PsiField field : psiClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            fields.add(field);
        }
        return fields.toArray(PsiField.EMPTY_ARRAY);
    }

    private static PsiMethod[] getNonStaticMethods(PsiClass psiClass) {
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        for (PsiMethod field : psiClass.getMethods()) {
            if (field.hasModifierProperty("static")) continue;
            methods.add(field);
        }
        return methods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private static void findReferencedTypesForMethods(PsiMethod[] methods, Set<PsiClass> visited, Set<String> unresolved) {
        for (PsiMethod method : methods) {
            DeploymentTimeCheckProcessor.findReferencedTypesForMethod(method, visited, unresolved);
        }
    }

    private static void findReferencedTypesForMethod(PsiMethod method, Set<PsiClass> visited, Set<String> unresolved) {
        if (method != null) {
            if (method.getReturnType() != null) {
                DeploymentTimeCheckProcessor.findReferencedTypesForType(method.getReturnType(), visited, unresolved);
            }
            for (PsiParameter param : method.getParameterList().getParameters()) {
                DeploymentTimeCheckProcessor.findReferencedTypesForType(param.getType(), visited, unresolved);
            }
        }
    }

    private static boolean checkInstanciatableClass(PsiClass myClass) {
        if (ALLOWED_CLASSES.contains(ReadAction.compute(() -> myClass.getQualifiedName()))) {
            return true;
        }
        boolean classIsPublic = false;
        PsiModifierList modifierList = (PsiModifierList)ReadAction.compute(() -> myClass.getModifierList());
        if (modifierList != null && modifierList.hasModifierProperty("public") && (myClass.getParent() instanceof PsiFile || modifierList.hasModifierProperty("static")) && !myClass.isInterface()) {
            if (myClass.isEnum()) {
                return true;
            }
            PsiMethod[] constructors = myClass.getConstructors();
            if (constructors.length == 0) {
                classIsPublic = true;
            } else {
                for (PsiMethod constructor : constructors) {
                    if (constructor.getParameterList().getParameters().length != 0) continue;
                    if (!constructor.hasModifierProperty("public")) break;
                    classIsPublic = true;
                    break;
                }
            }
        }
        return classIsPublic;
    }

    private static boolean builtinClass(PsiClass psiClass) {
        PsiClass collectionsClass;
        String qualifiedName = psiClass.getQualifiedName();
        return qualifiedName != null && (qualifiedName.equals("java.util.Calendar") || qualifiedName.equals("java.math.BigDecimal") || qualifiedName.equals("java.lang.Float") || qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Long") || qualifiedName.equals("java.lang.Integer") || qualifiedName.equals("java.lang.Short") || qualifiedName.equals("java.lang.Character") || qualifiedName.equals("java.lang.Byte") || qualifiedName.equals("java.math.BigInteger") || qualifiedName.equals("javax.xml.namespace.QName") || qualifiedName.equals("java.lang.String") || qualifiedName.equals("java.util.Hashtable") || qualifiedName.equals("javax.activation.DataHandler") || qualifiedName.equals("javax.xml.bind.JAXBElement") || (collectionsClass = WsPsiUtil.findClass((String)"java.util.Collection", (Project)psiClass.getProject(), (GlobalSearchScope)psiClass.getResolveScope())) != null && (psiClass == collectionsClass || psiClass.isInheritor(collectionsClass, true)));
    }

    @InspectionMessage
    private static String findDeploymentProblem(HashSet<PsiClass> visitedSet, List<String> nonelementaryTypes, HashSet<String> unresolvedSet) {
        String problem = null;
        for (PsiClass clazz : visitedSet) {
            if (DeploymentTimeCheckProcessor.builtinClass(clazz)) continue;
            if (!DeploymentTimeCheckProcessor.checkInstanciatableClass(clazz)) {
                problem = WSBundle.message("class.not.public.or.does.not.allow.instantiation.validation.message", clazz.getQualifiedName());
                break;
            }
            if (nonelementaryTypes == null) continue;
            nonelementaryTypes.add(clazz.getQualifiedName());
        }
        if (problem == null && unresolvedSet.size() > 0) {
            problem = WSBundle.message("class.not.found.validation.message", unresolvedSet.iterator().next());
        }
        return problem;
    }

    private static void removeBuildInClasses(Set<PsiClass> visited) {
        ArrayList<PsiClass> buildin = new ArrayList<PsiClass>();
        for (PsiClass clazz : visited) {
            if (!DeploymentTimeCheckProcessor.builtinClass(clazz)) continue;
            buildin.add(clazz);
        }
        visited.removeAll(buildin);
    }
}

