/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.URLUtil;
import com.intellij.ws.references.BaseRangedReference;
import com.intellij.ws.references.MyPathReferenceProvider;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.WsPsiUtil;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSDLReferenceProvider
extends MyReferenceProvider {
    @NonNls
    private static final String TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String LOCATION_ATTR_NAME = "location";
    @NonNls
    private static final String ELEMENT_ATTR_NAME = "element";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    @NonNls
    private static final String BINDING_ATTR_NAME = "binding";
    @NonNls
    private static final String MESSAGE_ATTR_NAME = "message";
    @NonNls
    private static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    @NonNls
    private static final String BINDING_TAG_NAME = "binding";
    @NonNls
    public static final String PORT_TYPE_TAG_NAME = "portType";
    @NonNls
    private static final String PORT_TAG_NAME = "port";
    @NonNls
    private static final String INPUT_TAG_NAME = "input";
    @NonNls
    private static final String OUTPUT_TAG_NAME = "output";
    @NonNls
    private static final String FAULT_TAG_NAME = "fault";
    @NonNls
    private static final String MESSAGE_TAG_NAME = "message";
    @NonNls
    public static final String OPERATION_TAG_NAME = "operation";
    @NonNls
    public static final String PART_TAG_NAME = "part";
    @NonNls
    public static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    public static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    private static final String IMPORT_TAG_NAME = "import";
    @NonNls
    private static final String TYPES_TAG_NAME = "types";
    private static final TagCollector schemaTagCollector = new TagCollector(){

        @Override
        public XmlTag @NotNull [] findNeededTags(@NotNull XmlTag t, String param) {
            if (t == null) {
                1.$$$reportNull$$$0(0);
            }
            XmlTag[] xmlTagArray = t.findSubTags("element", t.getNamespace());
            if (xmlTagArray == null) {
                1.$$$reportNull$$$0(1);
            }
            return xmlTagArray;
        }

        @Override
        public XmlTag @NotNull [] findImportedTags(@NotNull XmlTag t) {
            if (t == null) {
                1.$$$reportNull$$$0(2);
            }
            XmlTag[] xmlTagArray = (XmlTag[])ArrayUtil.mergeArrays((Object[])t.findSubTags(WSDLReferenceProvider.IMPORT_TAG_NAME, t.getNamespace()), (Object[])t.findSubTags("include", t.getNamespace()));
            if (xmlTagArray == null) {
                1.$$$reportNull$$$0(3);
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public String getImportedFileLocationAttrName() {
            return "schemaLocation";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findNeededTags";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findImportedTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findNeededTags";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findImportedTags";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final TagCollector wsdlTagsCollector = new TagCollector(){

        @Override
        public XmlTag @NotNull [] findNeededTags(@NotNull XmlTag t, String param) {
            if (t == null) {
                2.$$$reportNull$$$0(0);
            }
            XmlTag[] xmlTagArray = t.findSubTags(param, t.getNamespace());
            if (xmlTagArray == null) {
                2.$$$reportNull$$$0(1);
            }
            return xmlTagArray;
        }

        @Override
        public XmlTag @NotNull [] findImportedTags(@NotNull XmlTag t) {
            if (t == null) {
                2.$$$reportNull$$$0(2);
            }
            XmlTag[] xmlTagArray = t.findSubTags(WSDLReferenceProvider.IMPORT_TAG_NAME, t.getNamespace());
            if (xmlTagArray == null) {
                2.$$$reportNull$$$0(3);
            }
            return xmlTagArray;
        }

        @Override
        @NotNull
        public String getImportedFileLocationAttrName() {
            return WSDLReferenceProvider.LOCATION_ATTR_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findNeededTags";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findImportedTags";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findNeededTags";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findImportedTags";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final MyPathReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(false);
    private static final String[] ATTR_NAMES = new String[]{"type", "name", "binding", "message", "location", "element"};
    @NonNls
    static String[] SCHEMA_URIS = XmlUtil.SCHEMA_URIS;

    @Override
    @Nullable
    public ElementFilter getAttributeFilter() {
        return null;
    }

    @Nullable
    static XmlTag getRootTag(PsiElement element) {
        XmlDocument document;
        XmlFile xmlFile;
        if (element instanceof XmlElement && (xmlFile = (XmlFile)element.getContainingFile()) != null && (document = xmlFile.getDocument()) != null) {
            return document.getRootTag();
        }
        return null;
    }

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            WSDLReferenceProvider.$$$reportNull$$$0(0);
        }
        if ((parent = psiElement.getParent()) instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            XmlTag parentTag = xmlAttribute.getParent();
            String tagNS = parentTag.getNamespace();
            String attrName = xmlAttribute.getName();
            String tagLocalName = parentTag.getLocalName();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(tagNS) && !"http://www.w3.org/2003/03/wsdl".equals(tagNS)) {
                if (Arrays.binarySearch(SCHEMA_URIS, tagNS) >= 0 && NAME_ATTR_NAME.equals(attrName)) {
                    VirtualFile file;
                    PsiFile psiFile = psiElement.getContainingFile();
                    VirtualFile virtualFile = file = psiFile != null ? psiFile.getOriginalFile().getVirtualFile() : null;
                    if (file == null || !"wsdl".equals(file.getExtension())) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            WSDLReferenceProvider.$$$reportNull$$$0(1);
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    if (COMPLEX_TYPE_TAG_NAME.equals(tagLocalName)) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlClassReference(psiElement, 1, psiElement.getTextLength() - 1)};
                        if (psiReferenceArray == null) {
                            WSDLReferenceProvider.$$$reportNull$$$0(2);
                        }
                        return psiReferenceArray;
                    }
                    if ("element".equals(tagLocalName)) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlPropertyReference(psiElement)};
                        if (psiReferenceArray == null) {
                            WSDLReferenceProvider.$$$reportNull$$$0(3);
                        }
                        return psiReferenceArray;
                    }
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    WSDLReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String text = StringUtil.unquoteString((String)psiElement.getText());
            int i = text.indexOf(58);
            if ("binding".equals(attrName)) {
                if (PORT_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = WSDLReferenceProvider.collectQReferences(psiElement, text, i, "binding");
                    if (psiReferenceArray == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(5);
                    }
                    return psiReferenceArray;
                }
            } else if ("message".equals(attrName)) {
                if (INPUT_TAG_NAME.equals(tagLocalName) || OUTPUT_TAG_NAME.equals(tagLocalName) || FAULT_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = WSDLReferenceProvider.collectQReferences(psiElement, text, i, "message");
                    if (psiReferenceArray == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(6);
                    }
                    return psiReferenceArray;
                }
            } else if (TYPE_ATTR_NAME.equals(attrName)) {
                boolean isBindingTagName = "binding".equals(tagLocalName);
                if (isBindingTagName || PART_TAG_NAME.equals(tagLocalName)) {
                    Object[] refs = isBindingTagName ? WSDLReferenceProvider.collectQReferences(psiElement, text, i, PORT_TYPE_TAG_NAME) : PsiReference.EMPTY_ARRAY;
                    if ((refs = (PsiReference[])ArrayUtil.append((Object[])refs, (Object)new WsdlClassReference(psiElement, i + 2, text.length() + 1))) == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(7);
                    }
                    return refs;
                }
            } else if (NAME_ATTR_NAME.equals(attrName)) {
                String grandParentLocalName;
                XmlTag grandParentTag;
                if (PORT_TYPE_TAG_NAME.equals(tagLocalName)) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlClassReference(psiElement, 1, psiElement.getTextLength() - 1)};
                    if (psiReferenceArray == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(8);
                    }
                    return psiReferenceArray;
                }
                if (OPERATION_TAG_NAME.equals(tagLocalName) && (grandParentTag = parentTag.getParentTag()) != null && (PORT_TYPE_TAG_NAME.equals(grandParentLocalName = grandParentTag.getLocalName()) || "binding".equals(grandParentLocalName))) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new WsdlMethodReference(psiElement)};
                    if (psiReferenceArray == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(9);
                    }
                    return psiReferenceArray;
                }
            } else if (LOCATION_ATTR_NAME.equals(attrName)) {
                if (IMPORT_TAG_NAME.equals(tagLocalName) && !URLUtil.containsScheme((String)text)) {
                    PsiReference[] psiReferenceArray = this.myPathProvider.getReferencesByString(text, psiElement, 1);
                    if (psiReferenceArray == null) {
                        WSDLReferenceProvider.$$$reportNull$$$0(10);
                    }
                    return psiReferenceArray;
                }
            } else if ("element".equals(attrName) && PART_TAG_NAME.equals(tagLocalName)) {
                WsdlEntityReference wsdlEntityReference = new WsdlEntityReference(psiElement, i + 2, text.length() + 1, null){

                    @Override
                    protected void processTags(PsiElementProcessor<? super XmlTag> processor) {
                        XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
                        if (rootTag == null) {
                            return;
                        }
                        for (XmlTag t : WSDLReferenceProvider.getWsdlTags(rootTag, WSDLReferenceProvider.TYPES_TAG_NAME)) {
                            for (XmlTag t2 : t.getSubTags()) {
                                if (WSDLReferenceProvider.processSchemaTags(processor, t2)) continue;
                                return;
                            }
                        }
                        for (XmlTag t : WSDLReferenceProvider.getWsdlTags(rootTag, WSDLReferenceProvider.IMPORT_TAG_NAME)) {
                            PsiFile _xmlFile;
                            XmlAttribute locationAttr = t.getAttribute(WSDLReferenceProvider.LOCATION_ATTR_NAME);
                            if (locationAttr == null || !((_xmlFile = FileReferenceUtil.findFile((PsiElement)locationAttr.getValueElement())) instanceof XmlFile) || (rootTag = ((XmlFile)_xmlFile).getRootTag()) == null || !WSDLReferenceProvider.processSchemaTags(processor, rootTag)) continue;
                            return;
                        }
                    }
                };
                PsiReference[] psiReferenceArray = new PsiReference[]{wsdlEntityReference};
                if (psiReferenceArray == null) {
                    WSDLReferenceProvider.$$$reportNull$$$0(11);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            WSDLReferenceProvider.$$$reportNull$$$0(12);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean processSchemaTags(PsiElementProcessor<? super XmlTag> processor, XmlTag t2) {
        for (XmlTag t : WSDLReferenceProvider.collectTags(t2, null, schemaTagCollector, null)) {
            if (processor.execute((PsiElement)t)) continue;
            return false;
        }
        return true;
    }

    private static PsiReference[] collectQReferences(PsiElement psiElement, String text, int i, String tagName) {
        return PsiReference.EMPTY_ARRAY;
    }

    public static XmlTag[] getWsdlTags(XmlTag rootTag, String entityName) {
        return WSDLReferenceProvider.collectTags(rootTag, null, wsdlTagsCollector, entityName);
    }

    @Nullable
    private static XmlFile getXmlFileFromAttr(XmlTag t, String attrName) {
        XmlAttribute attribute;
        if (t.getAttributeValue(attrName) != null && (attribute = t.getAttribute(attrName, null)) != null) {
            PsiFile file = FileReferenceUtil.findFile((PsiElement)attribute.getValueElement());
            return file instanceof XmlFile ? (XmlFile)file : null;
        }
        return null;
    }

    private static XmlTag[] collectTags(XmlTag rootTag, Set<PsiFile> visitedFiles, TagCollector collector, String param) {
        if (visitedFiles != null) {
            visitedFiles.add((PsiFile)rootTag.getContainingFile());
        }
        Object[] subTags = collector.findNeededTags(rootTag, param);
        for (XmlTag importTag : collector.findImportedTags(rootTag)) {
            XmlTag includedDocRootTag;
            XmlFile imported = WSDLReferenceProvider.getXmlFileFromAttr(importTag, collector.getImportedFileLocationAttrName());
            if (imported == null) continue;
            if (visitedFiles == null) {
                visitedFiles = new THashSet();
                visitedFiles.add(rootTag.getContainingFile());
            }
            XmlDocument document = imported.getDocument();
            XmlTag xmlTag = includedDocRootTag = visitedFiles.contains(imported) || document == null ? null : document.getRootTag();
            if (includedDocRootTag == null) continue;
            subTags = (XmlTag[])ArrayUtil.mergeArrays((Object[])subTags, (Object[])WSDLReferenceProvider.collectTags(includedDocRootTag, (Set<PsiFile>)visitedFiles, collector, param));
        }
        return subTags;
    }

    @Override
    public String[] getAttributeNames() {
        return ATTR_NAMES;
    }

    static {
        Arrays.sort(SCHEMA_URIS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WsdlClassReference
    extends BaseRangedReference
    implements PsiPolyVariantReference {
        private static final String HTTP_PROTOCOL_PREFIX = "http://";
        private static final String JAVA_PREFIX = "java:";

        public WsdlClassReference(@NotNull PsiElement psiElement, int index, int length) {
            if (psiElement == null) {
                WsdlClassReference.$$$reportNull$$$0(0);
            }
            super(psiElement, index, length);
        }

        public WsdlClassReference(@NotNull XmlAttributeValue element) {
            if (element == null) {
                WsdlClassReference.$$$reportNull$$$0(1);
            }
            super((PsiElement)element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Nullable
        protected String getPackageCandidateValueFromNs() {
            TextRange rangeInElement = this.getRangeInElement();
            if (rangeInElement.getStartOffset() > 2) {
                PsiElement psiElement;
                PsiReference referenceAt = this.getElement().findReferenceAt(rangeInElement.getStartOffset() - 2);
                if (referenceAt instanceof SchemaPrefixReference && (psiElement = referenceAt.resolve()) != null) {
                    String text = psiElement.getText();
                    return text == null ? null : StringUtil.unquoteString((String)text);
                }
            } else {
                String s;
                XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
                if (rootTag != null && (s = rootTag.getAttributeValue(WSDLReferenceProvider.TARGET_NAMESPACE_ATTR_NAME)) != null) {
                    return s;
                }
            }
            return null;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            if (resolveResults.length == 1) {
                return resolveResults[0].getElement();
            }
            return null;
        }

        public Object @NotNull [] getVariants() {
            if (EMPTY_ARRAY == null) {
                WsdlClassReference.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private void processCandidatePackages(PsiElementProcessor<? super PsiPackage> packageProcessor) {
            PsiDirectory psiDirectory;
            PsiPackage aPackage;
            PsiManager manager = this.getElement().getManager();
            String packageCandidateValueFromNs = this.getPackageCandidateValueFromNs();
            if (packageCandidateValueFromNs != null) {
                packageCandidateValueFromNs = WsdlClassReference.removeNsDecorations(packageCandidateValueFromNs);
                String axisPackageCandidateValueFromNs = WsdlClassReference.revertAxisDecoration(packageCandidateValueFromNs);
                aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(axisPackageCandidateValueFromNs);
                if (aPackage != null && !packageProcessor.execute((PsiElement)aPackage)) {
                    return;
                }
                aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(packageCandidateValueFromNs);
                if (aPackage != null && !packageProcessor.execute((PsiElement)aPackage)) {
                    return;
                }
            }
            if ((psiDirectory = this.getElement().getContainingFile().getParent()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
                packageProcessor.execute((PsiElement)aPackage);
            }
        }

        private static String revertAxisDecoration(String s) {
            StringTokenizer tokenizer = new StringTokenizer(s, ".");
            StringBuilder buffer = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                if (buffer.length() > 0) {
                    buffer.insert(0, '.');
                }
                buffer.insert(0, tokenizer.nextToken());
            }
            return buffer.toString();
        }

        private static String removeNsDecorations(String s) {
            s = StringUtil.trimStart((String)s, (String)HTTP_PROTOCOL_PREFIX);
            s = StringUtil.trimEnd((String)s, (String)"/");
            s = StringUtil.trimStart((String)s, (String)JAVA_PREFIX);
            return s;
        }

        public ResolveResult @NotNull [] multiResolve(boolean b) {
            final ResolveResult[][] result = new ResolveResult[1][];
            Project project = this.getElement().getProject();
            final String canonicalText = this.getCanonicalText();
            this.processCandidatePackages((PsiElementProcessor<? super PsiPackage>)new PsiElementProcessor<PsiPackage>(){
                private final XmlTag parentTag;
                private String canonicalText2;
                private String canonicalText3;
                {
                    this.parentTag = (XmlTag)this.getElement().getParent().getParent();
                    if (this.parentTag.getLocalName().equals("binding")) {
                        this.canonicalText2 = canonicalText + "Stub";
                        this.canonicalText3 = canonicalText + "_BindingStub";
                    } else if (this.parentTag.getLocalName().equals(WSDLReferenceProvider.PORT_TYPE_TAG_NAME)) {
                        this.canonicalText2 = canonicalText + "_PortType";
                        this.canonicalText3 = canonicalText + "_BindingImpl";
                    }
                }

                public boolean execute(@NotNull PsiPackage psiPackage) {
                    if (psiPackage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiClass myPossibleResult = null;
                    for (PsiClass clazz : psiPackage.getClasses()) {
                        if (!canonicalText.equals(clazz.getName()) && (this.canonicalText2 == null || !this.canonicalText2.equals(clazz.getName())) && (this.canonicalText3 == null || !this.canonicalText3.equals(clazz.getName()))) continue;
                        if (clazz.isInterface()) {
                            myPossibleResult = clazz;
                            continue;
                        }
                        result[0] = new ResolveResult[]{new PsiElementResolveResult((PsiElement)clazz)};
                        return false;
                    }
                    if (myPossibleResult != null) {
                        result[0] = new ResolveResult[]{new PsiElementResolveResult(myPossibleResult)};
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference$1", "execute"));
                }
            });
            if (result[0] != null) {
                ResolveResult[] resolveResultArray = result[0];
                if (resolveResultArray == null) {
                    WsdlClassReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(canonicalText, GlobalSearchScope.allScope((Project)project));
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])classes);
            if (resolveResultArray == null) {
                WsdlClassReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlClassReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class WsdlPropertyReference
    extends PsiReferenceBase<PsiElement> {
        public WsdlPropertyReference(PsiElement psiElement) {
            super(psiElement);
        }

        public PsiElement handleElementRename(@NotNull String string) throws IncorrectOperationException {
            String newName;
            if (string == null) {
                WsdlPropertyReference.$$$reportNull$$$0(0);
            }
            if (this.resolve() instanceof PsiMethod && (newName = PropertyUtilBase.getPropertyName((String)string)) != null) {
                string = newName;
            }
            return super.handleElementRename(string);
        }

        private void process(PsiElementProcessor<? super PsiMember> processor) {
            PsiClass clazz = this.resolveClass();
            if (clazz != null) {
                WsPsiUtil.processProperties((PsiClass)clazz, processor);
                for (PsiField f : clazz.getFields()) {
                    if (!f.hasModifierProperty("public") || processor.execute((PsiElement)f)) continue;
                    return;
                }
            }
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.process((PsiElementProcessor<? super PsiMember>)new PsiElementProcessor<PsiMember>(){

                public boolean execute(@NotNull PsiMember psiMember) {
                    if (psiMember == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object text = this.getCanonicalText();
                    String name = psiMember instanceof PsiMethod ? PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)psiMember)) : psiMember.getName();
                    if (((String)text).length() > 1 && Character.isLowerCase(((String)text).charAt(0)) && Character.isUpperCase(((String)text).charAt(1))) {
                        text = Character.toUpperCase(((String)text).charAt(0)) + ((String)text).substring(1);
                    }
                    if (((String)text).length() > 1 && Character.isUpperCase(((String)text).charAt(0)) && Character.isLowerCase(((String)text).charAt(1))) {
                        text = StringUtil.decapitalize((String)text);
                    }
                    if (((String)text).equals(name)) {
                        result[0] = psiMember;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference$1", "execute"));
                }
            });
            return result[0];
        }

        @Nullable
        protected PsiClass resolveClass() {
            PsiElement psiElement;
            PsiReference[] references;
            XmlAttributeValue value;
            XmlAttribute attribute;
            XmlTag xmlTag;
            PsiClass clazz = null;
            PsiElement parentTag = this.getElement().getParent().getParent().getParent().getParent();
            if (parentTag instanceof XmlTag && WSDLReferenceProvider.COMPLEX_TYPE_TAG_NAME.equals((xmlTag = (XmlTag)parentTag).getLocalName()) && xmlTag.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME) != null && (attribute = xmlTag.getAttribute(WSDLReferenceProvider.NAME_ATTR_NAME, null)) != null && (value = attribute.getValueElement()) != null && (references = value.getReferences()).length > 0 && (psiElement = references[references.length - 1].resolve()) instanceof PsiClass) {
                clazz = (PsiClass)psiElement;
            }
            return clazz;
        }

        public Object @NotNull [] getVariants() {
            final ArrayList variants = new ArrayList(3);
            this.process((PsiElementProcessor<? super PsiMember>)new PsiElementProcessor<PsiMember>(){

                public boolean execute(@NotNull PsiMember psiMember) {
                    if (psiMember == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (psiMember instanceof PsiMethod) {
                        variants.add(PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)psiMember)));
                    } else {
                        variants.add(psiMember.getName());
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                WsdlPropertyReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlPropertyReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface TagCollector {
        public XmlTag @NotNull [] findNeededTags(@NotNull XmlTag var1, String var2);

        public XmlTag @NotNull [] findImportedTags(@NotNull XmlTag var1);

        @NotNull
        @NonNls
        public String getImportedFileLocationAttrName();
    }

    static class WsdlEntityReference
    extends BaseRangedReference {
        private final String entityName;

        WsdlEntityReference(@NotNull PsiElement psiElement, int index, int endIndex, String _entityName) {
            if (psiElement == null) {
                WsdlEntityReference.$$$reportNull$$$0(0);
            }
            super(psiElement, index, endIndex);
            this.entityName = _entityName;
        }

        @Nullable
        public PsiElement resolve() {
            final PsiElement[] result = new PsiElement[1];
            this.processTags((PsiElementProcessor<? super XmlTag>)new PsiElementProcessor<XmlTag>(){
                final String canonicalText;
                {
                    this.canonicalText = this.getCanonicalText();
                }

                public boolean execute(@NotNull XmlTag element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.canonicalText.equals(element.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME))) {
                        result[0] = element;
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference$1", "execute"));
                }
            });
            return result[0];
        }

        public Object @NotNull [] getVariants() {
            final ArrayList result = new ArrayList(1);
            this.processTags((PsiElementProcessor<? super XmlTag>)new PsiElementProcessor<XmlTag>(){

                public boolean execute(@NotNull XmlTag element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    result.add(element.getAttributeValue(WSDLReferenceProvider.NAME_ATTR_NAME));
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference$2", "execute"));
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                WsdlEntityReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        protected void processTags(PsiElementProcessor<? super XmlTag> processor) {
            XmlTag[] subTags;
            XmlTag rootTag = WSDLReferenceProvider.getRootTag(this.getElement());
            if (rootTag == null) {
                return;
            }
            for (XmlTag t : subTags = WSDLReferenceProvider.getWsdlTags(rootTag, this.entityName)) {
                if (processor.execute((PsiElement)t)) continue;
                return;
            }
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlEntityReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class WsdlMethodReference
    extends BaseRangedReference {
        public WsdlMethodReference(@NotNull PsiElement psiElement, int start, int end) {
            if (psiElement == null) {
                WsdlMethodReference.$$$reportNull$$$0(0);
            }
            super(psiElement, start, end);
        }

        public WsdlMethodReference(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                WsdlMethodReference.$$$reportNull$$$0(1);
            }
            super(psiElement, 1, psiElement.getTextLength() - 1);
        }

        @Nullable
        public PsiElement resolve() {
            PsiElement psiElement = this.resolveClass();
            if (psiElement instanceof PsiClass) {
                return (PsiElement)ArrayUtil.getFirstElement((Object[])((PsiClass)psiElement).findMethodsByName(this.getCanonicalText(), false));
            }
            return null;
        }

        @Nullable
        protected PsiElement resolveClass() {
            XmlAttributeValue xmlAttributeValue;
            XmlTag grandParentTag = (XmlTag)this.getElement().getParent().getParent().getParent();
            String attrNameContainingClassReference = "binding".equals(grandParentTag.getLocalName()) ? WSDLReferenceProvider.TYPE_ATTR_NAME : WSDLReferenceProvider.NAME_ATTR_NAME;
            XmlAttribute attribute = grandParentTag.getAttribute(attrNameContainingClassReference, null);
            XmlAttributeValue xmlAttributeValue2 = xmlAttributeValue = attribute != null ? attribute.getValueElement() : null;
            if (xmlAttributeValue != null) {
                PsiReference[] references = xmlAttributeValue.getReferences();
                PsiReference psiReference = references.length > 0 ? references[references.length - 1] : null;
                return psiReference != null ? psiReference.resolve() : null;
            }
            return null;
        }

        public Object @NotNull [] getVariants() {
            PsiElement psiElement = this.resolveClass();
            if (psiElement instanceof PsiClass) {
                PsiClass clazz = (PsiClass)psiElement;
                ArrayList<String> acceptableMethods = new ArrayList<String>(4);
                for (PsiMethod m : clazz.getMethods()) {
                    if (!DeployUtils.isAcceptableMethod(m)) continue;
                    acceptableMethods.add(m.getName());
                }
                Object[] objectArray = ArrayUtil.toObjectArray(acceptableMethods);
                if (objectArray == null) {
                    WsdlMethodReference.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                WsdlMethodReference.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlMethodReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/references/WSDLReferenceProvider$WsdlMethodReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

