/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.ws.WSBundle;
import com.intellij.ws.inspections.fixes.RemoveElementFix;
import com.intellij.ws.references.WSReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropOrderReference
extends WSReference<PsiLiteralExpression> {
    private PsiLiteralExpression myLiteralExpression;

    public PropOrderReference(PsiLiteralExpression psiElement) {
        super((PsiElement)psiElement, true);
        this.myLiteralExpression = psiElement;
    }

    @NotNull
    public PsiLiteralExpression getElement() {
        PsiLiteralExpression psiLiteralExpression = this.myLiteralExpression;
        if (psiLiteralExpression == null) {
            PropOrderReference.$$$reportNull$$$0(0);
        }
        return psiLiteralExpression;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass clazz = this.findClass();
        if (clazz != null) {
            String name = this.getCanonicalText();
            if (PropOrderReference.hasFieldAccessorType(clazz)) {
                return clazz.findFieldByName(name, false);
            }
            return PropertyUtilBase.findPropertyGetter((PsiClass)clazz, (String)name, (boolean)false, (boolean)true);
        }
        return null;
    }

    private static boolean hasFieldAccessorType(PsiClass clazz) {
        String value;
        PsiNameValuePair[] attributes;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{"javax.xml.bind.annotation.XmlAccessorType"});
        if (annotation != null && (attributes = annotation.getParameterList().getAttributes()).length == 1 && (value = attributes[0].getText()) != null) {
            return value.contains("FIELD");
        }
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object value = this.myLiteralExpression.getValue();
        String string = PropOrderReference.hasFieldAccessorType(this.findClass()) ? WSBundle.message("field.doesnt.exist", value) : WSBundle.message("property.doesnt.exist", value);
        if (string == null) {
            PropOrderReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private PsiClass findClass() {
        PsiElement clazz;
        PsiElement element;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiAnnotation.class);
        if (annotation != null && (element = annotation.getParent()) instanceof PsiModifierList && (clazz = element.getParent()) instanceof PsiClass) {
            return (PsiClass)clazz;
        }
        return null;
    }

    public LookupElement @NotNull [] getVariants() {
        PsiClass clazz = this.findClass();
        if (clazz == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                PropOrderReference.$$$reportNull$$$0(2);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        List<String> existent = this.getExistingProperties();
        if (PropOrderReference.hasFieldAccessorType(clazz)) {
            for (PsiField field : clazz.getFields()) {
                String name = field.getName();
                if (existent.contains(name)) continue;
                lookups.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.FIELD_ICON).bold());
            }
        } else {
            ArrayList properties = new ArrayList(PropertyUtilBase.getAllProperties((PsiClass)clazz, (boolean)false, (boolean)true).keySet());
            properties.removeAll(existent);
            for (String property : properties) {
                lookups.add(LookupElementBuilder.create((String)property).withIcon(PlatformIcons.METHOD_ICON).bold());
            }
        }
        LookupElement[] lookupElementArray = (LookupElement[])lookups.toArray(new LookupElementBuilder[0]);
        if (lookupElementArray == null) {
            PropOrderReference.$$$reportNull$$$0(3);
        }
        return lookupElementArray;
    }

    @NotNull
    private List<String> getExistingProperties() {
        ArrayList<String> list = new ArrayList<String>();
        PsiElement parent = this.myLiteralExpression.getParent();
        if (parent instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)parent).getInitializers()) {
                Object value;
                PsiElement element = initializer.getOriginalElement();
                if (!(element instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)element).getValue()) instanceof String)) continue;
                list.add(value.toString());
            }
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            PropOrderReference.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PropOrderReference.$$$reportNull$$$0(5);
        }
        Project project = this.myLiteralExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String name = PropertyUtilBase.getPropertyName((String)newElementName);
        name = name == null ? newElementName : name;
        PsiExpression newElement = factory.createExpressionFromText("\"" + name + "\"", null);
        this.myLiteralExpression = (PsiLiteralExpression)this.myLiteralExpression.replace((PsiElement)newElement);
        return this.myLiteralExpression;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Object value;
        if (element == null) {
            PropOrderReference.$$$reportNull$$$0(6);
        }
        PsiClass psiClass = this.findClass();
        if (element instanceof BeanPropertyElement) {
            element = ((BeanPropertyElement)element).getMethod();
        }
        if (element instanceof PsiMember && ((PsiMember)element).getContainingClass() == psiClass && psiClass != null && (value = this.myLiteralExpression.getValue()) instanceof String) {
            if (PropOrderReference.hasFieldAccessorType(psiClass)) {
                return element instanceof PsiField && psiClass.findFieldByName((String)value, false) != null;
            }
            return element instanceof PsiMethod && value.equals(PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)element)));
        }
        return false;
    }

    public LocalQuickFix[] getQuickFixes() {
        PsiElement parent;
        Object fix;
        PsiClass psiClass;
        ArrayList<Object> fixes = new ArrayList<Object>();
        Object value = this.myLiteralExpression.getValue();
        if (value instanceof String && (psiClass = this.findClass()) != null && (fix = PropOrderReference.hasFieldAccessorType(psiClass) ? new CreateFieldOrPropertyFix(psiClass, (String)value, (PsiType)PsiType.getJavaLangString((PsiManager)psiClass.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiClass.getProject())), PropertyMemberType.FIELD, PsiAnnotation.EMPTY_ARRAY) : CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)("public java.lang.String get" + StringUtil.capitalize((String)((String)value)) + "()"), (String)"return null;")) != null) {
            fixes.add(fix);
        }
        fixes.add(new RemoveElementFix((PsiElement)((parent = this.myLiteralExpression.getParent()) instanceof PsiNameValuePair ? parent : this.myLiteralExpression), WSBundle.message("remove", new Object[0])));
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/PropOrderReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProperties";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/PropOrderReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

