/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.references.WSDLReferenceProvider;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JAXBSchemaReferenceProvider
extends MyReferenceProvider {
    @Override
    public ElementFilter getAttributeFilter() {
        return null;
    }

    @Override
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            JAXBSchemaReferenceProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof XmlAttributeValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JAXBSchemaReferenceProvider.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag tag = (XmlTag)element.getParent().getParent();
        String tagLocalName = tag.getLocalName();
        String tagNS = tag.getNamespace();
        if (Arrays.binarySearch(WSDLReferenceProvider.SCHEMA_URIS, tagNS) >= 0) {
            PsiFile psiFile = tag.getContainingFile().getOriginalFile();
            VirtualFile file = psiFile.getVirtualFile();
            if (file == null || !"xsd".equals(file.getExtension())) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    JAXBSchemaReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if ("complexType".equals(tagLocalName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JaxbClassReference((XmlAttributeValue)element)};
                if (psiReferenceArray == null) {
                    JAXBSchemaReferenceProvider.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }
            if ("element".equals(tagLocalName)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new WSDLReferenceProvider.WsdlPropertyReference(element)};
                if (psiReferenceArray == null) {
                    JAXBSchemaReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JAXBSchemaReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/references/JAXBSchemaReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/references/JAXBSchemaReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JaxbClassReference
    extends WSDLReferenceProvider.WsdlClassReference {
        JaxbClassReference(XmlAttributeValue psiElement) {
            super(psiElement);
        }

        @Override
        @NotNull
        public String getCanonicalText() {
            String string = StringUtil.capitalize((String)super.getCanonicalText());
            if (string == null) {
                JaxbClassReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JAXBSchemaReferenceProvider$JaxbClassReference", "getCanonicalText"));
        }
    }
}

