/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ws.WSBundle;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import com.intellij.ws.utils.DeployUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class WSLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement context) {
        PsiClass psiClass;
        WSIndexEntry[] entries;
        PsiClass psiClass2;
        if (context == null) {
            WSLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(context instanceof PsiIdentifier)) {
            return null;
        }
        final PsiElement element = context.getParent();
        if (element instanceof PsiClass) {
            psiClass2 = (PsiClass)element;
            entries = FileBasedWSIndex.getWsEntries(psiClass2);
        } else if (element instanceof PsiMethod) {
            psiClass2 = ((PsiMethod)element).getContainingClass();
            if (psiClass2 == null) {
                return null;
            }
            String key = FileBasedWSIndex.getKey((PsiMember)psiClass2);
            if (key == null) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return null;
            }
            entries = FileBasedWSIndex.getEntries(module, psiClass2.getName());
        } else {
            entries = null;
        }
        if (entries == null || entries.length == 0) {
            return null;
        }
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(entries.length);
        final ArrayList<TextRange> ranges = new ArrayList<TextRange>(entries.length);
        Project project = element.getProject();
        PsiMember member = (PsiMember)element;
        PsiClass psiClass3 = psiClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
        if (psiClass == null || !BaseWebServicesInspection.getClassContext(psiClass).isExternallyBound()) {
            return null;
        }
        for (WSIndexEntry entry : entries) {
            if (!entry.isResolved(project)) {
                entry.resolve(project);
            }
            TextRange wsRange = entry.getWsRange(member);
            VirtualFile file = entry.getFile();
            if (wsRange == null || file == null) continue;
            files.add(file);
            ranges.add(wsRange);
        }
        if (member instanceof PsiMethod && !DeployUtils.canBeWebMethod(member)) {
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        GutterIconNavigationHandler<PsiElement> handler = new GutterIconNavigationHandler<PsiElement>(){

            public void navigate(MouseEvent e, PsiElement ___) {
                if (entries.length > 1 && files.size() > 1) {
                    JBList list = new JBList((ListModel)new AbstractListModel<VirtualFile>(){

                        @Override
                        public int getSize() {
                            return files.size();
                        }

                        @Override
                        public VirtualFile getElementAt(int index) {
                            return (VirtualFile)files.get(index);
                        }
                    });
                    list.setCellRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            return super.getListCellRendererComponent((JList<?>)list, ((VirtualFile)value).getPresentableName(), index, isSelected, cellHasFocus);
                        }
                    });
                    JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(WSBundle.message("webservices.select.target", new Object[0])).setItemChoosenCallback(() -> 1.lambda$navigate$0((JList)list, files, ranges, element)).createPopup().show(new RelativePoint(e));
                } else if (!files.isEmpty() && !ranges.isEmpty()) {
                    WSLineMarkerProvider.navigate((VirtualFile)files.get(0), (TextRange)ranges.get(0), element.getManager());
                }
            }

            private static /* synthetic */ void lambda$navigate$0(JList list, List files2, List ranges2, PsiElement element2) {
                int selectedIndex = list.getSelectedIndex();
                if (selectedIndex == -1) {
                    return;
                }
                WSLineMarkerProvider.navigate((VirtualFile)files2.get(selectedIndex), (TextRange)ranges2.get(selectedIndex), element2.getManager());
            }
        };
        return new LineMarkerInfo(context, context.getTextRange(), AllIcons.Nodes.PpWeb, elem -> WSLineMarkerProvider.getTooltipText(entries, elem.getParent()), (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT);
    }

    private static void navigate(@NotNull VirtualFile file, @NotNull TextRange range, @NotNull PsiManager psiManager) {
        if (file == null) {
            WSLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            WSLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (psiManager == null) {
            WSLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (file.isValid()) {
            PsiElement elementAt;
            XmlFile psiFile = (XmlFile)psiManager.findFile(file);
            assert (psiFile != null);
            int startOffset = range.getStartOffset();
            if (startOffset < psiFile.getTextLength() && (elementAt = psiFile.findElementAt(startOffset)) instanceof Navigatable) {
                ((Navigatable)elementAt).navigate(true);
            }
        }
    }

    private static String getTooltipText(WSIndexEntry[] entries, PsiElement member) {
        if (!(member instanceof PsiMember)) {
            return "";
        }
        StringBuilder messageSource = new StringBuilder();
        for (WSIndexEntry entry : entries) {
            String wsStatus = entry.getWsStatus((PsiMember)member);
            if (wsStatus == null || messageSource.indexOf(wsStatus) != -1) continue;
            if (messageSource.length() > 0) {
                messageSource.append(',');
            }
            messageSource.append(wsStatus);
        }
        return messageSource.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/inspections/WSLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

