/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.DeploymentTimeCheckProcessor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ValidExternallyBoundObjectInspection
extends BaseWebServicesInspection {
    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            ValidExternallyBoundObjectInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected final void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
        BaseWebServicesInspection.ExternallyBoundClassContext context = ValidExternallyBoundObjectInspection.getClassContext(c);
        if (!context.isExternallyBound()) {
            return;
        }
        String s = DeploymentTimeCheckProcessor.checkAccessibleClass(c);
        PsiJavaCodeReferenceElement refElement = context.annotation == null ? null : context.annotation.getNameReferenceElement();
        PsiIdentifier nameIdentifier = c.getNameIdentifier();
        if (s != null && refElement != null && nameIdentifier != null) {
            WSIndexEntry[] entries = context.getEntries(ModuleUtilCore.findModuleForPsiElement((PsiElement)c));
            String messagePrefix = entries.length > 0 ? entries[0].getWsStatus((PsiMember)c) : ("WebService".equals(refElement.getText()) ? WSBundle.message("webservices.inspections.web.service", new Object[0]) : WSBundle.message("webservices.inspections.mapped.object", new Object[0]));
            problemsHolder.registerProblem((PsiElement)nameIdentifier, messagePrefix + WSBundle.message("webservices.inspections.problem", new Object[0]) + s, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
        }
        if (context.annotation != null && nameIdentifier != null && JWSDPWSEngine.isClassInDefaultPackageWithNoTargetNs(c)) {
            problemsHolder.registerProblem((PsiElement)nameIdentifier, WSBundle.message("class.in.default.package.should.have.targetnamespace.specified.validation.message", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
        }
    }

    @Override
    protected final void checkMember(final ProblemsHolder problemsHolder, PsiMember member) {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return;
        }
        BaseWebServicesInspection.ExternallyBoundClassContext classContext = ValidExternallyBoundObjectInspection.getClassContext(containingClass);
        if (!classContext.isExternallyBound()) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
        final WSIndexEntry[] wsEntries = FileBasedWSIndex.getWsEntries(Arrays.asList(classContext.getEntries(module)), member);
        if (wsEntries.length > 0 || classContext.containingClassIsExternallyBound && member instanceof PsiMethod && PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)member)) == null && (member.hasModifierProperty("public") || AnnotationUtil.findAnnotation((PsiModifierListOwner)member, JWSDPWSEngine.wsMethodsSet) != null)) {
            if (member instanceof PsiField) {
                PsiField f = (PsiField)member;
                if (f.hasModifierProperty("final") && f.hasModifierProperty("static")) {
                    return;
                }
                boolean acceptableField = f.hasModifierProperty("public");
                if (!acceptableField) {
                    problemsHolder.registerProblem((PsiElement)f.getNameIdentifier(), wsEntries[0].getWsStatus((PsiMember)f) + WSBundle.message("webservices.inspections.problem", new Object[0]) + " " + WSBundle.message("webservices.inspections.field.should.be.public", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                } else {
                    String problem = DeploymentTimeCheckProcessor.getDeploymentProblemForType(f.getType());
                    if (problem != null) {
                        problemsHolder.registerProblem((PsiElement)f.getNameIdentifier(), WSBundle.message("webservices.inspections.problem.found", wsEntries[0].getWsStatus((PsiMember)f), problem), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                    }
                }
            } else if (member instanceof PsiMethod && DeployUtils.canBeWebMethod(member)) {
                PsiMethod method = (PsiMethod)member;
                DeploymentTimeCheckProcessor processor = new DeploymentTimeCheckProcessor(){

                    @Override
                    public void processMethod(PsiMethod method, String problem, List<String> nonelementaryTypes) {
                        if (problem != null) {
                            String messagePrefix = wsEntries.length > 0 ? wsEntries[0].getWsStatus((PsiMember)method) : WSBundle.message("webservice.webmethod", new Object[0]);
                            problemsHolder.registerProblem((PsiElement)method.getNameIdentifier(), WSBundle.message("webservices.inspections.problem.found", messagePrefix, problem), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                        }
                    }
                };
                processor.processMethod(method);
                String name = PropertyUtilBase.getPropertyName((PsiMethod)method);
                if (name != null && PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
                    PsiMethod propertySetter = PropertyUtilBase.findPropertySetter((PsiClass)containingClass, (String)name, (boolean)false, (boolean)false);
                    if (propertySetter == null) {
                        problemsHolder.registerProblem((PsiElement)method.getNameIdentifier(), WSBundle.message("webservices.inspections.no.setter.for.property", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, LocalQuickFix.EMPTY_ARRAY);
                    } else {
                        processor.processMethod(propertySetter);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/ValidExternallyBoundObjectInspection", "getDefaultLevel"));
    }
}

