/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.ws.WSBundle;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;

public class EmptyWebServiceInspection
extends BaseWebServicesInspection {
    @Override
    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
        BaseWebServicesInspection.ExternallyBoundClassContext context = EmptyWebServiceInspection.getClassContext(c);
        if (context == null || !context.isExternallyBound() || context.annotation == null) {
            return;
        }
        WSIndexEntry[] entries = context.getEntries(ModuleUtilCore.findModuleForPsiElement((PsiElement)c));
        if (entries == null) {
            return;
        }
        PsiJavaCodeReferenceElement referenceElement = context.annotation.getNameReferenceElement();
        if (entries.length > 0 && entries[0] != null && "Web service".equals(entries[0].getWsStatus((PsiMember)c)) || referenceElement != null && "WebService".equals(referenceElement.getText())) {
            boolean hasPublicMethod = false;
            for (PsiMethod m : c.getAllMethods()) {
                PsiClass containingClass;
                if (m.isConstructor() || m.hasModifierProperty("static") || (containingClass = m.getContainingClass()) == null || !m.hasModifierProperty("public") || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                hasPublicMethod = true;
                break;
            }
            PsiIdentifier identifier = c.getNameIdentifier();
            if (!hasPublicMethod && identifier != null) {
                problemsHolder.registerProblem((PsiElement)identifier, WSBundle.message("webservices.inspections.web.service.without.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, LocalQuickFix.EMPTY_ARRAY);
            }
        }
    }

    @Override
    protected final void checkMember(ProblemsHolder problemsHolder, PsiMember member) {
    }
}

