/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginConfigurable;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.facet.BaseWebServicesFacetConfiguration;
import com.intellij.ws.facet.JAXWSLibraryType;
import com.intellij.ws.facet.client.WebServicesClientLibraries;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebServicesSupportProviderBase<F extends Facet<? extends BaseWebServicesFacetConfiguration>>
extends FacetBasedFrameworkSupportProvider<F> {
    @NlsSafe
    private static final String NO_ENGINES_TEMPLATE = "<html>%s<br>%s <a href=\"%s\">%s</a></html>";
    private boolean myGenerateExample = PropertiesComponent.getInstance().getBoolean(this.getGenerateSampleCodeProperty(), true);
    private final JCheckBox myCheckBox = new JCheckBox(this.getGenerateCheckboxName(), this.myGenerateExample);

    public WebServicesSupportProviderBase(FacetType<F, ?> facetType) {
        super(facetType);
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        String defaultVersion = JWSDPWSEngine.getJwsdpPlatform();
        String[] versions = WebServicesPluginSettings.getInstance().getEngineManager().getConfiguredWSEngines();
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (String version : versions) {
            result.add(new FrameworkVersion(version, defaultVersion.equals(version)));
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            WebServicesSupportProviderBase.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected void setupConfiguration(F webServicesFacet, ModifiableRootModel modifiableRootModel, FrameworkVersion version) {
        WSEngine wsEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(version.getVersionName());
        ((BaseWebServicesFacetConfiguration)webServicesFacet.getConfiguration()).setWsEngine(wsEngine);
        Module module = webServicesFacet.getModule();
        EnableWebServicesSupportUtils.ensureAnnotationsAreAllowedInJdkIfNeeded(wsEngine, module);
        DumbService.getInstance((Project)module.getProject()).smartInvokeLater(() -> {
            if (!module.isDisposed()) {
                this.enableWebServicesSupport(module, wsEngine, this.myGenerateExample && this.myCheckBox.isEnabled(), webServicesFacet);
            }
        }, ModalityState.NON_MODAL);
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            WebServicesSupportProviderBase.$$$reportNull$$$0(1);
        }
        return new MyFrameworkSupportConfigurableBase(model);
    }

    @Nls
    protected abstract String getGenerateCheckboxName();

    protected abstract String getGenerateSampleCodeProperty();

    protected abstract void enableWebServicesSupport(Module var1, WSEngine var2, boolean var3, F var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/facet/WebServicesSupportProviderBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/facet/WebServicesSupportProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFrameworkSupportConfigurableBase
    extends FrameworkSupportConfigurableBase
    implements FrameworkSupportWithLibrary {
        MyFrameworkSupportConfigurableBase(FrameworkSupportModel model) {
            super((FrameworkSupportProviderBase)WebServicesSupportProviderBase.this, model, WebServicesSupportProviderBase.this.getVersions(), WebServicesSupportProviderBase.this.getVersionLabelText());
            this.addListener(new FrameworkSupportConfigurableListener(){

                public void frameworkVersionChanged() {
                    FrameworkVersion version = MyFrameworkSupportConfigurableBase.this.getSelectedVersion();
                    if (version != null) {
                        WSEngine engine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(version.getVersionName());
                        String notConfiguredMessage = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(engine, null);
                        WebServicesSupportProviderBase.this.myCheckBox.setEnabled(notConfiguredMessage == null);
                        if (notConfiguredMessage != null) {
                            WebServicesSupportProviderBase.this.myCheckBox.setToolTipText(notConfiguredMessage);
                        } else {
                            WebServicesSupportProviderBase.this.myCheckBox.setToolTipText(null);
                        }
                    }
                }
            });
        }

        public FrameworkLibraryVersionFilter getVersionFilter() {
            return null;
        }

        public boolean isVisible() {
            FrameworkVersion version = this.getSelectedVersion();
            return version != null && WebServicesClientLibraries.DEFAULT_VERSIONS.containsKey(version.getVersionName());
        }

        public JComponent getComponent() {
            final JPanel panel = new JPanel(new BorderLayout());
            WebServicesSupportProviderBase.this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebServicesSupportProviderBase.this.myGenerateExample = WebServicesSupportProviderBase.this.myCheckBox.isSelected();
                }
            });
            panel.add((Component)WebServicesSupportProviderBase.this.myCheckBox, "North");
            JComponent component = super.getComponent();
            if (component != null) {
                panel.add((Component)component, "Center");
            } else {
                List versions = this.getVersions();
                if (!versions.isEmpty()) {
                    final JEditorPane noEnginesLabel = new JEditorPane();
                    noEnginesLabel.setContentType("text/html");
                    noEnginesLabel.setPreferredSize(new Dimension(-1, 50));
                    noEnginesLabel.setEditable(false);
                    noEnginesLabel.setBackground(panel.getBackground());
                    noEnginesLabel.setEditorKit(UIUtil.getHTMLEditorKit());
                    String noEnginesMessage = String.format(WebServicesSupportProviderBase.NO_ENGINES_TEMPLATE, WSBundle.message("webservices.inspections.no.engines", new Object[0]), WSBundle.message("webservices.inspections.no.engines.default.used", ((FrameworkVersion)versions.get(0)).getVersionName()), WSBundle.message("webservices.inspections.no.engines.fix", new Object[0]), WSBundle.message("webservices.inspections.no.engines.configure", new Object[0]));
                    noEnginesLabel.setText(noEnginesMessage);
                    noEnginesLabel.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            HyperlinkEvent.EventType type = e.getEventType();
                            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                                ShowSettingsUtil.getInstance().editConfigurable((Component)noEnginesLabel, (Configurable)new WebServicesPluginConfigurable(){

                                    public void disposeUIResources() {
                                        super.disposeUIResources();
                                        List<FrameworkVersion> frameworkVersions = WebServicesSupportProviderBase.this.getVersions();
                                        if (frameworkVersions.size() > 1) {
                                            MyFrameworkSupportConfigurableBase.this.reloadVersions(frameworkVersions);
                                            this.replaceWithVersionsCombo();
                                        }
                                    }

                                    private void replaceWithVersionsCombo() {
                                        panel.remove(noEnginesLabel);
                                        MyFrameworkSupportConfigurableBase.this.updateAvailableVersions(MyFrameworkSupportConfigurableBase.this.getVersions());
                                        panel.add((Component)MyFrameworkSupportConfigurableBase.super.getComponent(), "Center");
                                        panel.revalidate();
                                        panel.repaint();
                                    }
                                });
                            }
                        }
                    });
                    noEnginesLabel.setBorder(JBUI.Borders.empty((int)5));
                    panel.add((Component)noEnginesLabel, "Center");
                }
            }
            return panel;
        }

        @Nullable
        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(JAXWSLibraryType.class);
        }

        public boolean isLibraryOnly() {
            return false;
        }
    }
}

