/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.jwsdp;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.ws.WSAnnotations;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.ExternalEngineThatBundlesJEEJars;
import com.intellij.ws.engines.ExternalEngineThatChangedTheName;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.jaxrpc.JaxRPCWSEngine;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.utils.WSInvokeExternalCodeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JWSDPWSEngine
implements WSEngine,
ExternalEngineThatChangedTheName,
ExternalEngineThatBundlesJEEJars {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.jwsdpengine");
    private static final String JWSDP_IN_GLASS_FISH_LIBRARY_NAME = "Web Services Library in GlassFish";
    private static final String JWSDP_IN_GLASS_FISH2_LIBRARY_NAME = "Web Services Library in GlassFish v2";
    private static final String METRO_LIBRARY_NAME = "Web Services Library in Metro";
    private static final String OLD_JWSDP_PLATFORM = "Glassfish / JAXWS2.X RI / JWSDP 2.0";
    @NonNls
    private final String[] pathComponents = new String[]{"WEB-INF", "sun-jaxws.xml"};
    private static final boolean CREATE_AT_CONTENT_ROOT = true;
    @NonNls
    public static final String wsWebMethod = WSAnnotations.WEB_METHOD.javax();
    @NonNls
    public static final HashSet<String> wsClassesSet = new HashSet<String>(Collections.singletonList(WSAnnotations.WEB_SERVICE.javax()));
    @NonNls
    public static final HashSet<String> wsMethodsSet = new HashSet<String>(Collections.singletonList(wsWebMethod));
    @NonNls
    public static final HashSet<String> wsOneWayMethodSet = new HashSet<String>(Collections.singletonList(WSAnnotations.WS_ONE_WAY.javax()));
    @NonNls
    public static final String GLASSFISH1_WEB_SERVICES_JAR_NAME = "appserv-ws.jar";
    @NonNls
    public static final String GLASSFISH2_WEB_SERVICES_JAR_NAME = "webservices-tools.jar";
    @NonNls
    public static final String GLASSFISH3_WEB_SERVICES_JAR_NAME = "webservices-osgi.jar";
    @NonNls
    public static final String JAXWS_RT_JAR_NAME = "jaxws-rt.jar";
    public static final InvokeExternalCodeUtil.OutputConsumer ERROR_CHECKER = new InvokeExternalCodeUtil.OutputConsumer(){

        public boolean handle(String output, String errOutput) throws InvokeExternalCodeUtil.ExternalCodeException {
            String error = "error:";
            if (output.startsWith("error:")) {
                throw new InvokeExternalCodeUtil.ExternalCodeException(output.substring("error:".length()).trim());
            }
            String error2 = "[ERROR]";
            for (String out : output.replace('\r', '\n').split("\n")) {
                if (!out.startsWith("[ERROR]")) continue;
                throw new InvokeExternalCodeUtil.ExternalCodeException(out.substring("[ERROR]".length()).trim());
            }
            return true;
        }
    };
    @NonNls
    private static final String[] jdk16ApiFilesToOverride = new String[]{"webservices-api.jar", "jaxws-api.jar", "jaxb-api.jar"};

    @Override
    public String getName() {
        return JWSDPWSEngine.getJwsdpPlatform();
    }

    public static boolean isGlassfish3(String basePath) {
        return new File(basePath + File.separatorChar + "glassfish" + File.separatorChar + "modules" + File.separatorChar + GLASSFISH3_WEB_SERVICES_JAR_NAME).exists();
    }

    public static LibraryDescriptor[] getLibInfosIfGlassFishOrMetroInstall(@NotNull String basePath, boolean generatedCode) {
        String[] files;
        if (basePath == null) {
            JWSDPWSEngine.$$$reportNull$$$0(0);
        }
        char sep = File.separatorChar;
        File glassFishLib = new File(basePath + sep + "lib" + sep + GLASSFISH1_WEB_SERVICES_JAR_NAME);
        File glassFishLib2 = new File(basePath + sep + "lib" + sep + GLASSFISH2_WEB_SERVICES_JAR_NAME);
        File glassFishLib3 = new File(basePath + sep + "glassfish" + sep + "modules" + sep + GLASSFISH3_WEB_SERVICES_JAR_NAME);
        if (glassFishLib3.exists()) {
            return new LibraryDescriptor[]{new LibraryInfo(JWSDP_IN_GLASS_FISH_LIBRARY_NAME, new String[]{"glassfish" + sep + "modules" + sep + GLASSFISH3_WEB_SERVICES_JAR_NAME, "glassfish" + sep + "modules" + sep + "jaxb-osgi.jar", "glassfish" + sep + "modules" + sep + "endorsed" + sep + "webservices-api-osgi.jar", "glassfish" + sep + "modules" + sep + "endorsed" + sep + "jaxb-api-osgi.jar"}, false)};
        }
        if (glassFishLib.exists() && !glassFishLib2.exists()) {
            return new LibraryDescriptor[]{new LibraryInfo(JWSDP_IN_GLASS_FISH_LIBRARY_NAME, new String[]{"lib" + sep + GLASSFISH1_WEB_SERVICES_JAR_NAME, "lib" + sep + "javaee.jar"}, false)};
        }
        if (glassFishLib2.exists()) {
            Object[] glassfish2Libs = new String[]{"lib" + sep + GLASSFISH2_WEB_SERVICES_JAR_NAME};
            if (generatedCode) {
                glassfish2Libs = (String[])ArrayUtil.append((Object[])glassfish2Libs, (Object)("lib" + sep + "webservices-rt.jar"));
            }
            Object[] libs = glassfish2Libs;
            File apiLib = new File(basePath + sep + "lib" + sep + "webservices-api.jar");
            boolean metro = apiLib.exists();
            if (metro) {
                String[] metroLibs = new String[]{"lib" + sep + "webservices-api.jar", "lib" + sep + "webservices-extra-api.jar", "lib" + sep + "webservices-extra.jar"};
                libs = ArrayUtil.mergeArrays((String[])libs, (String[])metroLibs);
            } else {
                libs = (String[])ArrayUtil.append((Object[])libs, (Object)("lib" + sep + "javaee.jar"));
            }
            return new LibraryDescriptor[]{new LibraryInfo(metro ? METRO_LIBRARY_NAME : JWSDP_IN_GLASS_FISH2_LIBRARY_NAME, (String[])libs, false)};
        }
        File lib = new File(basePath, "lib");
        File toolsJar = new File(lib, "jaxws-tools.jar");
        if (toolsJar.exists() && (files = lib.list((dir, name) -> new File(dir, name).isFile())) != null) {
            String[] libJars = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                libJars[i] = "lib" + File.separator + files[i];
            }
            return new LibraryDescriptor[]{new LibraryInfo("JAXWS", libJars)};
        }
        return LibraryDescriptor.EMPTY_ARRAY;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        return LibraryDescriptor.EMPTY_ARRAY;
    }

    private boolean isStandAloneJwsdp2() {
        return new File(this.getBasePath() + File.separator + "jaxws").exists();
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getJwsdpPath();
    }

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return false;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return false;
    }

    @Override
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return null;
    }

    @Override
    public String getDeploymentServletName() {
        return "WSServlet";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "com.sun.xml.ws.transport.http.servlet.WSServlet";
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])this.pathComponents, (InputStream)LibUtils.getResourcesStream("sun-jaxws.xml"), (boolean)true, (boolean)false, (WebFacet)webFacet);
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        if (clazz.isInterface()) {
            return WSBundle.message("jaxws.does.not.support.wsdl.generation.from.interface.validation.message", new Object[0]);
        }
        if (JWSDPWSEngine.isClassInDefaultPackageWithNoTargetNs(clazz)) {
            return WSBundle.message("no.targetnamespace.is.specified.validation.message", new Object[0]);
        }
        return JWSDPWSEngine.checkProperlyAnnotated(clazz);
    }

    public static boolean isClassInDefaultPackageWithNoTargetNs(PsiClass clazz) {
        PsiAnnotation annotation;
        String name = clazz.getName();
        if (name != null && name.equals(clazz.getQualifiedName()) && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, wsClassesSet)) != null) {
            PsiAnnotationMemberValue annotationMemberValue = annotation.findAttributeValue("targetNamespace");
            return annotationMemberValue == null || annotationMemberValue instanceof PsiLiteralExpression && StringUtil.stripQuotesAroundValue((String)annotationMemberValue.getText()).length() <= 0;
        }
        return false;
    }

    @Nullable
    @Nls
    private static String checkProperlyAnnotated(PsiClass clazz) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, wsClassesSet) == null ? JWSDPWSEngine.getSelectedClassIsNotMarkedWithJavaxJwsWebServiceAnnotation() : null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        if (JWSDPWSEngine.isClassInDefaultPackageWithNoTargetNs(clazz)) {
            return WSBundle.message("no.targetnamespace.is.specified.validation.message", new Object[0]);
        }
        return JWSDPWSEngine.checkProperlyAnnotated(clazz);
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<? super File> onSuccessAction, Consumer<? super Exception> onException, Runnable editAgain) {
        PsiClass psiClass = options.getClassForOperation();
        String generateWsdlDir = psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
        File tempFile = new File(generateWsdlDir + "/" + psiClass.getName() + ".wsdl");
        try {
            File tempDir = FileUtils.createTempDir((String)"jaxwsgen");
            String wsQName = "{" + options.getWebServiceNamespace() + "}" + psiClass.getName();
            this.doGenerateServerDeploymentCode("Generate Wsdl From Java", options.getModule(), options.getClassForOperation().getQualifiedName(), tempDir.getPath(), new String[]{"-wsdl", "-r", generateWsdlDir, "-servicename", wsQName, "-portname", wsQName}, () -> {
                try {
                    FileUtils.copyWsdlWithReplacementOfSoapAddress((File)tempFile, (File)tempFile, (String)options.getWebServiceURL());
                    options.getSuccessRunnable(onSuccessAction, tempFile).run();
                }
                catch (IOException e) {
                    onException.consume((Object)e);
                }
            }, onException, options.isParametersStillValidPredicate(), editAgain);
        }
        catch (IOException e) {
            onException.consume((Object)e);
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            JWSDPWSEngine.$$$reportNull$$$0(1);
        }
        if (onExceptionAction == null) {
            JWSDPWSEngine.$$$reportNull$$$0(2);
        }
        DeployUtils.addToConfigFile(this.pathComponents, true, module, "<endpoint\n        name='" + createOptions.getWsName() + "'\n        implementation='" + createOptions.getWsClassName() + "'\n        url-pattern='" + JaxRPCWSEngine.createUrlPatternForWebService(createOptions) + "'/>", this);
    }

    private void doGenerateServerDeploymentCode(String title, Module module, String wsclassname, String generateSourcesDir, @NonNls String[] additionalOptions, Runnable onSuccessAction, Consumer<? super Exception> onException, Computable<Boolean> runAgainPredicate, Runnable editAgain) {
        String basePath;
        @NonNls ArrayList<String> parameters2 = new ArrayList<String>(1);
        if (additionalOptions != null) {
            Collections.addAll(parameters2, additionalOptions);
        }
        boolean runningOnJDK6 = (basePath = this.getBasePath()) == null && !WebServicePlatformUtils.isOldWsGenAccessibleForModule(module);
        parameters2.add("-d");
        parameters2.add(generateSourcesDir);
        parameters2.add("-cp");
        parameters2.add(".");
        String[] classpath = basePath == null ? JWSDPWSEngine.getClasspathForModule(module, runningOnJDK6) : LibUtils.getLibsUrlsFromLibInfos(JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, false), basePath);
        parameters2.add(wsclassname);
        FileUtils.addClassAsCompilerResource((Project)module.getProject());
        WsJavaExternalProcessHandler externalProcessHandler = new WsJavaExternalProcessHandler(title, runningOnJDK6 ? "com.sun.tools.internal.ws.WsGen" : "com.sun.tools.ws.WsGen", classpath, ArrayUtilRt.toStringArray(parameters2), module, false);
        try {
            File tempFile = FileUtil.createTempFile((String)"logging", (String)".config");
            FileUtils.saveStreamContentAsFile((String)tempFile.getPath(), (InputStream)new StringBufferInputStream(".level= WARNING"));
            externalProcessHandler.addCommandLineProperty("java.util.logging.config.file", tempFile.getPath());
        }
        catch (IOException e) {
            onException.consume((Object)e);
            return;
        }
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(externalProcessHandler, this, module);
        externalProcessHandler.setOutputConsumer(new InvokeExternalCodeUtil.OutputConsumer(){

            public boolean handle(String output, String errOutput) throws InvokeExternalCodeUtil.ExternalCodeException {
                if (output.length() > 0) {
                    throw new InvokeExternalCodeUtil.ExternalCodeException(errOutput.length() > 0 ? errOutput : output);
                }
                return true;
            }
        });
        InvokeExternalCodeUtil.runViaConsole((ExternalProcessHandler)externalProcessHandler, (Project)module.getProject(), (Runnable)onSuccessAction, onException, runAgainPredicate, (Runnable)editAgain);
    }

    private static String[] getClasspathForModule(Module module, boolean runningOnJDK6) {
        SdkTypeId type;
        Sdk sdk;
        Object[] classpath = InvokeExternalCodeUtil.buildClasspathStringsForModule((Module)module);
        if (runningOnJDK6 && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && (type = sdk.getSdkType()) instanceof JavaSdk) {
            classpath = (String[])ArrayUtil.append((Object[])classpath, (Object)((JavaSdk)type).getToolsPath(sdk));
        }
        return classpath;
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            JWSDPWSEngine.$$$reportNull$$$0(3);
        }
        if (onExceptionAction == null) {
            JWSDPWSEngine.$$$reportNull$$$0(4);
        }
        DeployUtils.removeFromConfigFile(this.pathComponents, true, module, (Processor<? super XmlTag>)((Processor)xmlTag -> webServiceName.equals(xmlTag.getAttributeValue("name"))));
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        return this.analyzeAvailableWebServices(module, "name");
    }

    public String[] getAvailableWebServicesFQNs(Module module) {
        return this.analyzeAvailableWebServices(module, "implementation");
    }

    private String[] analyzeAvailableWebServices(Module module, final String attrName) {
        VirtualFile xml = CommonWsUtils.findFileByPath((Module)module, (String[])this.pathComponents, (boolean)true);
        if (xml == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        final ArrayList result = new ArrayList(1);
        try {
            NanoXmlUtil.parse((InputStream)xml.getInputStream(), (IXMLBuilder)new NanoXmlBuilder(){

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (attrName.equals(key)) {
                        result.add(value);
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ArrayUtilRt.toStringArray(result);
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        ArrayList<String> parameters2 = new ArrayList<String>(3);
        parameters2.add("-p");
        parameters2.add(options.getPackagePrefix());
        parameters2.add("-d");
        parameters2.add(options.getOutputPath());
        parameters2.add("-s");
        parameters2.add(options.getOutputPath());
        if (options.useExtensions()) {
            parameters2.add("-extension");
        }
        parameters2.add("-wsdllocation");
        parameters2.add(options.getWsdlUrl());
        parameters2.add(options.getWsdlUrl());
        String basePath = this.getBasePath();
        boolean runningOnJDK6 = basePath == null && !WebServicePlatformUtils.isOldWsGenAccessibleForModule(options.getSelectedModule());
        String wsImportClass = !runningOnJDK6 ? "com.sun.tools.ws.WsImport" : "com.sun.tools.internal.ws.WsImport";
        String[] libUrlsForToolRunning = basePath == null ? JWSDPWSEngine.getClasspathForModule(options.getSelectedModule(), runningOnJDK6) : LibUtils.getLibsUrlsFromLibInfos(JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, false), basePath);
        WsJavaExternalProcessHandler handler = new WsJavaExternalProcessHandler("WS Import", wsImportClass, libUrlsForToolRunning, ArrayUtilRt.toStringArray(parameters2), options.getSelectedModule(), basePath == null);
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(handler, this, options.getSelectedModule());
        handler.setOutputConsumer(ERROR_CHECKER);
        return handler;
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public boolean supportsJaxWs2() {
        return this.getBasePath() == null || !this.isStandAloneJwsdp2();
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "ijws";
    }

    @Override
    public boolean isYourOldName(@NotNull String name) {
        if (name == null) {
            JWSDPWSEngine.$$$reportNull$$$0(5);
        }
        return OLD_JWSDP_PLATFORM.equals(name);
    }

    @Override
    public String[] getJEEJarUrls(Module targetModule) {
        LibraryDescriptor[] descriptors;
        String basePath = this.getBasePath();
        if (basePath != null && (descriptors = JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, false)).length == 1) {
            return LibUtils.getLibsUrlsFromLibInfos(descriptors, basePath);
        }
        return JWSDPWSEngine.getJaxWsJarsForOverriding(this, targetModule);
    }

    public static String[] getJaxWsJarsForOverriding(@NotNull ExternalEngine engine, Module targetModule) {
        if (engine == null) {
            JWSDPWSEngine.$$$reportNull$$$0(6);
        }
        ArrayList<String> result = new ArrayList<String>(jdk16ApiFilesToOverride.length);
        String basePath = engine.getBasePath();
        String[] classpath = basePath == null ? InvokeExternalCodeUtil.buildClasspathForModule((Module)targetModule).split(System.getProperty("path.separator")) : LibUtils.getLibsUrlsFromLibInfos(JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, false), basePath);
        for (String descr : classpath) {
            for (String suffix : jdk16ApiFilesToOverride) {
                if (!descr.endsWith(suffix)) continue;
                result.add(descr);
            }
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public List<String> doGenerateJaxWsProxies(String wsclassname, Module module, VirtualFile outputDir) {
        @NonNls ArrayList<String> parameters2 = new ArrayList<String>(1);
        String basePath = this.getBasePath();
        boolean runningOnJDK6 = basePath == null && !WebServicePlatformUtils.isOldWsGenAccessibleForModule(module);
        parameters2.add("-d");
        parameters2.add(outputDir.getPath());
        parameters2.add("-cp");
        parameters2.add(outputDir.getPath());
        String[] classpath = basePath == null ? InvokeExternalCodeUtil.buildClasspathForModule((Module)module).split(System.getProperty("path.separator")) : LibUtils.getLibsUrlsFromLibInfos(JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, false), basePath);
        parameters2.add(wsclassname);
        WsJavaExternalProcessHandler externalProcessHandler = new WsJavaExternalProcessHandler("WsGen", runningOnJDK6 ? "com.sun.tools.internal.ws.WsGen" : "com.sun.tools.ws.WsGen", classpath, ArrayUtilRt.toStringArray(parameters2), module, false);
        try {
            File tempFile = FileUtil.createTempFile((String)"logging", (String)".config");
            FileUtils.saveStreamContentAsFile((String)tempFile.getPath(), (InputStream)new StringBufferInputStream(".level= WARNING"));
            externalProcessHandler.addCommandLineProperty("java.util.logging.config.file", tempFile.getPath());
        }
        catch (IOException tempFile) {
            // empty catch block
        }
        final ArrayList<String> exceptions = new ArrayList<String>();
        WSInvokeExternalCodeUtil.addEndorsedJarDirectory(externalProcessHandler, this, module);
        externalProcessHandler.setOutputConsumer(new InvokeExternalCodeUtil.OutputConsumer(){

            public boolean handle(String output, String errOutput) {
                if (output.length() > 0) {
                    exceptions.add(errOutput);
                }
                return true;
            }
        });
        try {
            InvokeExternalCodeUtil.doInvoke((ExternalProcessHandler)externalProcessHandler);
        }
        catch (InvokeExternalCodeUtil.ExternalCodeException externalCodeException) {
            // empty catch block
        }
        if (exceptions.size() > 0) {
            return exceptions;
        }
        return Collections.emptyList();
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return this.supportsJaxWs2() ? null : "j2ee1_4.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return !this.supportsJaxWs2() ? "j2ee1_4.webservice.java" : "jaxws.webservice.java";
    }

    @Nls
    private static String getSelectedClassIsNotMarkedWithJavaxJwsWebServiceAnnotation() {
        return WSBundle.message("selected.class.is.not.marked.with.javax.jws.webservice.annotation.validation.message", new Object[0]);
    }

    @Nls
    public static String getJwsdpPlatform() {
        return WSBundle.message("glassfish.jax.ws.2.x.ri.metro.1.x.jwsdp.2.0", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onExceptionAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/engines/jwsdp/JWSDPWSEngine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibInfosIfGlassFishOrMetroInstall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deployWebService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "undeployWebService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isYourOldName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getJaxWsJarsForOverriding";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

