/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.axis;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.DeploymentTimeCheckProcessor;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AxisWSEngine
implements WSEngine {
    @NonNls
    private final String[] pathComponents = new String[]{"WEB-INF", "server-config.wsdd"};
    private static final boolean CREATE_IN_CONTENT_ROOT = true;
    public static final String AXIS_PLATFORM = "Apache Axis";
    @NonNls
    private static final String SERVICE_TAG_NAME = "service";
    @NonNls
    private final Set<String> predefinedServices = ContainerUtil.set((Object[])new String[]{"AdminService", "Version", "SOAPMonitorService"});
    @NonNls
    private static final String WSDL2JAVA = "org.apache.axis.wsdl.WSDL2Java";
    @NonNls
    static final String TYPE_MAPPING = "<typeMapping qname=\"ns:%1$s\" xmlns:ns=\"%2$s\"\n    languageSpecificType=\"java:%3$s\"\n    serializer=\"%4$s\"\n    deserializer=\"%5$s\"\n    encodingStyle=\"%6$s\"/>\n";
    @NonNls
    static final String ARRAY_MAPPING = "<arrayMapping\n        xmlns:ns=\"%1$s\"\n        qname=\"ns:%2$s\"\n        type=\"java:%3$s\"\n        innerType=\"ns2:%4$s\" xmlns:ns2=\"%5$s\"\n        encodingStyle=\"%6$s\"/>\n";
    @NonNls
    static final String ENCODING_STYLE = "http://schemas.xmlsoap.org/soap/encoding/";
    @NonNls
    static final String SERVICE_DEF = "<service name=\"%1$s\" provider=\"java:RPC\" style=\"%2$s\" use=\"%3$s\">\n   <parameter name=\"className\" value=\"%4$s\"/>\n   <parameter name=\"allowedMethods\" value=\"*\"/>\n   <parameter name=\"scope\" value=\"Application\"/>\n   <namespace>%5$s</namespace>\n   %6$s</service>";
    @NonNls
    static final String DEFAULT_SERIALIZER = "org.apache.axis.encoding.ser.BeanSerializerFactory";
    @NonNls
    static final String DEFAULT_DESERIALIZER = "org.apache.axis.encoding.ser.BeanDeserializerFactory";

    @Override
    public String getName() {
        return AXIS_PLATFORM;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        return LibraryDescriptor.EMPTY_ARRAY;
    }

    @Override
    public String getBasePath() {
        return null;
    }

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return true;
    }

    @Override
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return null;
    }

    @Override
    public String getDeploymentServletName() {
        return "AxisServlet";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "org.apache.axis.transport.http.AxisServlet";
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])this.pathComponents, (InputStream)LibUtils.getResourcesStream("Axis.services.wsdd"), (boolean)true, (boolean)false, (WebFacet)webFacet);
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<? super File> onSuccessAction, Consumer<? super Exception> onException, Runnable editAgain) {
        LinkedList<Object> parameters2 = new LinkedList<Object>();
        PsiClass psiClass = options.getClassForOperation();
        String wsdlFileName = psiClass.getName() + ".wsdl";
        PsiFile file = psiClass.getContainingFile();
        File tempFile = new File(file.getContainingDirectory().getVirtualFile().getPath() + "/" + wsdlFileName);
        parameters2.add("-l" + options.getWebServiceURL());
        parameters2.add("-n" + options.getWebServiceNamespace());
        parameters2.add("-o" + tempFile.getPath());
        parameters2.add("-A" + options.getSoapAction());
        parameters2.add("-y" + options.getBindingStyle());
        parameters2.add("-u" + options.getUseOfItems());
        parameters2.add("-T" + options.getTypeMappingVersion());
        parameters2.add("-w" + options.getGenerationType());
        String methods = options.getMethods();
        if (methods.length() > 0) {
            parameters2.add("-m" + methods);
        }
        parameters2.add(psiClass.getQualifiedName());
        String[] args = ArrayUtilRt.toStringArray(parameters2);
        WsJavaExternalProcessHandler handler = new WsJavaExternalProcessHandler("Java 2 WSDL", "org.apache.axis.wsdl.Java2WSDL", LibUtils.getLibUrlsForToolRunning(this, options.getModule()), args, options.getModule(), false);
        handler.setOutputConsumer(new InvokeExternalCodeUtil.OutputConsumer(){

            public boolean handle(String output, String errOutput) throws InvokeExternalCodeUtil.ExternalCodeException {
                if (errOutput.contains("error")) {
                    throw new InvokeExternalCodeUtil.ExternalCodeException(errOutput);
                }
                return true;
            }
        });
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)handler, (Project)options.getModule().getProject(), (Runnable)options.getSuccessRunnable(onSuccessAction, tempFile), onException, options.isParametersStillValidPredicate(), (Runnable)editAgain);
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            AxisWSEngine.$$$reportNull$$$0(0);
        }
        if (onExceptionAction == null) {
            AxisWSEngine.$$$reportNull$$$0(1);
        }
        PsiClassType wsPsiType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(createOptions.getWsClass());
        PsiClass[] classes = DeploymentTimeCheckProcessor.searchReferencedTypesForClass((PsiType)wsPsiType);
        DeployUtils.addToConfigFile(this.pathComponents, true, module, AxisWSEngine.generateWSDD4Service(createOptions, module, classes), this);
        onSuccessAction.run();
    }

    public static String generateWSDD4Service(DeployWebServiceOptions createOptions, Module module, PsiClass[] references) {
        String namespace = createOptions.getWsNamespace();
        StringBuilder typesMapping = new StringBuilder();
        Set<PsiType> arrays = AxisWSEngine.findRefferencesToArrays(createOptions.getWsClass());
        for (PsiClass clazz : references) {
            if (createOptions.getWsClass().equals(clazz)) continue;
            typesMapping.append(String.format(TYPE_MAPPING, clazz.getName(), createOptions.getWsNamespace(), clazz.getQualifiedName(), DEFAULT_SERIALIZER, DEFAULT_DESERIALIZER, ENCODING_STYLE));
            PsiClassType type = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(clazz);
            if (!arrays.contains(type)) continue;
            typesMapping.append(String.format(ARRAY_MAPPING, namespace, "ArrayOf" + clazz.getName(), clazz.getQualifiedName() + "[]", clazz.getName(), namespace, ENCODING_STYLE));
        }
        return String.format(SERVICE_DEF, createOptions.getWsName(), StringUtil.toLowerCase((String)createOptions.getBindingStyle()), StringUtil.toLowerCase((String)createOptions.getUseOfItems()), createOptions.getWsClassName(), namespace, typesMapping);
    }

    static Set<PsiType> findRefferencesToArrays(PsiClass clazz) {
        ArrayListSet arraysTypes = new ArrayListSet();
        for (PsiMethod method : clazz.getMethods()) {
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiArrayType) {
                arraysTypes.add(((PsiArrayType)returnType).getComponentType());
            }
            for (PsiParameter param : method.getParameterList().getParameters()) {
                if (!(param.getType() instanceof PsiArrayType)) continue;
                arraysTypes.add(((PsiArrayType)param.getType()).getComponentType());
            }
        }
        return arraysTypes;
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<? super Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            AxisWSEngine.$$$reportNull$$$0(2);
        }
        if (onExceptionAction == null) {
            AxisWSEngine.$$$reportNull$$$0(3);
        }
        DeployUtils.removeFromConfigFile(this.pathComponents, true, module, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            if (SERVICE_TAG_NAME.equals(xmlTag.getLocalName())) {
                return webServiceName.equals(xmlTag.getAttributeValue("name"));
            }
            return false;
        }));
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        ArrayList wsnames = new ArrayList(1);
        DeployUtils.processTagsInConfigFile(this.pathComponents, true, module, (Processor<? super XmlTag>)((Processor)xmlTag -> {
            String name;
            if (SERVICE_TAG_NAME.equals(xmlTag.getLocalName()) && (name = xmlTag.getAttributeValue("name")) != null && !this.predefinedServices.contains(name)) {
                wsnames.add(name);
            }
            return true;
        }));
        return ArrayUtilRt.toStringArray(wsnames);
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        String user;
        @NonNls LinkedList<Object> commandLineParameters = new LinkedList<Object>();
        String packagePrefix = options.getPackagePrefix();
        if (packagePrefix != null) {
            commandLineParameters.add("-p".concat(packagePrefix));
        }
        if ((user = options.getUser()).length() > 0) {
            commandLineParameters.add("-U" + user);
            commandLineParameters.add("-P" + new String(options.getPassword()));
        }
        if (options.isToGenerateTestCase()) {
            commandLineParameters.add("-t");
        }
        if (options.generateClassesForArrays()) {
            commandLineParameters.add("-w");
        }
        String typeVersion = options.getTypeVersion();
        commandLineParameters.add("-T" + typeVersion);
        String output = options.getOutputPath();
        commandLineParameters.add("-o".concat(output));
        commandLineParameters.add(options.getWsdlUrl());
        if (options.isGenerateAllElements()) {
            commandLineParameters.add("-a");
        }
        if (!options.isSupportWrappedStyleOperation()) {
            commandLineParameters.add("-W");
        }
        if (options.isServersideSkeletonGeneration()) {
            commandLineParameters.add("-s");
        }
        return new InvokeExternalCodeUtil.JavaExternalProcessHandler("WSDL 2 Java", WSDL2JAVA, LibUtils.getLibUrlsForToolRunning(this, options.getSelectedModule()), ArrayUtilRt.toStringArray(commandLineParameters), null, false);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "itws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return null;
    }

    @Override
    public String getWebServicesTemplateName() {
        return "pojo.webservice.java";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onExceptionAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/engines/axis/AxisWSEngine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deployWebService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undeployWebService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

