/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.axis.AxisWSEngine;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.wsengine.DialogWithWebServicePlatform;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.WsModuleUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class WebServicePlatformUtils {
    public static void initWSPlatforms(final DialogWithWebServicePlatform dialog) {
        final WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        String[] strings = dialog.getAvailableEngineNames();
        final List<String> platforms = Arrays.asList(strings);
        dialog.configureComboBox(dialog.getWebServicePlatformCombo(), platforms);
        WebServicePlatformUtils.setupWebServiceEngineField(dialog, instance, platforms);
        dialog.doInitFor(dialog.getWebServicePlaformText(), dialog.getWebServicePlatformCombo(), 'l');
        dialog.getWebServicePlatformCombo().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                dialog.setupWSPlatformSpecificFields();
            }
        });
        JComboBox moduleChooser = dialog.getModuleChooser();
        if (moduleChooser != null) {
            moduleChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebServicePlatformUtils.setupWebServiceEngineField(dialog, instance, platforms);
                }
            });
        }
    }

    private static void setupWebServiceEngineField(DialogWithWebServicePlatform dialog, WebServicesPluginSettings instance, List<String> platforms) {
        int selectedPlatformIndex;
        String platformToUse;
        WSEngine engine;
        Module selectedModule = dialog.getSelectedModule();
        WSEngine wSEngine = engine = selectedModule != null ? WsModuleUtil.getEngineFromModule(selectedModule) : null;
        if (engine == null) {
            platformToUse = instance.getLastPlatform();
            dialog.getWebServicePlatformCombo().setVisible(true);
            dialog.getWebServicePlaformText().setVisible(true);
        } else {
            platformToUse = engine.getName();
            dialog.getWebServicePlatformCombo().setVisible(false);
            dialog.getWebServicePlaformText().setVisible(false);
        }
        int n = selectedPlatformIndex = platformToUse != null ? platforms.indexOf(platformToUse) : -1;
        if (selectedPlatformIndex == -1) {
            selectedPlatformIndex = 0;
        }
        dialog.getWebServicePlatformCombo().setSelectedIndex(selectedPlatformIndex);
    }

    public static boolean isJdk1_6SetUpForModule(Module module) {
        Sdk projectJdk = InvokeExternalCodeUtil.JavaExternalProcessHandler.evaluateJdkForModule((Module)module);
        return projectJdk != null && JavaSdk.getInstance().isOfVersionOrHigher(projectJdk, JavaSdkVersion.JDK_1_6);
    }

    public static ValidationInfo checkIfPlatformIsSetUpCorrectly(DialogWithWebServicePlatform dialog, WSEngine engine) {
        String message = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(engine, dialog.getSelectedModule());
        if (message != null) {
            return new ValidationInfo(message, null);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nls
    public static String checkIfPlatformIsSetUpCorrectly(WSEngine engine, @Nullable Module module) {
        if (engine.isConfigured()) return null;
        String message = WSBundle.message("webservices.set.valid.path", engine.getName());
        if (engine instanceof JWSDPWSEngine) {
            if (module == null) return null;
            if (WebServicePlatformUtils.isJdk1_6SetUpForModule(module)) return null;
            if (WebServicePlatformUtils.isOldWsGenAccessibleForModule(module)) return null;
            return (String)message + " " + WSBundle.message("webservices.use.jdk.6", new Object[0]);
        }
        if (!(engine instanceof AxisWSEngine)) return message;
        return null;
    }

    public static boolean isOldWsGenAccessibleForModule(Module module) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("com.sun.tools.ws.WsGen", GlobalSearchScope.moduleWithLibrariesScope((Module)module)) != null;
    }
}

