/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestCase;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestSourceReadEvent;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmWriteEvent;

public class CucumberJvmSMConverter {
    private static final String EXAMPLES_CAPTION = "Examples:";
    private static final String SCENARIO_OUTLINE_CAPTION = "Scenario: Line: ";
    private final Map<String, String> pathToDescription = new HashMap<String, String>();
    private String currentFilePath;
    private int currentScenarioOutlineLine;
    private String currentScenarioOutlineName;
    private final PrintStream myOut;
    private final String myCurrentTimeValue;

    public CucumberJvmSMConverter() {
        this(System.out, null);
    }

    public CucumberJvmSMConverter(PrintStream out, String currentTimeValue) {
        this.myOut = out;
        this.myCurrentTimeValue = currentTimeValue;
        this.outCommand("##teamcity[enteredTheMatrix timestamp = '%s']", this.getCurrentTime());
        this.outCommand("##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '%s' timestamp = '%s']", "0", this.getCurrentTime());
    }

    public void handleTestCaseStarted(CucumberJvmTestCase testCase) {
        String uri = testCase.getUri();
        if (this.currentFilePath == null) {
            this.outCommand("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), uri, this.getFeatureFileDescription(uri));
        } else if (!uri.equals(this.currentFilePath)) {
            this.closeCurrentScenarioOutline();
            this.outCommand("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), this.getFeatureFileDescription(this.currentFilePath));
            this.outCommand("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), uri, this.getFeatureFileDescription(uri));
        }
        this.outCommand("##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']", this.getCurrentTime());
        if (testCase.isScenarioOutline()) {
            int mainScenarioLine = testCase.getScenarioOutlineLine();
            if (this.currentScenarioOutlineLine != mainScenarioLine || this.currentFilePath == null || !this.currentFilePath.equals(uri)) {
                this.closeCurrentScenarioOutline();
                this.currentScenarioOutlineLine = mainScenarioLine;
                this.currentScenarioOutlineName = "Scenario Outline: " + testCase.getScenarioName();
                this.outCommand("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), uri + ":" + this.currentScenarioOutlineLine, this.currentScenarioOutlineName);
                this.outCommand("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), "", EXAMPLES_CAPTION);
            }
        } else {
            this.closeCurrentScenarioOutline();
        }
        this.currentFilePath = uri;
        this.outCommand("##teamcity[testSuiteStarted timestamp = '%s' locationHint = 'file://%s' name = '%s']", this.getCurrentTime(), uri + ":" + testCase.getLine(), CucumberJvmSMConverter.getScenarioName(testCase));
    }

    public void handleTestCaseFinished(CucumberJvmTestCase testCase) {
        this.outCommand("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), CucumberJvmSMConverter.getScenarioName(testCase));
        this.outCommand("##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']", this.getCurrentTime());
    }

    public void handleTestRunFinished() {
        this.closeCurrentScenarioOutline();
        this.outCommand("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), this.getFeatureFileDescription(this.currentFilePath));
    }

    public void handleWriteEvent(CucumberJvmWriteEvent event) {
        this.myOut.println(event.getText());
    }

    public void handleTestStepStarted(CucumberJvmTestStep testStep) {
        this.outCommand("##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']", this.getCurrentTime(), testStep.getLocation(), testStep.getStepName());
    }

    public void handleTestStepFinished(CucumberJvmTestStepFinishedEvent event) {
        if (event.getResult() != CucumberJvmTestStepFinishedEvent.Status.PASSED) {
            if (event.getResult() == CucumberJvmTestStepFinishedEvent.Status.SKIPPED || event.getResult() == CucumberJvmTestStepFinishedEvent.Status.PENDING) {
                this.outCommand("##teamcity[testIgnored name = '%s' message = 'Skipped step' timestamp = '%s']", event.getTestStep().getStepName(), this.getCurrentTime());
            } else {
                String[] messageAndDetails = CucumberJvmSMConverter.getMessageAndDetails(event.getErrorMessage());
                ComparisonFailureData comparisonFailureData = ExpectedPatterns.createExceptionNotification((String)messageAndDetails[0]);
                if (comparisonFailureData != null) {
                    this.outCommand("##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' expected='%s' actual='%s' name = '%s' %s]", this.getCurrentTime(), messageAndDetails[1], messageAndDetails[0], comparisonFailureData.getExpected(), comparisonFailureData.getActual(), event.getTestStep().getStepName(), "");
                } else {
                    this.outCommand("##teamcity[testFailed timestamp = '%s' details = '%s' message = '%s' name = '%s' %s]", this.getCurrentTime(), "", event.getErrorMessage(), event.getTestStep().getStepName(), "");
                }
            }
        }
        this.outCommand("##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']", this.getCurrentTime(), String.valueOf(event.getDuration()), event.getTestStep().getStepName());
    }

    public void handleTestSourceRead(CucumberJvmTestSourceReadEvent event) {
        this.closeCurrentScenarioOutline();
        this.pathToDescription.put(event.getUri(), CucumberJvmSMFormatterUtil.getFeatureName(event.getSource()));
    }

    private String getFeatureFileDescription(String uri) {
        if (this.pathToDescription.containsKey(uri)) {
            return this.pathToDescription.get(uri);
        }
        return uri;
    }

    private void closeCurrentScenarioOutline() {
        if (this.currentScenarioOutlineLine > 0) {
            this.outCommand("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), EXAMPLES_CAPTION);
            this.outCommand("##teamcity[testSuiteFinished timestamp = '%s' name = '%s']", this.getCurrentTime(), this.currentScenarioOutlineName);
            this.currentScenarioOutlineLine = 0;
            this.currentScenarioOutlineName = null;
        }
    }

    private static String[] getMessageAndDetails(String errorReport) {
        if (errorReport == null) {
            errorReport = "";
        }
        String[] messageAndDetails = errorReport.split("\n", 2);
        String message = null;
        if (messageAndDetails.length > 0) {
            message = messageAndDetails[0];
        }
        if (message == null) {
            message = "";
        }
        String details = null;
        if (messageAndDetails.length > 1) {
            details = messageAndDetails[1];
        }
        if (details == null) {
            details = "";
        }
        return new String[]{message, details};
    }

    private void outCommand(String command, String ... parameters) {
        this.myOut.println(CucumberJvmSMFormatterUtil.escapeCommand(command, parameters));
    }

    private static String getScenarioName(CucumberJvmTestCase testCase) {
        if (testCase.isScenarioOutline()) {
            return SCENARIO_OUTLINE_CAPTION + testCase.getLine();
        }
        return "Scenario: " + testCase.getScenarioName();
    }

    private String getCurrentTime() {
        if (this.myCurrentTimeValue != null) {
            return this.myCurrentTimeValue;
        }
        return CucumberJvmSMFormatterUtil.getCurrentTime();
    }
}

