/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.TestStepFinished;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatterUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent;

public class CucumberJvm2Adapter {
    private static PickleEvent getPickleEvent(TestCase testCase) {
        try {
            Field pickleEventField = testCase.getClass().getDeclaredField("pickleEvent");
            pickleEventField.setAccessible(true);
            return (PickleEvent)pickleEventField.get(testCase);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class CucumberJvmTestStep
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep {
        private final TestStep myRealStep;

        public CucumberJvmTestStep(TestStep realStep) {
            this.myRealStep = realStep;
        }

        @Override
        public String getLocation() {
            if (this.myRealStep.isHook()) {
                try {
                    Field definitionMatchField = this.myRealStep.getClass().getSuperclass().getDeclaredField("definitionMatch");
                    definitionMatchField.setAccessible(true);
                    Object definitionMatchFieldValue = definitionMatchField.get(this.myRealStep);
                    Field hookDefinitionField = definitionMatchFieldValue.getClass().getDeclaredField("hookDefinition");
                    hookDefinitionField.setAccessible(true);
                    Object hookDefinitionFieldValue = hookDefinitionField.get(definitionMatchFieldValue);
                    Field methodField = hookDefinitionFieldValue.getClass().getDeclaredField("method");
                    methodField.setAccessible(true);
                    Object methodFieldValue = methodField.get(hookDefinitionFieldValue);
                    if (methodFieldValue instanceof Method) {
                        Method method = (Method)methodFieldValue;
                        return String.format("java:test://%s/%s", method.getDeclaringClass().getName(), method.getName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "";
            }
            return "file://" + this.myRealStep.getStepLocation() + ":" + this.myRealStep.getStepLine();
        }

        @Override
        public String getStepName() {
            String stepName = this.myRealStep.isHook() ? "Hook: " + this.myRealStep.getHookType().toString() : this.getStepKeyword() + " " + this.myRealStep.getStepText();
            return stepName;
        }

        private String getStepKeyword() {
            try {
                String filePath = this.myRealStep.getStepLocation().substring(0, this.myRealStep.getStepLocation().indexOf(58));
                String line = CucumberJvmSMFormatterUtil.getStepKeyword(filePath, this.myRealStep.getStepLine());
                if (line != null) {
                    return line;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return "Given";
        }
    }

    public static class CucumberJvmTestCase
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestCase {
        private final TestCase myRealTestCase;

        CucumberJvmTestCase(TestCase realTestCase) {
            this.myRealTestCase = realTestCase;
        }

        @Override
        public boolean isScenarioOutline() {
            PickleEvent pickleEvent = CucumberJvm2Adapter.getPickleEvent(this.myRealTestCase);
            return pickleEvent != null && pickleEvent.pickle.getLocations().size() > 1;
        }

        @Override
        public String getUri() {
            return this.myRealTestCase.getUri();
        }

        @Override
        public int getScenarioOutlineLine() {
            PickleEvent pickleEvent = CucumberJvm2Adapter.getPickleEvent(this.myRealTestCase);
            if (pickleEvent != null) {
                return ((PickleLocation)pickleEvent.pickle.getLocations().get(pickleEvent.pickle.getLocations().size() - 1)).getLine();
            }
            return 0;
        }

        @Override
        public int getLine() {
            return this.myRealTestCase.getLine();
        }

        @Override
        public String getScenarioName() {
            return this.myRealTestCase.getName();
        }
    }

    public static class CucumberJvmTestStepFinishedEvent
    implements org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStepFinishedEvent {
        private final CucumberJvmTestStep myTestStep;
        private final TestStepFinished myRealEvent;

        public CucumberJvmTestStepFinishedEvent(TestStepFinished testStepFinished) {
            this.myTestStep = new CucumberJvmTestStep(testStepFinished.testStep);
            this.myRealEvent = testStepFinished;
        }

        @Override
        public org.jetbrains.plugins.cucumber.java.run.CucumberJvmTestStep getTestStep() {
            return this.myTestStep;
        }

        @Override
        public CucumberJvmTestStepFinishedEvent.Status getResult() {
            switch (this.myRealEvent.result.getStatus()) {
                case PASSED: {
                    return CucumberJvmTestStepFinishedEvent.Status.PASSED;
                }
                case PENDING: {
                    return CucumberJvmTestStepFinishedEvent.Status.PENDING;
                }
                case SKIPPED: {
                    return CucumberJvmTestStepFinishedEvent.Status.SKIPPED;
                }
            }
            return CucumberJvmTestStepFinishedEvent.Status.FAILED;
        }

        @Override
        public Long getDuration() {
            return this.myRealEvent.result.getDuration() != null ? this.myRealEvent.result.getDuration() / 1000000L : 0L;
        }

        @Override
        public String getErrorMessage() {
            return this.myRealEvent.result.getErrorMessage();
        }
    }
}

