/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.spring.model.xml.custom.CustomBeanParserUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class CustomBeanParser {
    public static final String MAGIC = "\n\n##$%^$&%@^#%$#%^&$^&%*&^(*(^&*(&^*&%*&%&*^\n";

    private CustomBeanParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.FINE);
        Logger.getLogger("").addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                Throwable throwable = record.getThrown();
                if (throwable != null) {
                    CustomBeanParser.printException(throwable);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            int timeout = Integer.parseInt(input.readLine());
            while ("input".equals(input.readLine())) {
                String tagText = CustomBeanParser.decode(input.readLine());
                try {
                    CustomBeanParserUtil.parseCustomBean(tagText, timeout);
                }
                finally {
                    System.out.flush();
                }
            }
        }
        catch (Throwable e) {
            CustomBeanParser.printException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException timeout) {}
            System.exit(0);
        }
    }

    static void printException(Throwable e) {
        System.out.print("exception\n");
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        System.out.print(CustomBeanParser.encode(writer.toString()) + MAGIC);
        System.out.flush();
    }

    public static String decode(String s1) {
        StringBuilder buffer = new StringBuilder();
        int length = s1.length();
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s1.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.valueOf(s1.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static String encode(String s1) {
        StringBuilder buffer = new StringBuilder();
        block9: for (int idx = 0; idx < s1.length(); ++idx) {
            char ch = s1.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block9;
                    }
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }
}

