/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsWeaver;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.model.module.JpsModule;

public class AjWeavingBuilder
extends AjBuilderBase {
    private static final String AJ_WEAVER_CLASS = "org.aspectj.weaver.tools.WeavingAdaptor";

    public AjWeavingBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER, AJ_WEAVER_CLASS);
    }

    @Override
    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull AjCompilerSettings settings) throws IOException, AjBuilderBase.AjBuildException {
        if (context == null) {
            AjWeavingBuilder.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            AjWeavingBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AjWeavingBuilder.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AjWeavingBuilder.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AjWeavingBuilder.$$$reportNull$$$0(4);
        }
        if (!settings.delegateToJavac) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        if (consumer.getCompiledClasses().isEmpty()) {
            LOG.debug("no files");
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        ModuleLevelBuilder.ExitCode result = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            JpsModule module = target.getModule();
            AjModuleSettings moduleSettings = AjJpsModuleSettings.getSettings(module);
            if (moduleSettings == null || !moduleSettings.weaveOnly) continue;
            ModuleLevelBuilder.ExitCode targetResult = new AjJpsWeaver(context, chunk, consumer, target, settings).build();
            if (targetResult.compareTo((Enum)result) > 0) {
                result = targetResult;
            }
            if (result != ModuleLevelBuilder.ExitCode.ABORT) continue;
            break;
        }
        return result;
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            AjWeavingBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/AjWeavingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/AjWeavingBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

