/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjAspectPathIndex;
import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.AjJpsCompiler;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModule;

public final class AjTranslatingBuilder
extends AjBuilderBase {
    public static final String AJC_MAIN_CLASS = "org.aspectj.tools.ajc.Main";
    private static final List<String> COMPILABLE_FILE_EXTENSIONS = Arrays.asList("java", "aj");
    private static final Set<String> SOURCE_EXTENSIONS = CollectionFactory.createFilePathSet(COMPILABLE_FILE_EXTENSIONS);
    private AjAspectPathIndex myIndex;

    public AjTranslatingBuilder() {
        super(BuilderCategory.TRANSLATOR, AJC_MAIN_CLASS);
    }

    public void buildStarted(CompileContext context) {
        try {
            File root = context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot();
            this.myIndex = (AjAspectPathIndex)AjAspectPathIndex.PROVIDER.createStorage(root);
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                this.myIndex.clean();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void buildFinished(CompileContext context) {
        try {
            this.myIndex.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull AjCompilerSettings settings) throws ProjectBuildException, IOException, AjBuilderBase.AjBuildException {
        if (context == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(4);
        }
        LOG.debug("chunk: " + chunk);
        List<File> toCompile = AjTranslatingBuilder.collectFiles(holder);
        if (toCompile.isEmpty() && !holder.hasRemovedFiles()) {
            LOG.debug("no files");
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Set modules = chunk.getModules();
        if (settings.delegateToJavac && AjTranslatingBuilder.canDelegate(modules)) {
            List builders = BuilderRegistry.getInstance().getBuilders(BuilderCategory.TRANSLATOR);
            for (ModuleLevelBuilder builder : builders) {
                if (!(builder instanceof JavaBuilder)) continue;
                LOG.info("delegating to Java builder");
                JpsProject project = context.getProjectDescriptor().getProject();
                JpsJavaCompilerConfiguration cfg = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
                cfg.setCompilerOptions("ajc", cfg.getCompilerOptions("Javac"));
                return ((JavaBuilder)builder).doBuild(context, chunk, holder, consumer, (JavaCompilingTool)new JavacCompilerTool());
            }
            LOG.error("no Java builder among " + builders);
            context.processMessage(AjTranslatingBuilder.error(AjJpsBundle.message("aj.internal.error.java.builder.missing", new Object[0])));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (modules.size() > 1) {
            String names = ContainerUtil.map2List((Collection)modules, module -> module.getName()).toString();
            context.processMessage(AjTranslatingBuilder.error(AjJpsBundle.message("aj.too.many.modules", names)));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        ModuleLevelBuilder.ExitCode result = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("starting ajc for target: " + target);
            }
            ModuleLevelBuilder.ExitCode targetResult = new AjJpsCompiler(context, this.myIndex, chunk, toCompile, target, settings, consumer).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("finished ajc for target: " + target + ", result: " + targetResult);
            }
            if (targetResult.compareTo((Enum)result) > 0) {
                result = targetResult;
            }
            if (result != ModuleLevelBuilder.ExitCode.ABORT && result != ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) continue;
            break;
        }
        if (result == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
            FSOperations.markDirtyRecursively((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)chunk);
        }
        return result;
    }

    private static List<File> collectFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder) throws IOException {
        SmartList files = new SmartList();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>((List)files){
            final /* synthetic */ List val$files;
            {
                this.val$files = list;
            }

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor sourceRoot) {
                if (AjTranslatingBuilder.isSourceFile(file)) {
                    this.val$files.add(file);
                }
                return true;
            }
        });
        return files;
    }

    public static boolean isSourceFile(File file) {
        return SOURCE_EXTENSIONS.contains(FileUtilRt.getExtension((String)file.getName()));
    }

    private static boolean canDelegate(Set<JpsModule> modules) {
        for (JpsModule module : modules) {
            AjModuleSettings settings = AjJpsModuleSettings.getSettings(module);
            if (settings == null || settings.weaveOnly) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = COMPILABLE_FILE_EXTENSIONS;
        if (list == null) {
            AjTranslatingBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/AjTranslatingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/AjTranslatingBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

