/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjCompilerMessageHandler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.loadtime.WeavingURLClassLoader;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.aspectj.weaver.tools.WeavingClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class AjJpsWeaver {
    private static final Logger LOG = Logger.getInstance(AjJpsWeaver.class);
    private final CompileContext myContext;
    private final ModuleChunk myChunk;
    private final ModuleLevelBuilder.OutputConsumer myConsumer;
    private final ModuleBuildTarget myTarget;
    private final AjCompilerSettings myCompilerSettings;
    private final AjModuleSettings myModuleSettings;

    public AjJpsWeaver(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull ModuleBuildTarget target, @NotNull AjCompilerSettings settings) {
        if (context == null) {
            AjJpsWeaver.$$$reportNull$$$0(0);
        }
        if (chunk == null) {
            AjJpsWeaver.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            AjJpsWeaver.$$$reportNull$$$0(2);
        }
        if (target == null) {
            AjJpsWeaver.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            AjJpsWeaver.$$$reportNull$$$0(4);
        }
        this.myContext = context;
        this.myChunk = chunk;
        this.myConsumer = consumer;
        this.myTarget = target;
        this.myCompilerSettings = settings;
        this.myModuleSettings = AjJpsModuleSettings.getSettings(target.getModule());
    }

    public ModuleLevelBuilder.ExitCode build() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting the weaver for the target: " + this.myTarget);
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(AjJpsBundle.message("aj.progress.weaving", new Object[0])));
        AjCompilerMessageHandler mh = new AjCompilerMessageHandler(this.myContext, this.myCompilerSettings.cmdLineParams.contains("-showWeaveInfo"));
        String targetDir = AjBuilderBase.getTargetDir(this.myTarget);
        ArrayList<String> classPath = new ArrayList<String>();
        for (File file : ProjectPaths.getPlatformCompilationClasspath((ModuleChunk)this.myChunk, (boolean)false)) {
            classPath.add(file.getPath());
        }
        for (File file : ProjectPaths.getCompilationClasspath((ModuleChunk)this.myChunk, (boolean)false)) {
            classPath.add(file.getPath());
        }
        List<String> aspectPath = AjBuilderBase.getAspectPath(this.myTarget, this.myModuleSettings);
        aspectPath.add(targetDir);
        MyWeavingAdaptor weaver = new MyWeavingAdaptor(classPath, aspectPath, targetDir, mh);
        weaver.weaveClasses(this.myConsumer, this.myTarget);
        return mh.hasErrors() ? ModuleLevelBuilder.ExitCode.ABORT : ModuleLevelBuilder.ExitCode.OK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "chunk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/aspectj/build/AjJpsWeaver";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyWeavingAdaptor
    extends WeavingAdaptor {
        private final String myTargetDir;
        private final Collection<CompiledClass> myGeneratedClasses;

        MyWeavingAdaptor(List<String> classPath, List<String> aspectPath, String targetDir, AjCompilerMessageHandler mh) {
            super((WeavingClassLoader)new WeavingURLClassLoader(MyWeavingAdaptor.toUrls(classPath), MyWeavingAdaptor.toUrls(aspectPath), ClassLoader.getSystemClassLoader()));
            this.myTargetDir = targetDir;
            this.myGeneratedClasses = new ArrayList<CompiledClass>();
            this.setMessageHandler((IMessageHandler)mh);
        }

        private static URL[] toUrls(List<String> paths) {
            try {
                URL[] urls = new URL[paths.size()];
                String prefix = SystemInfo.isWindows ? "file:///" : "file://";
                for (int i = 0; i < paths.size(); ++i) {
                    urls[i] = new URL(prefix + paths.get(i));
                }
                return urls;
            }
            catch (MalformedURLException e) {
                throw new AjBuilderBase.AjBuildException(e.getMessage());
            }
        }

        public void weaveClasses(ModuleLevelBuilder.OutputConsumer consumer, ModuleBuildTarget target) throws IOException {
            Map compiledClasses = consumer.getCompiledClasses();
            for (CompiledClass compiledClass : compiledClasses.values()) {
                this.weaveClass(compiledClass, compiledClasses);
            }
            for (CompiledClass generatedClass : this.myGeneratedClasses) {
                generatedClass.save();
                consumer.registerCompiledClass((BuildTarget)target, generatedClass);
            }
        }

        private void weaveClass(CompiledClass compiledClass, Map<String, CompiledClass> compiledClasses) throws IOException {
            HashSet prevClasses = new HashSet(this.generatedClasses.keySet());
            LOG.debug("weaving " + compiledClass.getOutputFile());
            byte[] original = compiledClass.getContent().getBuffer();
            byte[] woven = this.weaveClass(compiledClass.getClassName(), original);
            if (woven != original) {
                LOG.debug("... content changed");
                compiledClass.setContent(new BinaryContent(woven));
            }
            for (Map.Entry entry : this.generatedClasses.entrySet()) {
                String generatedClassName = (String)entry.getKey();
                if (prevClasses.contains(generatedClassName) || compiledClasses.containsKey(generatedClassName)) continue;
                File file = new File(this.myTargetDir, ((String)entry.getKey()).replace('.', File.separatorChar) + ".class");
                BinaryContent content = new BinaryContent(((IUnwovenClassFile)entry.getValue()).getBytes());
                CompiledClass generatedClass = new CompiledClass(file, compiledClass.getSourceFiles(), generatedClassName, content);
                this.myGeneratedClasses.add(generatedClass);
            }
        }
    }
}

