/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageHandler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public class AjCompilerMessageHandler
extends MessageHandler {
    private final CompileContext myContext;
    private boolean myHasErrors;

    public AjCompilerMessageHandler(@NotNull CompileContext context, boolean weaveInfo) {
        if (context == null) {
            AjCompilerMessageHandler.$$$reportNull$$$0(0);
        }
        this.myHasErrors = false;
        this.myContext = context;
        if (weaveInfo) {
            this.dontIgnore(IMessage.WEAVEINFO);
        }
    }

    public boolean hasErrors() {
        return this.myHasErrors;
    }

    public boolean handleMessage(IMessage iMessage) {
        IMessage.Kind kind = iMessage.getKind();
        @NlsSafe String text = iMessage.getMessage();
        ISourceLocation source = iMessage.getSourceLocation();
        if (AjBuilderBase.LOG.isDebugEnabled()) {
            AjBuilderBase.LOG.debug(kind + ": '" + text + "' @" + source);
        }
        if (IMessage.Kind.COMPARATOR.compare(kind, IMessage.ERROR) >= 0) {
            this.myHasErrors = true;
        }
        WeaveMessage message = null;
        if (kind == IMessage.WEAVEINFO) {
            message = new WeaveMessage(text);
        } else if (kind == IMessage.WARNING || kind == IMessage.ERROR) {
            BuildMessage.Kind jpsKind;
            BuildMessage.Kind kind2 = jpsKind = kind == IMessage.ERROR ? BuildMessage.Kind.ERROR : BuildMessage.Kind.WARNING;
            if (source != null && source != ISourceLocation.EMPTY) {
                int line = source.getLine();
                int column = source.getColumn();
                message = new CompilerMessage("ajc", jpsKind, text, source.getSourceFile().getPath(), -1L, -1L, -1L, (long)line, (long)column);
            } else {
                message = new CompilerMessage("ajc", jpsKind, text);
            }
        } else if (kind == IMessage.FAIL || kind == IMessage.ABORT) {
            Logger.getInstance(AjCompilerMessageHandler.class).error("[" + kind + "] " + text, iMessage.getThrown());
            message = new CompilerMessage("ajc", BuildMessage.Kind.ERROR, AjJpsBundle.message("aj.internal", text));
        }
        if (message != null) {
            this.myContext.processMessage((BuildMessage)message);
        }
        return super.handleMessage(iMessage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjCompilerMessageHandler", "<init>"));
    }

    public static class WeaveMessage
    extends CompilerMessage {
        public WeaveMessage(@Nls String messageText) {
            super("ajc", BuildMessage.Kind.INFO, messageText);
        }
    }
}

