/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class AjBuilderBase
extends ModuleLevelBuilder {
    @NlsSafe
    public static final String ID = "ajc";
    public static final Logger LOG = Logger.getInstance(AjBuilderBase.class);
    private final String myClassToCheck;

    public AjBuilderBase(@NotNull BuilderCategory category, @NotNull String classToCheck) {
        if (category == null) {
            AjBuilderBase.$$$reportNull$$$0(0);
        }
        if (classToCheck == null) {
            AjBuilderBase.$$$reportNull$$$0(1);
        }
        super(category);
        this.myClassToCheck = classToCheck;
    }

    @NotNull
    public String getPresentableName() {
        return ID;
    }

    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer) throws ProjectBuildException, IOException {
        if (context == null) {
            AjBuilderBase.$$$reportNull$$$0(2);
        }
        if (chunk == null) {
            AjBuilderBase.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            AjBuilderBase.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            AjBuilderBase.$$$reportNull$$$0(5);
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        String compilerId = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getJavaCompilerId();
        if (!ID.equals(compilerId)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        AjCompilerSettings settings = AjJpsCompilerSettings.getSettings(project);
        if (settings == null) {
            String message = AjJpsBundle.message("aj.compiler.settings.component.not.initialized.for.0", project);
            LOG.error(message);
            context.processMessage(AjBuilderBase.error(message));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        try {
            Class.forName(this.myClassToCheck);
        }
        catch (ClassNotFoundException e) {
            context.processMessage(AjBuilderBase.error(AjJpsBundle.message("aj.compiler.path.incorrect", settings.ajcPath)));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        try {
            return this.doBuild(context, chunk, holder, consumer, settings);
        }
        catch (AjBuildException e) {
            context.processMessage(AjBuilderBase.error(e.getMessage()));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    public abstract ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext var1, @NotNull ModuleChunk var2, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> var3, @NotNull ModuleLevelBuilder.OutputConsumer var4, @NotNull AjCompilerSettings var5) throws ProjectBuildException, IOException, AjBuildException;

    @NotNull
    public static List<String> getAspectPath(@NotNull ModuleBuildTarget target, @Nullable AjModuleSettings moduleSettings) {
        if (target == null) {
            AjBuilderBase.$$$reportNull$$$0(6);
        }
        SmartList paths = new SmartList();
        if (moduleSettings != null) {
            if (target.isTests()) {
                ContainerUtil.addIfNotNull((Collection)paths, (Object)AjBuilderBase.getModuleOutputPath(target.getModule()));
            }
            AjBuilderBase.addPaths((List<String>)paths, moduleSettings.aspectPath);
        }
        SmartList smartList = paths;
        if (smartList == null) {
            AjBuilderBase.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static void addPaths(List<String> paths, List<AjPathEntries.Entry<?, ?>> entries) {
        for (AjPathEntries.Entry<?, ?> entry : entries) {
            JpsModule module;
            if (entry instanceof AjPathEntries.LibraryEntry) {
                JpsLibrary library = (JpsLibrary)((AjPathEntries.LibraryEntry)entry).resolve();
                if (library == null || !(library.getType() instanceof JpsJavaLibraryType)) continue;
                for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    paths.add(JpsPathUtil.urlToOsPath((String)root.getUrl()));
                }
                continue;
            }
            if (!(entry instanceof AjPathEntries.ModuleEntry) || (module = (JpsModule)((AjPathEntries.ModuleEntry)entry).resolve()) == null || !(module.getModuleType() instanceof JpsJavaModuleType)) continue;
            ContainerUtil.addIfNotNull(paths, (Object)AjBuilderBase.getModuleOutputPath(module));
        }
    }

    private static String getModuleOutputPath(JpsModule module) {
        String outputUrl = JpsJavaExtensionService.getInstance().getOutputUrl(module, false);
        return outputUrl != null ? JpsPathUtil.urlToOsPath((String)outputUrl) : null;
    }

    @NotNull
    public static String getTargetDir(@NotNull ModuleBuildTarget target) {
        File outputDir;
        if (target == null) {
            AjBuilderBase.$$$reportNull$$$0(8);
        }
        if ((outputDir = target.getOutputDir()) == null) {
            throw new AjBuildException("missing output dir for target '" + target + "'");
        }
        if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new AjBuildException("unable to create output directory '" + outputDir + "'");
        }
        String string = outputDir.getPath();
        if (string == null) {
            AjBuilderBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static BuildMessage error(@Nls String text) {
        return new CompilerMessage(ID, BuildMessage.Kind.ERROR, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/build/AjBuilderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/build/AjBuilderBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspectPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAspectPath";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AjBuildException
    extends RuntimeException {
        public AjBuildException(@NotNull String message) {
            if (message == null) {
                AjBuildException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/aspectj/build/AjBuilderBase$AjBuildException", "<init>"));
        }
    }
}

