/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramUtils {
    private DiagramUtils() {
    }

    public static boolean setBestPopupSizeForGraph(JBPopup popup, DiagramBuilder builder) {
        return GraphUtil.setBestPopupSizeForGraph((JBPopup)popup, (GraphBuilder)((GraphBuilder)builder));
    }

    public static Point getBestPositionForNode(DiagramBuilder builder) {
        return Utils.getBestPositionForNode((GraphBuilder)builder);
    }

    public static Dimension calcGraphSize(DiagramBuilder builder) {
        return GraphUtil.calcGraphSize((GraphBuilder)((GraphBuilder)builder));
    }

    public static <NODE_TYPE> List<NODE_TYPE> getSelectedNodes(GraphBuilder<NODE_TYPE, ?> builder) {
        return GraphUtil.getSelectedNodes(builder);
    }

    public static ArrayList<DiagramNode> getSelectedNodes(DiagramBuilder builder) {
        return (ArrayList)GraphUtil.getSelectedNodes((GraphBuilder)((GraphBuilder)builder));
    }

    public static boolean isNodeWithoutBody(DiagramBuilder builder, Node node) {
        NodeRealizer realizer = builder.getGraph().getRealizer(node);
        if (realizer == null) {
            return false;
        }
        return realizer.getHeight() < 30.0;
    }

    public static List<DiagramEdge> getSelectedEdges(DiagramBuilder builder) {
        ArrayList<DiagramEdge> selectedEdges = new ArrayList<DiagramEdge>();
        EdgeCursor ec = builder.getGraph().selectedEdges();
        while (ec.ok()) {
            Edge edge = ec.edge();
            DiagramEdge edgeObject = builder.getEdgeObject(edge);
            if (edgeObject != null) {
                selectedEdges.add(edgeObject);
            }
            ec.next();
        }
        return selectedEdges;
    }

    public static void navigateTo(DiagramNode node) {
        DiagramBuilder builder = (DiagramBuilder)node.getUserData(Utils.GRAPH_BUILDER);
        if (builder != null) {
            GraphViewUtil.navigateTo((Object)node, (GraphBuilder)((GraphBuilder)builder));
        }
    }

    public static <T> boolean isSelectionMode(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramUtils.$$$reportNull$$$0(0);
        }
        return builder.getPresentation().isCategoryEnabled(CommonDiagramExtras.SELECTION_MODE);
    }

    public static <T> Set<DiagramEdge<T>> getPathsFromRoot(final @NotNull DiagramNode<T> root, final @NotNull Collection<DiagramNode> toNodes, @NotNull DiagramDataView<T> dataModel) {
        if (root == null) {
            DiagramUtils.$$$reportNull$$$0(1);
        }
        if (toNodes == null) {
            DiagramUtils.$$$reportNull$$$0(2);
        }
        if (dataModel == null) {
            DiagramUtils.$$$reportNull$$$0(3);
        }
        final Graph<DiagramNode<T>> graph = DiagramUtils.dataModelToGraph(dataModel);
        final GraphAlgorithms graphAlgorithms = GraphAlgorithms.getInstance();
        List pathesToRoot = new LinkedList();
        try {
            pathesToRoot = (List)ProgressManager.getInstance().run(new Task.WithResult<List<List<DiagramNode<T>>>, Exception>(dataModel.getProject(), DiagramBundle.message("task.title.calculating.paths", new Object[0]), true){

                protected List<List<DiagramNode<T>>> compute(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LinkedList paths = new LinkedList();
                    for (DiagramNode node : toNodes) {
                        DiagramNode to = node;
                        if (root.equals(to)) continue;
                        List shortestPaths = graphAlgorithms.findKShortestPaths(graph, (Object)root, (Object)to, 100, indicator);
                        paths.addAll(graphAlgorithms.removePathsWithCycles(shortestPaths));
                    }
                    return paths;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagram/util/DiagramUtils$1", "compute"));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<DiagramEdge<T>> pathEdges = new HashSet<DiagramEdge<T>>();
        for (List path : pathesToRoot) {
            for (int i = 0; i < path.size(); ++i) {
                DiagramNode node = (DiagramNode)path.get(i);
                if (i == path.size() - 1) continue;
                Collection<DiagramEdge<T>> edges = dataModel.getEdges();
                ContainerUtil.addIfNotNull(pathEdges, DiagramUtils.findEdge(node, (DiagramNode)path.get(i + 1), edges));
            }
        }
        return pathEdges;
    }

    private static <T> DiagramEdge<T> findEdge(DiagramNode<T> from, DiagramNode<T> to, @NotNull Collection<? extends DiagramEdge<T>> allEdges) {
        if (allEdges == null) {
            DiagramUtils.$$$reportNull$$$0(4);
        }
        for (DiagramEdge<T> edge : allEdges) {
            if (!from.equals(edge.getSource()) || !to.equals(edge.getTarget())) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    public static <T> Set<DiagramNode<T>> collectNodes(@NotNull Set<DiagramEdge<T>> pathEdges) {
        if (pathEdges == null) {
            DiagramUtils.$$$reportNull$$$0(5);
        }
        HashSet<DiagramNode<T>> pathNodes = new HashSet<DiagramNode<T>>();
        for (DiagramEdge<T> edge : pathEdges) {
            pathNodes.add(edge.getSource());
            pathNodes.add(edge.getTarget());
        }
        HashSet<DiagramNode<T>> hashSet = pathNodes;
        if (hashSet == null) {
            DiagramUtils.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public static <T> void removeNonSelectedDependencies(@NotNull DiagramDataModel<T> diagramDataModel) {
        if (diagramDataModel == null) {
            DiagramUtils.$$$reportNull$$$0(7);
        }
        DiagramUtils.removeNonSelectedDependencies(diagramDataModel, DiagramUtils.getSelectedNodes(diagramDataModel.getBuilder()));
    }

    public static <T> void removeNonSelectedDependencies(@NotNull DiagramDataView<T> diagramDataView, @NotNull List<DiagramNode> selectedNodes) {
        if (diagramDataView == null) {
            DiagramUtils.$$$reportNull$$$0(8);
        }
        if (selectedNodes == null) {
            DiagramUtils.$$$reportNull$$$0(9);
        }
        if (selectedNodes.isEmpty()) {
            return;
        }
        Set edgesToRemove = diagramDataView.getEdges().stream().filter(edge -> !selectedNodes.contains(edge.getSource()) && !selectedNodes.contains(edge.getTarget())).collect(Collectors.toSet());
        diagramDataView.getEdges().removeAll(edgesToRemove);
        HashSet<DiagramNode> collectedNodes = new HashSet<DiagramNode>(selectedNodes);
        for (DiagramEdge<T> edge2 : diagramDataView.getEdges()) {
            collectedNodes.add(edge2.getTarget());
            collectedNodes.add(edge2.getSource());
        }
        for (DiagramNode node : diagramDataView.getNodes().toArray(new DiagramNode[0])) {
            if (collectedNodes.contains(node)) continue;
            diagramDataView.getNodes().remove(node);
        }
    }

    public static <T> Graph<DiagramNode<T>> dataModelToGraph(@NotNull DiagramDataView<T> diagramDataView) {
        if (diagramDataView == null) {
            DiagramUtils.$$$reportNull$$$0(10);
        }
        final HashSet<DiagramNode<T>> allNodes = new HashSet<DiagramNode<T>>(diagramDataView.getNodes());
        final MultiMap outs = new MultiMap();
        final MultiMap ins = new MultiMap();
        for (DiagramEdge<T> edge : diagramDataView.getEdges()) {
            DiagramNode<T> source = edge.getSource();
            DiagramNode<T> target = edge.getTarget();
            outs.putValue(source, target);
            ins.putValue(target, source);
        }
        return new Graph<DiagramNode<T>>(){

            @NotNull
            public Collection<DiagramNode<T>> getNodes() {
                Set set = allNodes;
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            @NotNull
            public Iterator<DiagramNode<T>> getIn(DiagramNode<T> n) {
                Iterator iterator = ins.get(n).iterator();
                if (iterator == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            @NotNull
            public Iterator<DiagramNode<T>> getOut(DiagramNode<T> n) {
                Iterator iterator = outs.get(n).iterator();
                if (iterator == null) {
                    2.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/diagram/util/DiagramUtils$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public static Color getFileTabBackground(@NotNull DiagramBuilder builder, Object element) {
        if (builder == null) {
            DiagramUtils.$$$reportNull$$$0(11);
        }
        VirtualFile file = element instanceof VirtualFile ? (VirtualFile)element : (element instanceof PsiElement && ((PsiElement)element).isValid() ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element)) : null);
        return file == null ? null : EditorTabPresentationUtil.getEditorTabBackgroundColor((Project)builder.getProject(), (VirtualFile)file, null);
    }

    @Nullable
    public static Color getFileTabForeground(@NotNull Object element) {
        if (element == null) {
            DiagramUtils.$$$reportNull$$$0(12);
        }
        VirtualFile file = element instanceof PsiElement && ((PsiElement)element).isValid() ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element)) : null;
        return file == null ? null : FileStatusManager.getInstance((Project)((PsiElement)element).getProject()).getStatus(file).getColor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNodes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allEdges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathEdges";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/util/DiagramUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagramDataModel";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagramDataView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/util/DiagramUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathsFromRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findEdge";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectNodes";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeNonSelectedDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dataModelToGraph";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileTabBackground";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileTabForeground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

