/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeItemComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.RepaintManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class DiagramNodeBodyComponent
extends JBList<Object>
implements ListCellRenderer<Object> {
    private static final String ourRepaintManagerClassName;
    private static final JComponent ourSeparatorComponent;
    private final DiagramNodeItemComponent myItemComponent;
    private final DiagramBuilder myBuilder;
    private final Point myBasePoint;
    private final DiagramNode myNode;

    public DiagramNodeBodyComponent(@NotNull DiagramNode node, @NotNull DiagramBuilder builder, Point point) {
        if (node == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(1);
        }
        super(DiagramNodeBodyComponent.getNodeItems(node.getIdentifyingElement(), builder));
        this.myItemComponent = new DiagramNodeItemComponent();
        this.myNode = node;
        this.myBuilder = builder;
        this.myBasePoint = point;
        this.disableEmptyText();
        this.setCellRenderer(this);
        this.setOpaque(false);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (DiagramNodeBodyComponent.this.getSelectedValue() == null && (index = DiagramNodeBodyComponent.this.getSelectedIndex()) != -1) {
                    DiagramNodeBodyComponent.this.setSelectedIndex(index + (e.getLastIndex() == index ? 1 : -1));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !DiagramNodeBodyComponent.this.getComponentPopupMenu().isVisible()) {
                    Point point = e.getPoint();
                    int index = DiagramNodeBodyComponent.this.locationToIndex(point);
                    DiagramNodeBodyComponent.this.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Uml.NodeCellEditorPopup");
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("StructureViewPopup", group);
        this.setComponentPopupMenu(menu.getComponent());
        this.setExpandableItemsEnabled(false);
    }

    public Dimension getPreferredSize() {
        return this.super_getPreferredSize();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return ourSeparatorComponent;
        }
        this.myItemComponent.setUp(this.myBuilder, this.myNode, value, isSelected);
        this.myItemComponent.setSelected(isSelected);
        return this.myItemComponent;
    }

    public Point getPopupLocation(MouseEvent event) {
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.myBasePoint.x - p.x + event.getX(), this.myBasePoint.y - p.y + event.getY());
    }

    /*
     * Could not resolve type clashes
     */
    public static Object[] getNodeItems(Object element, DiagramBuilder builder) {
        ArrayList<Object> elements = new ArrayList<Object>();
        DiagramProvider umlProvider = builder.getProvider();
        DiagramVisibilityManager visibilityManager = builder.getDataModel().getVisibilityManager();
        VisibilityLevel visibility = visibilityManager.getCurrentVisibilityLevel();
        Comparator<VisibilityLevel> comparator = visibilityManager.getComparator();
        List<DiagramCategory> enabled = Arrays.asList(builder.getPresentation().getEnabledCategories());
        Object[] items = umlProvider.getElementManager().getNodeItems(element);
        DiagramCategory[] categories = umlProvider.getNodeContentManager().getContentCategories();
        if (categories.length != 0) {
            for (DiagramCategory category : categories) {
                if (!enabled.contains(category)) continue;
                ArrayList<Object> nodeElements = new ArrayList<Object>();
                for (Object elem : items) {
                    if (!umlProvider.getNodeContentManager().isInCategory(elem, category, builder.getPresentation())) continue;
                    nodeElements.add(elem);
                }
                if (nodeElements.isEmpty()) continue;
                boolean added = false;
                for (Object nodeElement : nodeElements) {
                    VisibilityLevel level = visibilityManager.getVisibilityLevel(nodeElement);
                    if (comparator.compare(level, visibility) > 0) continue;
                    elements.add(nodeElement);
                    added = true;
                }
                if (!added) continue;
                elements.add(null);
            }
        } else {
            elements.addAll(Arrays.asList(items));
        }
        if (!elements.isEmpty() && elements.get(elements.size() - 1) == null) {
            elements.remove(elements.size() - 1);
        }
        return ArrayUtil.toObjectArray(elements);
    }

    public void revalidate() {
        block5: {
            RepaintManager manager = RepaintManager.currentManager((JComponent)((Object)this));
            if (manager != null && !ourRepaintManagerClassName.equals(manager.getClass().getName())) {
                try {
                    RepaintManager originalManager = (RepaintManager)ReflectionUtil.getField(manager.getClass(), (Object)manager, RepaintManager.class, (String)"b");
                    if (originalManager == null) {
                        super.revalidate();
                        break block5;
                    }
                    originalManager.addInvalidComponent((JComponent)((Object)this));
                    this.invalidate();
                }
                catch (Throwable ignored) {
                    super.revalidate();
                }
            } else {
                super.revalidate();
            }
        }
    }

    static {
        ourSeparatorComponent = new JPanel();
        ourSeparatorComponent.setBackground((Color)JBColor.GRAY);
        ourSeparatorComponent.setPreferredSize(new Dimension(-1, 1));
        ourSeparatorComponent.putClientProperty("IgnoreListRowHeight", Boolean.TRUE);
        ourRepaintManagerClassName = RepaintManager.currentManager(ourSeparatorComponent).getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagram/components/DiagramNodeBodyComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

