/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramFileType;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.actions.DiagramCreateNewNodeElementAction;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.messages.MessageBusListener;
import com.intellij.util.messages.Topic;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramProvider<T> {
    public static final ExtensionPointName<DiagramProvider> DIAGRAM_PROVIDER = new ExtensionPointName("com.intellij.diagram.Provider");
    private static final DiagramColorManager defaultColorManager = new DiagramColorManagerBase();
    public static final Key<Object> ORIGINAL_ELEMENT = Key.create((String)"diagram.original.element");

    @Pattern(value="[a-zA-Z0-9_-]*")
    public abstract String getID();

    public abstract DiagramVisibilityManager createVisibilityManager();

    public abstract DiagramNodeContentManager getNodeContentManager();

    public abstract DiagramElementManager<T> getElementManager();

    public abstract DiagramVfsResolver<T> getVfsResolver();

    public abstract DiagramRelationshipManager<T> getRelationshipManager();

    @Nullable
    public DiagramPresentationModel createPresentationModel(Project project, Graph2D graph) {
        return null;
    }

    @NlsContexts.Label
    public abstract String getPresentableName();

    public abstract DiagramDataModel<T> createDataModel(@NotNull Project var1, @Nullable T var2, @Nullable VirtualFile var3, DiagramPresentationModel var4);

    public DiagramColorManager getColorManager() {
        return defaultColorManager;
    }

    @NotNull
    public DiagramExtras<T> getExtras() {
        return new DiagramExtras();
    }

    @Nls
    public String getActionName(boolean isPopup) {
        return DiagramBundle.message("uml.action.name", new Object[0]);
    }

    public Icon getActionIcon(boolean isPopup) {
        return AllIcons.FileTypes.Diagram;
    }

    @Nullable
    public DiagramScopeManager<T> createScopeManager(Project project) {
        return null;
    }

    @Nullable
    public DiagramEdgeCreationPolicy<T> getEdgeCreationPolicy() {
        return null;
    }

    @Nullable
    public static DiagramProvider findByID(String id) {
        for (DiagramProvider provider : (DiagramProvider[])DIAGRAM_PROVIDER.getExtensions()) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public MessageBusListener<?> getMessageBusListener(final @NotNull Project project, final @NotNull Graph2D graph) {
        if (project == null) {
            DiagramProvider.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            DiagramProvider.$$$reportNull$$$0(1);
        }
        return new MessageBusListener<PsiDocumentTransactionListener>(){

            @NotNull
            public Topic<PsiDocumentTransactionListener> getTopic() {
                Topic topic = PsiDocumentTransactionListener.TOPIC;
                if (topic == null) {
                    1.$$$reportNull$$$0(0);
                }
                return topic;
            }

            @NotNull
            public PsiDocumentTransactionListener getListener() {
                return new PsiDocumentTransactionListener(){

                    public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (file == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file) {
                        if (doc == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (file == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        for (VirtualFile vf : FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                            if (!FileTypeRegistry.getInstance().isFileOfType(vf, (FileType)DiagramFileType.INSTANCE)) continue;
                            graph.updateViews();
                            return;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "doc";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/diagram/DiagramProvider$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionStarted";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "transactionCompleted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramProvider$1", "getTopic"));
            }
        };
    }

    public AnAction[] getCreateNewActions() {
        return DiagramCreateNewElementAction.EMPTY;
    }

    public AnAction[] getCreateNewNodeElementActions() {
        return DiagramCreateNewNodeElementAction.EMPTY;
    }

    public DiagramNodeIntentionAction<T>[] getNodeIntentionActions() {
        return DiagramNodeIntentionAction.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "graph";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagram/DiagramProvider";
        objectArray[2] = "getMessageBusListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

