/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Shape;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DiagramColorManagerBase
extends DiagramColorManager {
    @Override
    @NotNull
    public Color getNodeForeground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element, boolean selected) {
        if (builder == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(1);
        }
        if (selected) {
            Color color = (Color)ObjectUtils.notNull((Object)builder.getColorScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR), (Object)UIUtil.getListSelectionForeground((boolean)true));
            if (color == null) {
                DiagramColorManagerBase.$$$reportNull$$$0(2);
            }
            return color;
        }
        Color color = builder.getColorScheme().getDefaultForeground();
        if (color == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(3);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getEdgeColor(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        if (builder == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(4);
        }
        if (edge == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(5);
        }
        DiagramRelationshipInfo relationship = edge.getRelationship();
        EditorColorsScheme scheme = builder.getColorScheme();
        if (relationship.getStartArrow() == DiagramRelationshipInfo.DELTA) {
            if (relationship.getLineType() == DiagramLineType.SOLID) {
                Color color = Objects.requireNonNull(scheme.getColor(DiagramColors.GENERALIZATION_EDGE));
                if (color == null) {
                    DiagramColorManagerBase.$$$reportNull$$$0(6);
                }
                return color;
            }
            if (relationship.getLineType() == DiagramLineType.DASHED) {
                Color color = Objects.requireNonNull(scheme.getColor(DiagramColors.REALIZATION_EDGE));
                if (color == null) {
                    DiagramColorManagerBase.$$$reportNull$$$0(7);
                }
                return color;
            }
        }
        if (!DiagramColorManagerBase.isArrow(relationship.getEndArrow()) && !DiagramColorManagerBase.isArrow(relationship.getStartArrow()) && relationship.getLineType() == DiagramLineType.DOTTED) {
            Color color = Objects.requireNonNull(scheme.getColor(DiagramColors.ANNOTATION_EDGE));
            if (color == null) {
                DiagramColorManagerBase.$$$reportNull$$$0(8);
            }
            return color;
        }
        Color color = Objects.requireNonNull(scheme.getColor(DiagramColors.DEFAULT_EDGE));
        if (color == null) {
            DiagramColorManagerBase.$$$reportNull$$$0(9);
        }
        return color;
    }

    private static boolean isArrow(Shape arrow) {
        return arrow != null && arrow != DiagramRelationshipInfo.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramColorManagerBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramColorManagerBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeForeground";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForeground";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

