/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;

public class DiagramCategory {
    public static final DiagramCategory[] EMPTY_ARRAY = new DiagramCategory[0];
    @Nls
    private final String name;
    private final boolean myRefreshLayout;
    private final Icon icon;
    private final boolean enabledByDefault;
    private final boolean refreshDataModel;
    private boolean fitContent = false;

    public DiagramCategory(@Nls String name, Icon icon) {
        this(name, icon, false, false);
    }

    public DiagramCategory(@Nls String name, Icon icon, boolean enabledByDefault) {
        this(name, icon, enabledByDefault, false);
    }

    public DiagramCategory(@Nls String name, Icon icon, boolean enabledByDefault, boolean refreshDataModel) {
        this(name, icon, enabledByDefault, refreshDataModel, true);
    }

    public DiagramCategory fitContent(boolean fitContent) {
        this.fitContent = fitContent;
        return this;
    }

    public DiagramCategory(@Nls String name, Icon icon, boolean enabledByDefault, boolean refreshDataModel, boolean refreshLayout) {
        this.name = name;
        this.myRefreshLayout = refreshLayout;
        this.icon = icon == null ? PlatformIcons.ERROR_INTRODUCTION_ICON : icon;
        this.enabledByDefault = enabledByDefault;
        this.refreshDataModel = refreshDataModel;
    }

    @Nls
    public String getName() {
        return this.name;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public boolean isFitContent() {
        return this.fitContent;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramCategory that = (DiagramCategory)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isRefreshDataModel() {
        return this.refreshDataModel;
    }

    public boolean isRefreshLayout() {
        return this.myRefreshLayout;
    }
}

