/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.Files;
import com.vladium.util.SocketMutex;
import com.vladium.util.exception.AbstractException;
import java.io.File;

public interface IFileLock {
    public static final String LOCK_ACQUIRED_ALREADY = "LOCK_ACQUIRED_ALREADY";
    public static final String LOCK_ACQUISITION_FAILURE = "LOCK_ACQUISITION_FAILURE";
    public static final String LOCK_ACQUISITION_SECURITY_FAILURE = "LOCK_ACQUISITION_SECURITY_FAILURE";
    public static final String LOCK_ACQUISITION_TIMEOUT = "LOCK_ACQUISITION_TIMEOUT";

    public void acquire() throws FileLockException, InterruptedException;

    public void release();

    public static final class FileLockException
    extends AbstractException {
        FileLockException(String message) {
            super(message);
        }

        FileLockException(String message, Object[] arguments) {
            super(message, arguments);
        }

        FileLockException(Throwable cause) {
            super(cause);
        }

        FileLockException(String message, Throwable cause) {
            super(message, cause);
        }

        FileLockException(String message, Object[] arguments, Throwable cause) {
            super(message, arguments, cause);
        }
    }

    public static abstract class Factory {
        public static IFileLock create(File file, int portbase, long timeout, int retries) {
            if (file == null) {
                throw new IllegalArgumentException("null input: file");
            }
            if (portbase < 0 || portbase > 65280) {
                throw new IllegalArgumentException("port must be in [1, 65280] range: " + portbase);
            }
            File canonicalFile = Files.canonicalizeFile(file);
            int portoffset = Math.abs(canonicalFile.hashCode()) % 255;
            return new SocketMutex(timeout, retries, portbase + portoffset);
        }
    }
}

