/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameAttributeQuickFix
implements LintIdeQuickFix {
    private final String myNamespace;
    private final String myLocalName;

    public RenameAttributeQuickFix(@Nullable String namespace, @NotNull String localName) {
        if (localName == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(0);
        }
        this.myNamespace = namespace;
        this.myLocalName = localName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        if (startElement == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(3);
        }
        if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false)) == null) {
            return;
        }
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return;
        }
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class);
        if (xmlFile == null) {
            return;
        }
        if (this.myNamespace != null) {
            String prefix = LintIdeSupport.get().ensureNamespaceImported(xmlFile, this.myNamespace, null);
            attribute.setName(prefix + ":" + this.myLocalName);
        } else {
            attribute.setName(this.myLocalName);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(6);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Use " + this.myLocalName;
        if (string == null) {
            RenameAttributeQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/RenameAttributeQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/RenameAttributeQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

