/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class LintIdeProject
extends Project {
    public static final boolean SUPPORT_CLASS_FILES = false;
    protected AndroidVersion myMinSdkVersion;
    protected AndroidVersion myTargetSdkVersion;

    protected LintIdeProject(LintClient client, File dir, File referenceDir) {
        super(client, dir, referenceDir);
    }

    static List<Project> create(LintIdeClient client, @Nullable List<VirtualFile> files, Module ... modules) {
        ArrayList<Project> projects = new ArrayList<Project>();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        if (files != null && !files.isEmpty()) {
            files = Lists.newArrayList(files);
        }
        for (Module module : modules) {
            LintIdeProject.addProjects(client, module, files, moduleMap, projectMap, projects);
        }
        client.setModuleMap(projectMap);
        if (projects.size() > 1) {
            HashSet<Project> roots = new HashSet<Project>(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    static Pair<Project, Project> createForSingleFile(LintIdeClient client, @Nullable VirtualFile file, Module module) {
        LintModuleProject project = LintIdeProject.createModuleProject(client, module);
        Object main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            project.setDirectLibraries(Collections.emptyList());
            if (file != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            projectMap.put(project, module);
        }
        client.setModuleMap(projectMap);
        return Pair.create((Object)((Object)project), main);
    }

    private static void addProjects(LintClient client, Module module, @Nullable List<VirtualFile> files, Map<Module, Project> moduleMap, Map<Project, Module> projectMap, List<Project> projects) {
        if (moduleMap.containsKey(module)) {
            return;
        }
        LintModuleProject project = LintIdeProject.createModuleProject(client, module);
        if (project == null) {
            return;
        }
        project.setIdeaProject(module.getProject());
        projects.add(project);
        moduleMap.put(module, project);
        projectMap.put(project, module);
        if (LintIdeProject.processFileFilter(module, files, project)) {
            return;
        }
        ArrayList<Project> dependencies = new ArrayList<Project>();
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        ArrayList<Module> deps = new ArrayList<Module>();
        int i = entries.length;
        while (--i >= 0) {
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            OrderEntry orderEntry = entries[i];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null) continue;
            deps.add(depModule);
        }
        for (Module depModule : deps) {
            Project p = moduleMap.get(depModule);
            if (p != null) {
                dependencies.add(p);
                continue;
            }
            LintIdeProject.addProjects(client, depModule, files, moduleMap, projectMap, dependencies);
        }
        project.setDirectLibraries(dependencies);
    }

    public static boolean processFileFilter(Module module, @Nullable List<VirtualFile> files, LintModuleProject project) {
        if (files != null && !files.isEmpty()) {
            ListIterator<VirtualFile> iterator = files.listIterator();
            while (iterator.hasNext()) {
                VirtualFile file = iterator.next();
                if (!module.getModuleContentScope().accept(file)) continue;
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                iterator.remove();
            }
            if (files.isEmpty()) {
                project.setDirectLibraries(Collections.emptyList());
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LintModuleProject createModuleProject(LintClient client, Module module) {
        File dir = LintIdeProject.getLintProjectDirectory(module);
        if (dir == null) {
            return null;
        }
        LintModuleProject project = new LintModuleProject(client, dir, dir, module);
        client.registerProject(dir, (Project)project);
        return project;
    }

    @Nullable
    public static File getLintProjectDirectory(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 1) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)contentRoots[0]);
        }
        return LintIdeSupportKt.getModuleDir(module);
    }

    protected void initialize() {
    }

    @Nullable
    public com.intellij.openapi.project.Project getIdeaProject() {
        if (this.client instanceof LintIdeClient) {
            return ((LintIdeClient)this.client).myProject;
        }
        return super.getIdeaProject();
    }

    public static class LintModuleProject
    extends LintIdeProject {
        private final Module myModule;

        public void setDirectLibraries(List<Project> libraries) {
            this.directLibraries = libraries;
        }

        public LintModuleProject(LintClient client, File dir, File referenceDir, Module module) {
            super(client, dir, referenceDir);
            this.myModule = module;
        }

        public boolean isAndroidProject() {
            return false;
        }

        protected boolean includeTests() {
            return false;
        }

        public List<File> getJavaSourceFolders() {
            if (this.javaSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(false);
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                for (VirtualFile root : sourceRoots) {
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.javaSourceFolders = dirs;
            }
            return this.javaSourceFolders;
        }

        public List<File> getGeneratedSourceFolders() {
            if (this.generatedSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(this.includeTests());
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                for (VirtualFile root : sourceRoots) {
                    if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.generatedSourceFolders = dirs;
            }
            return this.generatedSourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.testSourceFolders == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.myModule);
                Object[] sourceRoots = manager.getSourceRoots(false);
                VirtualFile[] sourceAndTestRoots = manager.getSourceRoots(true);
                com.intellij.openapi.project.Project project = this.myModule.getProject();
                ArrayList<File> dirs = new ArrayList<File>(sourceAndTestRoots.length);
                for (VirtualFile root : sourceAndTestRoots) {
                    if (ArrayUtil.contains((Object)root, (Object[])sourceRoots) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)root, (com.intellij.openapi.project.Project)project)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.testSourceFolders = dirs;
            }
            return this.testSourceFolders;
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }
    }
}

