/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class LintIdeGradleVisitor
extends GradleVisitor {
    private static String getClosureName(GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getDotToken() == null) {
            return invokedExpression.getReferenceName();
        }
        return null;
    }

    public void visitBuildScript(final @NotNull GradleContext context, final @NotNull List<? extends GradleScanner> detectors) {
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(0);
        }
        if (detectors == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = LintIdeUtilsKt.getPsiFile((Context)context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    public void visitClosure(@NotNull GrClosableBlock closure) {
                        GrClosableBlock block;
                        if (closure == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String parentName = LintIdeGradleVisitor.getClosureName(closure);
                        String parentParentName = null;
                        if (parentName != null && (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true)) != null) {
                            parentParentName = LintIdeGradleVisitor.getClosureName(block);
                        }
                        if (parentName != null) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                GrReferenceExpression propertyRef;
                                String property;
                                GrExpression lValue;
                                GrMethodCallExpression assignment;
                                String value;
                                if (element instanceof GrApplicationStatement) {
                                    GrReferenceExpression propertyRef2;
                                    String property2;
                                    GrApplicationStatement call = (GrApplicationStatement)element;
                                    GrExpression propertyExpression = call.getInvokedExpression();
                                    GrCommandArgumentList argumentList = call.getArgumentList();
                                    if (!(propertyExpression instanceof GrReferenceExpression) || (property2 = (propertyRef2 = (GrReferenceExpression)propertyExpression).getReferenceName()) == null || argumentList == null) continue;
                                    value = argumentList.getText();
                                    for (GradleScanner detector : detectors) {
                                        detector.checkDslPropertyAssignment(context, property2, value, parentName, parentParentName, (Object)propertyRef2, (Object)argumentList, (Object)call);
                                    }
                                    continue;
                                }
                                if (element instanceof GrMethodCallExpression) {
                                    GrExpression[] list;
                                    assignment = (GrMethodCallExpression)element;
                                    lValue = assignment.getInvokedExpression();
                                    if (!(lValue instanceof GrReferenceExpression) || (property = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null || (list = assignment.getArgumentList().getExpressionArguments()).length != 1) continue;
                                    GrExpression rValue2 = list[0];
                                    String value2 = rValue2.getText();
                                    for (GradleScanner detector : detectors) {
                                        detector.checkDslPropertyAssignment(context, property, value2, parentName, parentParentName, (Object)lValue, (Object)rValue2, (Object)assignment);
                                    }
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression) || (property = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null || (rValue = assignment.getRValue()) == null) continue;
                                value = rValue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, (Object)lValue, (Object)rValue, (Object)assignment);
                                }
                                if (parentName.equals("ext") || !property.equals("minSdkVersion") && !property.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message = String.format("Do not use assignment with the %1$s property (remove the '=')", property);
                                context.report(GradleDetector.IDE_SUPPORT, location, message, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                        GrClosableBlock block;
                        if (applicationStatement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        String parentName = (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true)) != null ? LintIdeGradleVisitor.getClosureName(block) : null;
                        String statementName = applicationStatement.getInvokedExpression().getText();
                        GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                        HashMap namedArguments = Maps.newHashMap();
                        ArrayList<String> unnamedArguments = new ArrayList<String>();
                        for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
                            if (groovyPsiElement instanceof GrNamedArgument) {
                                Object value;
                                GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                                GrExpression expression = namedArgument.getExpression();
                                if (!(expression instanceof GrLiteral) || (value = ((GrLiteral)expression).getValue()) == null) continue;
                                namedArguments.put(namedArgument.getLabelName(), value.toString());
                            } else if (groovyPsiElement instanceof GrExpression) {
                                unnamedArguments.add(groovyPsiElement.getText());
                            }
                            for (GradleScanner detector : detectors) {
                                detector.checkMethodCall(context, statementName, parentName, (Map)namedArguments, unnamedArguments, (Object)applicationStatement);
                            }
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "closure";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "applicationStatement";
                                break;
                            }
                        }
                        objectArray2[1] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClosure";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitApplicationStatement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        });
    }

    public int getStartOffset(@NotNull GradleContext context, @NotNull Object cookie) {
        int startOffset;
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(2);
        }
        if (cookie == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(3);
        }
        if ((startOffset = super.getStartOffset(context, cookie)) != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    public Object getPropertyPairCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        return element.getParent();
    }

    public Object getPropertyKeyCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        PsiElement parent = element.getParent();
        if (parent instanceof GrApplicationStatement) {
            GrApplicationStatement call = (GrApplicationStatement)parent;
            return call.getInvokedExpression();
        }
        if (parent instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)parent;
            return assignment.getLValue();
        }
        return super.getPropertyKeyCookie(cookie);
    }

    @NotNull
    public Location createLocation(@NotNull GradleContext context, @NotNull Object cookie) {
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(4);
        }
        if (cookie == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(5);
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        Location location = Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
        if (location == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(6);
        }
        return location;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectors";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookie";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitBuildScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLocation";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

