/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniScanner;
import com.intellij.javaee.oss.jetty.server.JettyModulesResolver;
import com.intellij.javaee.oss.jetty.version.JettyVersion91Handler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.execution.application.AppMainV2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JettyVersion94Handler
extends JettyVersion91Handler {
    private static final Logger LOG = Logger.getInstance(JettyVersion94Handler.class);

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull String workingDirectory, @NotNull String homeDirectory, @NotNull Collection<String> configurationFiles) {
        if (workingDirectory == null) {
            JettyVersion94Handler.$$$reportNull$$$0(0);
        }
        if (homeDirectory == null) {
            JettyVersion94Handler.$$$reportNull$$$0(1);
        }
        if (configurationFiles == null) {
            JettyVersion94Handler.$$$reportNull$$$0(2);
        }
        HashSet<String> modules = new HashSet<String>();
        modules.addAll(JettyVersion94Handler.getActiveModules(workingDirectory));
        modules.addAll(JettyVersion94Handler.getCommandLineModules(configurationFiles));
        JettyJavaParametersForSeparateProcess jettyJavaParametersForSeparateProcess = JettyVersion94Handler.isStartingInSeparateProcess(new HashSet<String>(), new JettyModulesResolver(workingDirectory, homeDirectory), modules) ? new JettyJavaParametersForSeparateProcess(this.getStartClassName()) : super.createJavaParameters(workingDirectory, homeDirectory, configurationFiles);
        if (jettyJavaParametersForSeparateProcess == null) {
            JettyVersion94Handler.$$$reportNull$$$0(3);
        }
        return jettyJavaParametersForSeparateProcess;
    }

    @NotNull
    private static Collection<String> getActiveModules(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            JettyVersion94Handler.$$$reportNull$$$0(4);
        }
        Collection collection = JettyIniScanner.getIniFiles(workingDirectory).stream().flatMap(iniFile -> new JettyIniModuleProcessor((File)iniFile).getActiveModules().stream()).collect(Collectors.toSet());
        if (collection == null) {
            JettyVersion94Handler.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static boolean isStartingInSeparateProcess(@NotNull Set<String> processedModules, @NotNull JettyModulesResolver modulesResolver, @NotNull Collection<String> modules) {
        if (processedModules == null) {
            JettyVersion94Handler.$$$reportNull$$$0(6);
        }
        if (modulesResolver == null) {
            JettyVersion94Handler.$$$reportNull$$$0(7);
        }
        if (modules == null) {
            JettyVersion94Handler.$$$reportNull$$$0(8);
        }
        for (String module : modules) {
            JettyModuleContentProcessor processor;
            File moduleFile;
            if (!processedModules.add(module) || (moduleFile = modulesResolver.getModuleFile(module)) == null || !(processor = new JettyModuleContentProcessor(moduleFile)).isStartingInSeparateProcess() && !JettyVersion94Handler.isStartingInSeparateProcess(processedModules, modulesResolver, processor.getDependModules())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedModules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveModules";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStartingInSeparateProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JettyJavaParametersForSeparateProcess
    extends JavaParameters {
        private final String myJettyMainClass;

        JettyJavaParametersForSeparateProcess(@NotNull String jettyMainClass) {
            if (jettyMainClass == null) {
                JettyJavaParametersForSeparateProcess.$$$reportNull$$$0(0);
            }
            this.myJettyMainClass = jettyMainClass;
        }

        @NotNull
        public GeneralCommandLine toCommandLine() throws CantRunException {
            ParametersList originalProgramParameters;
            ParametersList originalVMParameters;
            String mainClass = this.getMainClass();
            JavaParameters newParameters = new JavaParameters();
            ParametersList newProgramParameters = newParameters.getProgramParametersList();
            if (AppMainV2.class.getName().equals(mainClass)) {
                originalVMParameters = this.getVMParametersList().clone();
                originalProgramParameters = this.getProgramParametersList().clone();
                ParametersList newVMParameters = newParameters.getVMParametersList();
                JettyJavaParametersForSeparateProcess.redefineProperty(newVMParameters, originalVMParameters, "idea.launcher.port");
                JettyJavaParametersForSeparateProcess.redefineProperty(newVMParameters, originalVMParameters, "idea.launcher.bin.path");
                newProgramParameters.add(this.myJettyMainClass);
                originalProgramParameters.replaceOrPrepend(this.myJettyMainClass, "");
            } else {
                originalVMParameters = this.getVMParametersList();
                originalProgramParameters = this.getProgramParametersList();
            }
            newProgramParameters.addAll(originalVMParameters.getParameters());
            newProgramParameters.addAll(originalProgramParameters.getParameters());
            newParameters.setWorkingDirectory(this.getWorkingDirectory());
            newParameters.setEnv(this.getEnv());
            newParameters.setPassParentEnvs(this.isPassParentEnvs());
            newParameters.setJdk(this.getJdk());
            newParameters.setMainClass(mainClass);
            newParameters.getClassPath().addAll(this.getClassPath().getPathList());
            newParameters.setCharset(this.getCharset());
            newParameters.setUseDynamicVMOptions(this.isDynamicVMOptions());
            newParameters.setUseDynamicParameters(this.isDynamicParameters());
            newParameters.setUseClasspathJar(this.isUseClasspathJar());
            newParameters.setArgFile(this.isArgFile());
            newParameters.setClasspathFile(this.isClasspathFile());
            newParameters.setUseDynamicClasspath(this.isDynamicClasspath());
            newParameters.setJarPath(this.getJarPath());
            GeneralCommandLine generalCommandLine = newParameters.toCommandLine();
            if (generalCommandLine == null) {
                JettyJavaParametersForSeparateProcess.$$$reportNull$$$0(1);
            }
            return generalCommandLine;
        }

        private static void redefineProperty(@NotNull ParametersList newParameters, @NotNull ParametersList originalParameters, @NotNull String propertyName) {
            if (newParameters == null) {
                JettyJavaParametersForSeparateProcess.$$$reportNull$$$0(2);
            }
            if (originalParameters == null) {
                JettyJavaParametersForSeparateProcess.$$$reportNull$$$0(3);
            }
            if (propertyName == null) {
                JettyJavaParametersForSeparateProcess.$$$reportNull$$$0(4);
            }
            newParameters.defineProperty(propertyName, originalParameters.getPropertyValue(propertyName));
            originalParameters.replaceOrPrepend("-D" + propertyName, "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jettyMainClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyJavaParametersForSeparateProcess";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalParameters";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyJavaParametersForSeparateProcess";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "redefineProperty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JettyModuleContentProcessor {
        private static final Pattern SECTION = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
        private boolean myStartingInSeparateProcess;
        private final Set<String> myDependModules;

        JettyModuleContentProcessor(@NotNull File moduleFile) {
            if (moduleFile == null) {
                JettyModuleContentProcessor.$$$reportNull$$$0(0);
            }
            this.myStartingInSeparateProcess = false;
            this.myDependModules = new HashSet<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(moduleFile), StandardCharsets.UTF_8));){
                String line;
                boolean dependSection = false;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    Matcher matcher = SECTION.matcher(line);
                    if (matcher.matches()) {
                        switch (StringUtil.toUpperCase((String)matcher.group(1).trim())) {
                            case "EXEC": {
                                this.myStartingInSeparateProcess = true;
                                return;
                            }
                            case "DEPEND": 
                            case "DEPENDS": 
                            case "OPTIONAL": {
                                dependSection = true;
                                break;
                            }
                            default: {
                                dependSection = false;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!dependSection) continue;
                    this.myDependModules.add(line);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        public boolean isStartingInSeparateProcess() {
            return this.myStartingInSeparateProcess;
        }

        @NotNull
        public Collection<String> getDependModules() {
            Set<String> set = this.myDependModules;
            if (set == null) {
                JettyModuleContentProcessor.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyModuleContentProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyModuleContentProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JettyIniModuleProcessor
    extends JettyIniProcessor {
        private final Set<String> myActiveModules;

        JettyIniModuleProcessor(@NotNull File iniFile) {
            if (iniFile == null) {
                JettyIniModuleProcessor.$$$reportNull$$$0(0);
            }
            super(iniFile);
            this.myActiveModules = new HashSet<String>();
        }

        @Override
        protected void processModuleLine(String moduleName, boolean isCommented) {
            if (!isCommented) {
                this.myActiveModules.add(moduleName);
            }
        }

        @NotNull
        public Collection<String> getActiveModules() {
            this.process();
            Set<String> set = this.myActiveModules;
            if (set == null) {
                JettyIniModuleProcessor.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iniFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyIniModuleProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/oss/jetty/version/JettyVersion94Handler$JettyIniModuleProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

