/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminClientImpl;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.admin.JettyAdminServerImpl;
import com.intellij.javaee.oss.jetty.server.JettyContextDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeployTarget;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyModelData;
import com.intellij.javaee.oss.jetty.version.JettyVersion6Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion741Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion7Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion91Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion94Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion9Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JettyServerModel<T extends JettyModelData>
extends JavaeeServerModel {
    private static final JettyVersionHandler VERSION_6_HANDLER = new JettyVersion6Handler();
    private static final JettyVersionHandler VERSION_7_HANDLER = new JettyVersion7Handler();
    private static final JettyVersionHandler VERSION_741_HANDLER = new JettyVersion741Handler();
    private static final JettyVersionHandler VERSION_9_HANDLER = new JettyVersion9Handler();
    private static final JettyVersionHandler VERSION_91_HANDLER = new JettyVersion91Handler();
    private static final JettyVersionHandler VERSION_94_HANDLER = new JettyVersion94Handler();
    @NonNls
    protected static final String DATA_ELEMENT = "data";
    public static final int DEFAULT_JNDI_PORT = 1099;
    public int JNDI_PORT = 1099;
    @NonNls
    private static final String JETTY_LOG_FILE_ID = "Jetty";

    protected String getLogFileId() {
        return JETTY_LOG_FILE_ID;
    }

    @NonNls
    protected String getDefaultUsername() {
        return JettyServerModel.doGetDefaultUsername();
    }

    @NonNls
    protected String getDefaultPassword() {
        return JettyServerModel.doGetDefaultPassword();
    }

    @NonNls
    protected static String doGetDefaultUsername() {
        return "";
    }

    @NonNls
    protected static String doGetDefaultPassword() {
        return "";
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) {
        return new JavaeeAdminClientImpl((JavaeeAdmin)new JettyAdminServerImpl(this.getVersionHandler(), this.getJmxUsername(), this.getJmxPassword()));
    }

    @Nullable
    protected String getJmxUsername() {
        return null;
    }

    @Nullable
    protected String getJmxPassword() {
        return null;
    }

    protected List<File> getLibraries() throws ExecutionException {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("lib"));
        return libraries;
    }

    public int getServerPort() {
        return this.JNDI_PORT;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (this.JNDI_PORT <= 0) {
            throw new RuntimeConfigurationError(JettyBundle.getText("JettyServerModel.error.jmx", new Object[0]));
        }
        HashSet<String> contexts = new HashSet<String>();
        for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
            String contextPath;
            JettyDeploymentModel jettyDeploymentModel = (JettyDeploymentModel)deploymentModel;
            if (!(jettyDeploymentModel.getDeploymentMethod() instanceof JettyContextDeploymentMethod) || jettyDeploymentModel.isDefaultContextRoot() || contexts.add(contextPath = jettyDeploymentModel.getContextRoot())) continue;
            throw new RuntimeConfigurationError(AppServersCommonBundle.getText((String)"JettyServerModel.error.duplicate.context.path.text", (Object[])new Object[]{contextPath}));
        }
    }

    protected void read(@NotNull Element element, boolean isPersistent) throws InvalidDataException {
        Element dataElement;
        if (element == null) {
            JettyServerModel.$$$reportNull$$$0(0);
        }
        if ((dataElement = element.getChild(DATA_ELEMENT)) == null) {
            super.read(element, isPersistent);
        } else {
            JettyModelData settings = (JettyModelData)XmlSerializer.deserialize((Element)dataElement, this.getDataClass());
            this.readFromData(settings);
            this.JNDI_PORT = settings.getJndiPort();
        }
    }

    protected void write(@NotNull Element element, boolean isPersistent) throws WriteExternalException {
        if (element == null) {
            JettyServerModel.$$$reportNull$$$0(1);
        }
        T settings = this.createData();
        this.writeToData(settings);
        settings.setJndiPort(this.JNDI_PORT);
        Element dataElement = XmlSerializer.serialize(settings, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public static JettyVersionHandler getVersionHandler(String versionText) {
        if (StringUtil.isEmpty((String)versionText)) {
            return VERSION_94_HANDLER;
        }
        Version version = new Version(versionText);
        if (version.compare(9, 4, 0) >= 0) {
            return VERSION_94_HANDLER;
        }
        if (version.compare(9, 1, 0) >= 0) {
            return VERSION_91_HANDLER;
        }
        if (version.compare(9, 0, 0) >= 0) {
            return VERSION_9_HANDLER;
        }
        if (version.compare(7, 4, 1) >= 0) {
            return VERSION_741_HANDLER;
        }
        if (version.compare(7, 0, 0) >= 0) {
            return VERSION_7_HANDLER;
        }
        return VERSION_6_HANDLER;
    }

    public JettyVersionHandler getVersionHandler() {
        return JettyServerModel.getVersionHandler(this.getVersion());
    }

    public String getServerSpecificContext(File source) {
        return JettyServerModel.cutWarExtension((File)source);
    }

    public boolean isJetty93Plus() {
        return new Version(this.getVersion()).compare(9, 3, 0) >= 0;
    }

    public abstract boolean transferFile(File var1, JettyDeployTarget var2);

    public abstract boolean deleteFile(File var1, JettyDeployTarget var2);

    protected abstract Class<T> getDataClass();

    protected abstract T createData();

    protected abstract void readFromData(T var1);

    protected abstract void writeToData(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/javaee/oss/jetty/server/JettyServerModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

