/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.oss.server.JavaeePersistentDataWithBase;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JettyPersistentData
extends JavaeePersistentDataWithBase {
    @NonNls
    private static final String STATE_ELEMENT = "state";
    private JettyPersistentState myState = new JettyPersistentState();

    public List<String> getConfigFilePaths() {
        return this.myState.getConfigFilePaths();
    }

    public void setConfigFilePaths(List<String> configFilePaths) {
        this.myState.setConfigFilePaths(configFilePaths);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element content = element.getChild(STATE_ELEMENT);
        if (content == null) {
            super.readExternal(element);
            this.myState = new JettyPersistentState();
        } else {
            this.myState = (JettyPersistentState)XmlSerializer.deserialize((Element)content, JettyPersistentState.class);
            this.HOME = this.myState.getHome();
            this.BASE = this.myState.getBase();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myState.setHome(this.HOME);
        this.myState.setBase(this.BASE);
        Element content = XmlSerializer.serialize((Object)this.myState, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(content);
    }

    @Tag(value="state")
    public static class JettyPersistentState {
        private String myHome = "";
        private String myBase = "";
        private List<String> myConfigFilePaths = new ArrayList<String>();

        public String getHome() {
            return this.myHome;
        }

        public void setHome(String home) {
            this.myHome = home;
        }

        public String getBase() {
            return this.myBase;
        }

        public void setBase(String base) {
            this.myBase = base;
        }

        @AbstractCollection
        public List<String> getConfigFilePaths() {
            return this.myConfigFilePaths;
        }

        public void setConfigFilePaths(List<String> configFilePaths) {
            this.myConfigFilePaths = configFilePaths;
        }
    }
}

