/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.descriptor.JavaeeWebDescriptor;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyContextDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyPersistentDataEditor;
import com.intellij.javaee.oss.jetty.server.JettyServerHelper;
import com.intellij.javaee.oss.jetty.server.JettyServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeDeploymentModelContextEditor;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.util.Function;
import icons.IdeaJettyBaseIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JettyIntegration
extends JavaeeIntegration {
    @NonNls
    private static final String LIB_FOLDER = "lib";
    private static final JettyDeploymentMethod CONTEXT_DEPLOYMENT_METHOD;
    public static final JettyDeploymentMethod DEFAULT_DEPLOYMENT_METHOD;
    private static final DeploymentMethod[] ourDeploymentMethods;

    public static JavaeeIntegration getInstance() {
        return (JavaeeIntegration)AppServerIntegrationsManager.getInstance().getIntegration(JettyIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = JettyBundle.getText("JettyIntegration.name", new Object[0]);
        if (string == null) {
            JettyIntegration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = IdeaJettyBaseIcons.Jetty16x16;
        if (icon == null) {
            JettyIntegration.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = IdeaJettyBaseIcons.Jetty16x16;
        if (icon == null) {
            JettyIntegration.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(JavaeeWebDescriptor.class, JettyWebRootElement.class, "jetty-web");
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) {
        return template.split("_")[0];
    }

    @Nullable
    @NonNls
    public String getVersionFromTemplate(String template) {
        return template.replaceAll("[\\w-]+_(\\d)_(.)\\.xml", "$1.$2");
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String string = JettyServerVersionConfig.get(persistentData);
        if (string == null) {
            JettyIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void checkValidServerHome(String home, String version) throws Exception {
        JettyIntegration.checkFile((String)home, (String)"start.jar");
        JettyIntegration.checkFile((String)home, (String)"bin/jetty.sh");
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        locations.add(new File(home, LIB_FOLDER));
    }

    protected boolean allLibrariesFound(Collection<String> classes, Function<String, String> mapper) {
        throw new UnsupportedOperationException("Should not be called, see `serverHelper#createLibrariesSearch`");
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JavaeeDeploymentProvider(){

            public DeploymentMethod[] getAvailableMethods() {
                return ourDeploymentMethods;
            }
        };
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return new JavaeeDeploymentModelContextEditor(() -> this.createNewDeploymentModel(commonModel, source), JettyBundle.getText("JettyIntegration.contextEditorCaption", new Object[0]));
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new JettyDeploymentModel(commonModel, source);
    }

    protected JavaeeServerHelper createServerHelper() {
        return new JettyServerHelper();
    }

    public ApplicationServerPersistentDataEditor createNewServerEditor() {
        return new JettyPersistentDataEditor();
    }

    @Nullable
    public String getContextRoot(JavaeeFacet facet) {
        return JettyUtil.getContextRoot(facet);
    }

    static {
        DEFAULT_DEPLOYMENT_METHOD = CONTEXT_DEPLOYMENT_METHOD = new JettyContextDeploymentMethod();
        ourDeploymentMethods = new DeploymentMethod[]{CONTEXT_DEPLOYMENT_METHOD};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/oss/jetty/server/JettyIntegration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

